/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.scope.packageSet.FilePatternPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatternPackageSet
implements PackageSet {
    @NonNls
    public static final String SCOPE_TEST = "test";
    @NonNls
    public static final String SCOPE_SOURCE = "src";
    @NonNls
    public static final String SCOPE_LIBRARY = "lib";
    @NonNls
    public static final String SCOPE_PROBLEM = "problem";
    public static final String SCOPE_ANY = "";
    private final Pattern myPattern;
    private final Pattern myModulePattern;
    private final Pattern myModuleGroupPattern;
    private final String myAspectJSyntaxPattern;
    private final String myScope;
    private final String myModulePatternText;

    public PatternPackageSet(@NonNls @Nullable String aspectPattern, @NotNull String scope, @NonNls String modulePattern) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/search/scope/packageSet/PatternPackageSet.<init> must not be null");
        }
        this.myAspectJSyntaxPattern = aspectPattern;
        this.myScope = scope;
        this.myModulePatternText = modulePattern;
        Pattern mmgp = null;
        Pattern mmp = null;
        if (modulePattern == null || modulePattern.length() == 0) {
            mmp = null;
        } else if (modulePattern.startsWith("group:")) {
            int idx = modulePattern.indexOf(58, 6);
            if (idx == -1) {
                idx = modulePattern.length();
            }
            mmgp = Pattern.compile(StringUtil.replace((String)modulePattern.substring(6, idx), (String)"*", (String)".*"));
            if (idx < modulePattern.length() - 1) {
                mmp = Pattern.compile(StringUtil.replace((String)modulePattern.substring(idx + 1), (String)"*", (String)".*"));
            }
        } else {
            mmp = Pattern.compile(StringUtil.replace((String)modulePattern, (String)"*", (String)".*"));
        }
        this.myModulePattern = mmp;
        this.myModuleGroupPattern = mmgp;
        this.myPattern = aspectPattern != null ? Pattern.compile(FilePatternPackageSet.convertToRegexp(aspectPattern, '.')) : null;
    }

    @Override
    public boolean contains(PsiFile file, NamedScopesHolder holder) {
        Project project = file.getProject();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance(project).getFileIndex();
        return this.matchesScope(file, fileIndex) && (this.myPattern == null || this.myPattern.matcher(PatternPackageSet.getPackageName(file, fileIndex)).matches());
    }

    private boolean matchesScope(PsiFile file, ProjectFileIndex fileIndex) {
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            return false;
        }
        boolean isSource = fileIndex.isInSourceContent(vFile);
        if (this.myScope == SCOPE_ANY) {
            return fileIndex.isInContent(vFile) && FilePatternPackageSet.matchesModule(this.myModuleGroupPattern, this.myModulePattern, vFile, fileIndex);
        }
        if (this.myScope == SCOPE_SOURCE) {
            return isSource && !fileIndex.isInTestSourceContent(vFile) && FilePatternPackageSet.matchesModule(this.myModuleGroupPattern, this.myModulePattern, vFile, fileIndex);
        }
        if (this.myScope == SCOPE_LIBRARY) {
            return fileIndex.isInLibraryClasses(vFile) || fileIndex.isInLibrarySource(vFile);
        }
        if (this.myScope == SCOPE_TEST) {
            return isSource && fileIndex.isInTestSourceContent(vFile) && FilePatternPackageSet.matchesModule(this.myModuleGroupPattern, this.myModulePattern, vFile, fileIndex);
        }
        if (this.myScope == SCOPE_PROBLEM) {
            return isSource && WolfTheProblemSolver.getInstance(file.getProject()).isProblemFile(vFile) && FilePatternPackageSet.matchesModule(this.myModuleGroupPattern, this.myModulePattern, vFile, fileIndex);
        }
        throw new RuntimeException("Unknown scope: " + this.myScope);
    }

    private static String getPackageName(PsiFile file, ProjectFileIndex fileIndex) {
        VirtualFile virtualFile = file.getVirtualFile();
        if (fileIndex.isInLibrarySource(virtualFile)) {
            return fileIndex.getPackageNameByDirectory(virtualFile.getParent()) + "." + virtualFile.getNameWithoutExtension();
        }
        if (file instanceof PsiJavaFile) {
            return ((PsiJavaFile)file).getPackageName() + "." + virtualFile.getNameWithoutExtension();
        }
        PsiDirectory dir = file.getContainingDirectory();
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(dir);
        return aPackage == null ? file.getName() : aPackage.getQualifiedName() + "." + virtualFile.getNameWithoutExtension();
    }

    @Override
    public PackageSet createCopy() {
        return new PatternPackageSet(this.myAspectJSyntaxPattern, this.myScope, this.myModulePatternText);
    }

    @Override
    public int getNodePriority() {
        return 0;
    }

    @Override
    public String getText() {
        StringBuilder buf = new StringBuilder();
        if (this.myScope != SCOPE_ANY) {
            buf.append(this.myScope);
        }
        if (this.myModulePattern != null || this.myModuleGroupPattern != null) {
            buf.append("[").append(this.myModulePatternText).append("]");
        }
        if (buf.length() > 0) {
            buf.append(':');
        }
        buf.append(this.myAspectJSyntaxPattern);
        return buf.toString();
    }
}

