/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionFilter
implements Filter,
DumbAware {
    private final Project myProject;
    @NonNls
    private static final String AT = "at";
    private static final String AT_PREFIX = "at ";
    private static final String STANDALONE_AT = " at ";
    private static final TextAttributes HYPERLINK_ATTRIBUTES = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.HYPERLINK_ATTRIBUTES);
    private final GlobalSearchScope mySearchScope;

    public ExceptionFilter(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/filters/ExceptionFilter.<init> must not be null");
        }
        this.myProject = project;
        this.mySearchScope = GlobalSearchScope.allScope(this.myProject);
    }

    public ExceptionFilter(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/filters/ExceptionFilter.<init> must not be null");
        }
        this.myProject = scope.getProject();
        this.mySearchScope = scope;
    }

    @Nullable
    static Trinity<String, String, TextRange> parseExceptionLine(String line) {
        int atIndex;
        if (line.startsWith(AT_PREFIX)) {
            atIndex = 0;
        } else {
            atIndex = line.indexOf(STANDALONE_AT);
            if (atIndex < 0) {
                atIndex = line.indexOf(AT_PREFIX);
            }
            if (atIndex < 0) {
                return null;
            }
        }
        int lparenthIndex = line.indexOf(40, atIndex);
        if (lparenthIndex < 0) {
            return null;
        }
        int lastDotIndex = line.lastIndexOf(46, lparenthIndex);
        if (lastDotIndex < 0 || lastDotIndex < atIndex) {
            return null;
        }
        String className = line.substring(atIndex + AT.length() + 1, lastDotIndex).trim();
        String methodName = line.substring(lastDotIndex + 1, lparenthIndex).trim();
        int rparenthIndex = line.indexOf(41, lparenthIndex);
        if (rparenthIndex < 0) {
            return null;
        }
        return Trinity.create((Object)className, (Object)methodName, (Object)new TextRange(lparenthIndex, rparenthIndex));
    }

    @Override
    public Filter.Result applyFilter(String line, int textEndOffset) {
        int rparenthIndex;
        int lparenthIndex;
        String fileAndLine;
        int colonIndex;
        Trinity<String, String, TextRange> info = ExceptionFilter.parseExceptionLine(line);
        if (info == null) {
            return null;
        }
        String className = (String)info.first;
        int dollarIndex = className.indexOf(36);
        if (dollarIndex >= 0) {
            className = className.substring(0, dollarIndex);
        }
        if ((colonIndex = (fileAndLine = line.substring((lparenthIndex = ((TextRange)info.third).getStartOffset()) + 1, rparenthIndex = ((TextRange)info.third).getEndOffset()).trim()).lastIndexOf(58)) < 0) {
            return null;
        }
        String lineString = fileAndLine.substring(colonIndex + 1);
        try {
            int lineNumber = Integer.parseInt(lineString);
            PsiManager manager = PsiManager.getInstance(this.myProject);
            PsiClass aClass = JavaPsiFacade.getInstance(manager.getProject()).findClass(className, this.mySearchScope);
            if (aClass == null && (aClass = JavaPsiFacade.getInstance(manager.getProject()).findClass(className, GlobalSearchScope.allScope(this.myProject))) == null) {
                return null;
            }
            PsiFile file = (PsiFile)aClass.getContainingFile().getNavigationElement();
            if (file == null) {
                return null;
            }
            int textStartOffset = textEndOffset - line.length();
            int highlightStartOffset = textStartOffset + lparenthIndex + 1;
            int highlightEndOffset = textStartOffset + rparenthIndex;
            VirtualFile virtualFile = file.getVirtualFile();
            OpenFileHyperlinkInfo linkInfo = new OpenFileHyperlinkInfo(this.myProject, virtualFile, lineNumber - 1);
            TextAttributes attributes = HYPERLINK_ATTRIBUTES.clone();
            if (!ProjectRootManager.getInstance(this.myProject).getFileIndex().isInContent(virtualFile)) {
                Color color = UIUtil.getTextInactiveTextColor();
                attributes.setForegroundColor(color);
                attributes.setEffectColor(color);
            }
            return new Filter.Result(highlightStartOffset, highlightEndOffset, linkInfo, attributes);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

