/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ProjectRootManager;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.idea.maven.importing.MavenDefaultModifiableModelsProvider;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenResource;

public class MavenFoldersImporter {
    private MavenProject myMavenProject;
    private MavenImportingSettings myImportingSettings;
    private MavenRootModelAdapter myModel;

    public static void updateProjectFolders(final Project project, final boolean updateTargetFoldersOnly) {
        final MavenProjectsManager manager = MavenProjectsManager.getInstance(project);
        final MavenImportingSettings settings = manager.getImportingSettings();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ArrayList<ModifiableRootModel> rootModels = new ArrayList<ModifiableRootModel>();
                for (Module each : ModuleManager.getInstance((Project)project).getModules()) {
                    MavenProject mavenProject = manager.findProject(each);
                    if (mavenProject == null) continue;
                    MavenRootModelAdapter a = new MavenRootModelAdapter(mavenProject, each, new MavenDefaultModifiableModelsProvider(project));
                    new MavenFoldersImporter(mavenProject, settings, a).config(updateTargetFoldersOnly);
                    ModifiableRootModel model = a.getRootModel();
                    if (model.isChanged()) {
                        rootModels.add(model);
                        continue;
                    }
                    model.dispose();
                }
                if (!rootModels.isEmpty()) {
                    ModifiableRootModel[] modelsArray = rootModels.toArray(new ModifiableRootModel[rootModels.size()]);
                    ProjectRootManager.getInstance((Project)project).multiCommit(modelsArray);
                }
            }
        });
    }

    public MavenFoldersImporter(MavenProject mavenProject, MavenImportingSettings settings, MavenRootModelAdapter model) {
        this.myMavenProject = mavenProject;
        this.myImportingSettings = settings;
        this.myModel = model;
    }

    public void config() {
        this.config(false);
    }

    private void config(boolean updateTargetFoldersOnly) {
        if (!updateTargetFoldersOnly) {
            this.configSourceFolders();
            this.configOutputFolders();
        }
        this.configExcludedFolders();
    }

    private void configSourceFolders() {
        ArrayList<String> sourceFolders = new ArrayList<String>();
        ArrayList<String> testFolders = new ArrayList<String>();
        sourceFolders.addAll(this.myMavenProject.getSources());
        testFolders.addAll(this.myMavenProject.getTestSources());
        for (MavenResource mavenResource : this.myMavenProject.getResources()) {
            sourceFolders.add(mavenResource.getDirectory());
        }
        for (MavenResource mavenResource : this.myMavenProject.getTestResources()) {
            testFolders.add(mavenResource.getDirectory());
        }
        for (MavenImporter mavenImporter : MavenImporter.getSuitableImporters(this.myMavenProject)) {
            mavenImporter.collectSourceFolders(this.myMavenProject, sourceFolders);
            mavenImporter.collectTestFolders(this.myMavenProject, testFolders);
        }
        for (String string : sourceFolders) {
            this.myModel.addSourceFolder(string, false);
        }
        for (String string : testFolders) {
            this.myModel.addSourceFolder(string, true);
        }
    }

    private void configOutputFolders() {
        if (this.myImportingSettings.isUseMavenOutput()) {
            this.myModel.useModuleOutput(this.myMavenProject.getOutputDirectory(), this.myMavenProject.getTestOutputDirectory());
        }
        this.myModel.addExcludedFolder(this.myMavenProject.getOutputDirectory());
        this.myModel.addExcludedFolder(this.myMavenProject.getTestOutputDirectory());
    }

    private void configExcludedFolders() {
        File targetDir = new File(this.myMavenProject.getBuildDirectory());
        File generatedDir = new File(this.myMavenProject.getGeneratedSourcesDirectory());
        this.myModel.unregisterAll(targetDir.getPath(), true, false);
        for (File f : this.getChildren(targetDir)) {
            if (!f.isDirectory()) continue;
            if (f.equals(generatedDir)) {
                this.addAllSubDirsAsSources(f);
                continue;
            }
            if (this.myModel.hasRegisteredSourceSubfolder(f) || this.myModel.isAlreadyExcluded(f)) continue;
            this.myModel.addExcludedFolder(f.getPath());
        }
        ArrayList<String> facetExcludes = new ArrayList<String>();
        for (MavenImporter each : MavenImporter.getSuitableImporters(this.myMavenProject)) {
            each.collectExcludedFolders(this.myMavenProject, facetExcludes);
        }
        for (String eachFolder : facetExcludes) {
            this.myModel.unregisterAll(eachFolder, true, true);
            this.myModel.addExcludedFolder(eachFolder);
        }
        if (!this.myModel.hasRegisteredSourceSubfolder(targetDir)) {
            this.myModel.addExcludedFolder(targetDir.getPath());
        }
    }

    private void addAllSubDirsAsSources(File dir) {
        for (File f : this.getChildren(dir)) {
            if (!f.isDirectory() || this.myModel.hasRegisteredSourceSubfolder(f)) continue;
            this.myModel.addSourceFolder(f.getPath(), false);
        }
    }

    private File[] getChildren(File dir) {
        File[] result = dir.listFiles();
        return result == null ? new File[]{} : result;
    }
}

