/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.interfacetoclass;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.siyeh.ipp.base.PsiElementPredicate;

class ConvertInterfaceToClassPredicate
implements PsiElementPredicate {
    ConvertInterfaceToClassPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiClass)) {
            return false;
        }
        PsiClass aClass = (PsiClass)parent;
        if (!aClass.isInterface() || aClass.isAnnotationType()) {
            return false;
        }
        PsiJavaToken leftBrace = aClass.getLBrace();
        int offsetInParent = element.getStartOffsetInParent();
        if (leftBrace == null || offsetInParent >= leftBrace.getStartOffsetInParent()) {
            return false;
        }
        SearchScope useScope = aClass.getUseScope();
        for (PsiClass inheritor : ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)useScope, (boolean)true)) {
            if (!inheritor.isInterface()) continue;
            return false;
        }
        return true;
    }
}

