/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.equality;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.equality.ObjectEqualityPredicate;
import com.siyeh.ipp.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class ReplaceEqualityWithSafeEqualsIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ObjectEqualityPredicate objectEqualityPredicate = new ObjectEqualityPredicate();
        if (objectEqualityPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/equality/ReplaceEqualityWithSafeEqualsIntention.getElementPredicate must not return null");
        }
        return objectEqualityPredicate;
    }

    @Override
    public void processIntention(PsiElement element) throws IncorrectOperationException {
        PsiBinaryExpression exp = (PsiBinaryExpression)element;
        PsiExpression lhs = exp.getLOperand();
        PsiExpression rhs = exp.getROperand();
        if (rhs == null) {
            return;
        }
        PsiExpression strippedLhs = ParenthesesUtils.stripParentheses(lhs);
        if (strippedLhs == null) {
            return;
        }
        PsiExpression strippedRhs = ParenthesesUtils.stripParentheses(rhs);
        if (strippedRhs == null) {
            return;
        }
        String lhsText = strippedLhs.getText();
        String rhsText = strippedRhs.getText();
        PsiJavaToken operationSign = exp.getOperationSign();
        IElementType tokenType = operationSign.getTokenType();
        String signText = operationSign.getText();
        StringBuilder buffer = new StringBuilder(lhsText);
        buffer.append("==null?");
        buffer.append(rhsText);
        buffer.append(signText);
        buffer.append(" null:");
        if (tokenType.equals(JavaTokenType.NE)) {
            buffer.append('!');
        }
        if (ParenthesesUtils.getPrecedence(strippedLhs) > 1) {
            buffer.append('(');
            buffer.append(lhsText);
            buffer.append(')');
        } else {
            buffer.append(lhsText);
        }
        buffer.append(".equals(");
        buffer.append(rhsText);
        buffer.append(')');
        ReplaceEqualityWithSafeEqualsIntention.replaceExpression(buffer.toString(), (PsiExpression)exp);
    }
}

