/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.comment;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.comment.CStyleCommentPredicate;
import org.jetbrains.annotations.NotNull;

public class ChangeToEndOfLineCommentIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        CStyleCommentPredicate cStyleCommentPredicate = new CStyleCommentPredicate();
        if (cStyleCommentPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/comment/ChangeToEndOfLineCommentIntention.getElementPredicate must not return null");
        }
        return cStyleCommentPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/comment/ChangeToEndOfLineCommentIntention.processIntention must not be null");
        }
        PsiComment comment = (PsiComment)element;
        PsiManager manager = comment.getManager();
        CodeStyleManager codeStyleManager = manager.getCodeStyleManager();
        PsiElement parent = comment.getParent();
        assert (parent != null);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        String commentText = comment.getText();
        PsiElement whitespace = comment.getNextSibling();
        String text = commentText.substring(2, commentText.length() - 2);
        String[] lines = text.split("\n");
        for (int i = lines.length - 1; i >= 1; --i) {
            PsiComment nextComment = factory.createCommentFromText("//" + lines[i].trim(), parent);
            parent.addAfter((PsiElement)nextComment, (PsiElement)comment);
            if (whitespace == null) continue;
            PsiElement newWhiteSpace = factory.createWhiteSpaceFromText(whitespace.getText());
            parent.addAfter(newWhiteSpace, (PsiElement)comment);
        }
        PsiComment newComment = factory.createCommentFromText("//" + lines[0], parent);
        PsiElement replacedComment = comment.replace((PsiElement)newComment);
        codeStyleManager.reformat(replacedComment);
    }
}

