/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;

public class ScreenFinder {
    public static GraphicsDevice getCurrentScreen() {
        Point p = MouseInfo.getPointerInfo().getLocation();
        return ScreenFinder.getScreenOnCoords(p);
    }

    public static Rectangle getCurrentScreenSizeWithoutBounds() {
        try {
            Point p = MouseInfo.getPointerInfo().getLocation();
            return ScreenFinder.getScreenOnCoordsWithoutBounds(p);
        }
        catch (HeadlessException ex) {
            return new Rectangle(800, 600);
        }
    }

    public static void centerWindowsToCurrentScreen(Window w) {
        Rectangle bounds = ScreenFinder.getCurrentScreenSizeWithoutBounds();
        w.setLocation(bounds.x + (bounds.width - w.getWidth()) / 2, bounds.y + (bounds.height - w.getHeight()) / 2);
    }

    public static GraphicsDevice getScreenOnCoords(Point point) {
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] devices = e.getScreenDevices();
        GraphicsDevice result = null;
        for (GraphicsDevice device : devices) {
            GraphicsConfiguration[] configurations;
            for (GraphicsConfiguration config : configurations = new GraphicsConfiguration[]{device.getDefaultConfiguration()}) {
                Rectangle gcBounds = config.getBounds();
                if (!gcBounds.contains(point)) continue;
                result = device;
            }
        }
        if (result == null) {
            result = e.getDefaultScreenDevice();
        }
        return result;
    }

    public static Rectangle getScreenOnCoordsWithoutBounds(Point p) {
        try {
            GraphicsDevice device = ScreenFinder.getScreenOnCoords(p);
            Rectangle screenSize = device.getDefaultConfiguration().getBounds();
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(device.getDefaultConfiguration());
            return new Rectangle((int)screenSize.getX() + insets.left, (int)screenSize.getY() + insets.top, (int)screenSize.getWidth() - insets.left, (int)screenSize.getHeight() - insets.bottom);
        }
        catch (HeadlessException ex) {
            return new Rectangle(800, 600);
        }
    }
}

