/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.splashscreen.impls.defaultsplashscreen2012;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.SwingUtilities;
import net.sourceforge.jnlp.splashscreen.SplashUtils;
import net.sourceforge.jnlp.splashscreen.impls.defaultsplashscreen2012.MovingText;
import net.sourceforge.jnlp.splashscreen.impls.defaultsplashscreen2012.SplinesDefs;
import net.sourceforge.jnlp.splashscreen.impls.defaultsplashscreen2012.TextWithWaterLevel;
import net.sourceforge.jnlp.splashscreen.parts.BasicComponentSplashScreen;
import net.sourceforge.jnlp.splashscreen.parts.InfoItem;
import net.sourceforge.jnlp.splashscreen.parts.InformationElement;
import net.sourceforge.jnlp.splashscreen.parts.extensions.ExtensionManager;
import net.sourceforge.jnlp.util.ScreenFinder;

public class BasePainter
implements Observer {
    protected final BasicComponentSplashScreen master;
    private int waterLevel = 0;
    private int animationsPosition = 0;
    private int greyTextIncrment = 15;
    protected static final Color TEA_LIVE_COLOR = new Color(205, 1, 3);
    protected static final Color BACKGROUND_LIVE_COLOR = ExtensionManager.getExtension().getBackground();
    protected static final Color TEA_LEAFS_STALKS_LIVE_COLOR = Color.black;
    protected static final Color PLUGIN_LIVE_COLOR = ExtensionManager.getExtension().getPluginTextColor();
    public static final Color WATER_LIVE_COLOR = new Color(80, 131, 160);
    protected static final Color PLAIN_TEXT_LIVE_COLOR = ExtensionManager.getExtension().getTextColor();
    protected Color teaColor;
    protected Color backgroundColor;
    protected Color teaLeafsStalksColor;
    protected Color pluginColor;
    protected Color waterColor;
    protected Color plainTextColor;
    protected BufferedImage prerenderedStuff;
    private Font teaFont;
    private Font icedFont;
    private Font webFont;
    private Font pluginFont;
    private Font plainTextsFont;
    private Font alternativeTextFont;
    private static final String alternativeICED = "Iced    ";
    private static final String alternativeWeb = "Web  ";
    private static final String alternativeTtea = "    Tea";
    private static final String alternativePlugin = "plugin ";
    private static final String ICED = "Iced";
    private static final String web = "web";
    private static final String tea = "Tea";
    private static final String plugin = "plugin  ";
    private final int WEB_TOP_ALIGMENT = 324;
    private final int WEB_LEFT_ALIGMENT = 84;
    protected boolean showNiceTexts = true;
    private boolean showLeaf = true;
    private boolean showInfo = true;
    protected TextWithWaterLevel twl;
    protected TextWithWaterLevel oldTwl;
    protected boolean canWave = true;

    protected void paintNiceTexts(Graphics2D g2d) {
        this.oldTwl = this.twl;
        this.twl = new TextWithWaterLevel(ICED, this.icedFont);
        if (this.oldTwl != null && !this.canWave) {
            this.twl.setCachedPolygon(this.oldTwl.getCachedPolygon());
        }
        this.twl.setPercentageOfWater(this.waterLevel);
        this.twl.setBgColor(this.backgroundColor);
        this.twl.setWaterColor(this.waterColor);
        this.twl.cutTo(g2d, this.scaleX(42.0), this.scaleY(278.0));
        MovingText mt = new MovingText(web, this.webFont);
        mt.setPercentageOfWater(this.animationsPosition);
        mt.cutTo(g2d, this.scaleX(84.0), this.scaleY(324.0));
    }

    protected void paintPlainTexts(Graphics2D g2d) {
        g2d.setFont(this.alternativeTextFont);
        g2d.setColor(this.waterColor);
        this.drawTextAroundCenter(g2d, -0.6, alternativeICED);
        g2d.setColor(this.teaColor);
        this.drawTextAroundCenter(g2d, -0.6, alternativeTtea);
        g2d.setColor(this.pluginColor);
        String s = this.getAlternativeProductName();
        int sub = this.animationsPosition / this.greyTextIncrment;
        sub %= s.length();
        if (!this.master.isAnimationRunning()) {
            sub = s.length();
        }
        this.drawTextAroundCenter(g2d, 0.3, s.substring(0, sub));
    }

    private int scaleAvarage(double origValue) {
        return (int)(this.avarageRatio() * origValue);
    }

    private int scaleMax(double origValue) {
        return (int)(this.maxRatio() * origValue);
    }

    private int scaleMin(double origValue) {
        return (int)(this.minRatio() * origValue);
    }

    private double avarageRatio() {
        return (this.getRatioX() + this.getRatioY()) / 2.0;
    }

    private double minRatio() {
        return Math.min(this.getRatioX(), this.getRatioY());
    }

    private double maxRatio() {
        return Math.max(this.getRatioX(), this.getRatioY());
    }

    private int scaleY(double origValue) {
        return (int)BasePainter.scaleY(this.master.getSplashHeight(), origValue);
    }

    private int scaleX(double origValue) {
        return (int)BasePainter.scaleX(this.master.getSplashWidth(), origValue);
    }

    private double getRatioY() {
        return BasePainter.getRatio(480.0, this.master.getSplashHeight());
    }

    private double getRatioX() {
        return BasePainter.getRatio(635.0, this.master.getSplashWidth());
    }

    private static double scaleY(double currentSize, double origValue) {
        return BasePainter.scale(480.0, currentSize, origValue);
    }

    private static double scaleX(double currentSize, double origValue) {
        return BasePainter.scale(635.0, currentSize, origValue);
    }

    private static double getRatioY(double currentSize) {
        return BasePainter.getRatio(480.0, currentSize);
    }

    private static double getRatioX(double currentSize) {
        return BasePainter.getRatio(635.0, currentSize);
    }

    public static double scale(double origSize, double currentSize, double origValue) {
        return BasePainter.getRatio(origSize, currentSize) * origValue;
    }

    public static double getRatio(double origSize, double currentSize) {
        return currentSize / origSize;
    }

    public BasePainter(BasicComponentSplashScreen master) {
        this(master, false);
    }

    public BasePainter(BasicComponentSplashScreen master, boolean startAnimation) {
        this.master = master;
        this.setColors();
        this.adjustForSize(master.getSplashWidth(), master.getSplashHeight());
        ExtensionManager.getExtension().adjustForSize(master.getSplashWidth(), master.getSplashHeight());
        if (startAnimation) {
            this.startAnimationThreads();
        }
    }

    public void increaseAnimationPosition() {
        ExtensionManager.getExtension().animate();
        this.animationsPosition += this.greyTextIncrment;
    }

    protected void ensurePrerenderedStuff() {
        if (this.prerenderedStuff == null) {
            this.prerenderedStuff = this.prerenderStill();
        }
    }

    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        this.ensurePrerenderedStuff();
        if (this.prerenderedStuff != null) {
            g2d.drawImage((Image)this.prerenderedStuff, 0, 0, null);
        }
        if (this.showNiceTexts) {
            ExtensionManager.getExtension().paint(g, this);
            this.paintNiceTexts(g2d);
        } else {
            this.paintPlainTexts(g2d);
        }
    }

    public final void adjustForSize(int width, int height) {
        this.prepareFonts(width, height);
        this.setEnablings(width, height, this.master.getVersion(), this.master.getInformationElement(), (Graphics2D)this.master.getGraphics());
        this.prerenderedStuff = this.prerenderStill();
        ExtensionManager.getExtension().adjustForSize(width, height);
    }

    private void setEnablings(int w, int h, String version, InformationElement ic, Graphics2D g2d) {
        this.showLeaf = true;
        if (w > 0 && h > 0 && (h / w > 2 || w / h > 6)) {
            this.showLeaf = false;
        }
        this.showInfo = true;
        if (version != null && g2d != null && ic != null && ic.getHeader() != null && ic.getHeader().size() > 0) {
            String s = ic.getHeader().get(0);
            FontMetrics fm = g2d.getFontMetrics(this.plainTextsFont);
            int versionLength = fm.stringWidth(version);
            int firsDescLineLengthg = fm.stringWidth(s);
            if (firsDescLineLengthg > w - versionLength - 10) {
                this.showInfo = false;
            }
        }
        this.showNiceTexts = !((double)Math.min(h, w) < ScreenFinder.getCurrentScreenSizeWithoutBounds().getHeight() / 10.0);
    }

    public final void startAnimationThreads() {
        Thread tt = this.getMovingTextThread();
        tt.start();
        Thread t = this.getWaterLevelThread();
        t.start();
    }

    private void prepareFonts(int w, int h) {
        this.master.setSplashHeight(h);
        this.master.setSplashWidth(w);
        HashMap<TextAttribute, Object> teaFontAttributes = new HashMap<TextAttribute, Object>();
        teaFontAttributes.put(TextAttribute.SIZE, new Integer(this.scaleMin(84.0)));
        teaFontAttributes.put(TextAttribute.WIDTH, new Double(0.95));
        teaFontAttributes.put(TextAttribute.FAMILY, "Serif");
        this.teaFont = new Font(teaFontAttributes);
        HashMap<TextAttribute, Object> icedFontAttributes = new HashMap<TextAttribute, Object>();
        icedFontAttributes.put(TextAttribute.SIZE, new Integer(this.scaleMin(82.0)));
        icedFontAttributes.put(TextAttribute.WIDTH, new Double(0.8));
        icedFontAttributes.put(TextAttribute.FAMILY, "Serif");
        this.icedFont = new Font(icedFontAttributes);
        HashMap<TextAttribute, Object> webFontAttributes = new HashMap<TextAttribute, Object>();
        webFontAttributes.put(TextAttribute.SIZE, new Integer(this.scaleMin(41.0)));
        webFontAttributes.put(TextAttribute.WIDTH, new Double(2.0));
        webFontAttributes.put(TextAttribute.FAMILY, "Serif");
        this.webFont = new Font(webFontAttributes);
        HashMap<TextAttribute, Object> pluginFontAttributes = new HashMap<TextAttribute, Object>();
        pluginFontAttributes.put(TextAttribute.SIZE, new Integer(this.scaleMin(32.0)));
        pluginFontAttributes.put(TextAttribute.WEIGHT, new Double(5.0));
        pluginFontAttributes.put(TextAttribute.WIDTH, new Double(0.9));
        pluginFontAttributes.put(TextAttribute.FAMILY, "Serif");
        this.pluginFont = new Font(pluginFontAttributes);
        HashMap<TextAttribute, Object> plainFontAttributes = new HashMap<TextAttribute, Object>();
        plainFontAttributes.put(TextAttribute.SIZE, new Integer(12));
        plainFontAttributes.put(TextAttribute.FAMILY, "Monospaced");
        this.plainTextsFont = new Font(plainFontAttributes);
        HashMap<TextAttribute, Object> alternativeTextFontAttributes = new HashMap<TextAttribute, Object>();
        alternativeTextFontAttributes.put(TextAttribute.SIZE, Math.min(w, h) / 5);
        alternativeTextFontAttributes.put(TextAttribute.WIDTH, new Double(0.7));
        alternativeTextFontAttributes.put(TextAttribute.FAMILY, "Monospaced");
        this.alternativeTextFont = new Font(alternativeTextFontAttributes);
    }

    private void setColors() {
        this.teaColor = TEA_LIVE_COLOR;
        this.backgroundColor = BACKGROUND_LIVE_COLOR;
        this.teaLeafsStalksColor = TEA_LEAFS_STALKS_LIVE_COLOR;
        this.pluginColor = PLUGIN_LIVE_COLOR;
        this.waterColor = WATER_LIVE_COLOR;
        this.plainTextColor = PLAIN_TEXT_LIVE_COLOR;
    }

    protected BufferedImage prerenderStill() {
        if (this.master.getSplashWidth() <= 0 || this.master.getSplashHeight() <= 0) {
            return null;
        }
        BufferedImage bi = new BufferedImage(this.master.getSplashWidth(), this.master.getSplashHeight(), 2);
        this.paintStillTo(bi.createGraphics(), this.master.getInformationElement(), this.master.getVersion());
        return bi;
    }

    protected void paintStillTo(Graphics2D g2d, InformationElement ic, String version) {
        RenderingHints r = g2d.getRenderingHints();
        this.drawBase(g2d, ic, version);
        g2d.setRenderingHints(r);
    }

    protected void drawTextAroundCenter(Graphics2D g2d, double heightOffset, String msg) {
        int y = this.master.getSplashHeight() / 2 + (g2d.getFontMetrics().getHeight() / 2 + (int)(heightOffset * (double)g2d.getFontMetrics().getHeight()));
        int x = this.master.getSplashWidth() / 2 - g2d.getFontMetrics().stringWidth(msg) / 2;
        g2d.drawString(msg, x, y);
    }

    private Thread getMovingTextThread() {
        Thread tt = new Thread(new MovingTextRunner(this));
        return tt;
    }

    static String stripCommitFromVersion(String version) {
        if (version.contains("pre+")) {
            return version;
        }
        int i = version.indexOf("+");
        if (i < 0) {
            return version;
        }
        return version.substring(0, version.indexOf("+"));
    }

    private Thread getWaterLevelThread() {
        Thread t = new Thread(new WaterLevelThread(this));
        return t;
    }

    private String getAlternativeProductName() {
        if (SplashUtils.SplashReason.JAVAWS.equals((Object)this.master.getSplashReason())) {
            return alternativeWeb;
        }
        if (SplashUtils.SplashReason.APPLET.equals((Object)this.master.getSplashReason())) {
            return "Web  plugin ";
        }
        return "....";
    }

    protected FontMetrics drawBase(Graphics2D g2d, InformationElement ic, String version) {
        FontMetrics fm;
        g2d.setColor(this.backgroundColor);
        g2d.fillRect(0, 0, this.master.getSplashWidth() + 5, this.master.getSplashHeight() + 5);
        if (this.showNiceTexts) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.setFont(this.teaFont);
            g2d.setColor(this.teaColor);
            g2d.drawString(tea, this.scaleX(42.0) + g2d.getFontMetrics(this.icedFont).stringWidth(ICED), this.scaleY(278.0));
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            if (this.showLeaf) {
                g2d.fillPolygon(SplinesDefs.getMainLeafCurve(this.getRatioX(), this.getRatioY()));
            }
            if (this.showLeaf) {
                g2d.fillPolygon(SplinesDefs.getSecondLeafCurve(this.getRatioX(), this.getRatioY()));
            }
            g2d.setColor(this.teaLeafsStalksColor);
            if (this.showLeaf) {
                g2d.fillPolygon(SplinesDefs.getMainLeafStalkCurve(this.getRatioX(), this.getRatioY()));
            }
            if (this.showLeaf) {
                g2d.fillPolygon(SplinesDefs.getSecondLeafStalkCurve(this.getRatioX(), this.getRatioY()));
            }
            g2d.setFont(this.pluginFont);
            g2d.setColor(this.pluginColor);
            if (SplashUtils.SplashReason.APPLET.equals((Object)this.master.getSplashReason())) {
                if (this.showLeaf) {
                    g2d.drawString(plugin, this.scaleX(404.0), this.scaleY(145.0));
                } else {
                    FontMetrics wfm = g2d.getFontMetrics(this.webFont);
                    g2d.drawString(plugin, wfm.stringWidth(web) + this.scaleX(84.0) + 10, this.scaleY(324.0));
                }
            }
            g2d.setFont(this.plainTextsFont);
            g2d.setColor(this.plainTextColor);
            fm = g2d.getFontMetrics();
            if (ic != null) {
                InfoItem des = ic.getBestMatchingDescriptionForSplash();
                List<String> head = ic.getHeader();
                if (head != null && this.showInfo) {
                    for (int i = 0; i < head.size(); ++i) {
                        String string = head.get(i);
                        g2d.drawString(string, 5, (i + 1) * fm.getHeight());
                    }
                }
                if (des != null && des.getValue() != null) {
                    g2d.drawString(des.getValue(), 5, this.master.getSplashHeight() - fm.getHeight());
                }
            }
        }
        g2d.setFont(this.plainTextsFont);
        g2d.setColor(this.plainTextColor);
        fm = g2d.getFontMetrics();
        if (version != null) {
            String niceVersion = BasePainter.stripCommitFromVersion(version);
            int y = this.master.getSplashWidth() - fm.stringWidth(niceVersion + " ");
            if (y < 0) {
                y = 0;
            }
            g2d.drawString(niceVersion, y, fm.getHeight());
        }
        return fm;
    }

    public int getWaterLevel() {
        return this.waterLevel;
    }

    public void setWaterLevel(int level) {
        this.waterLevel = level;
    }

    public int getAnimationsPosition() {
        return this.animationsPosition;
    }

    public void clearCachedWaterTextImage() {
        this.oldTwl = null;
    }

    @Override
    public void update(Observable o, Object arg) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ExtensionManager.getExtension().animate();
                    BasePainter.this.master.repaint();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Color getWaterColor() {
        return this.waterColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    private final class WaterLevelThread
    extends Observable
    implements Runnable {
        private static final int MAX_WATERLEVEL_VALUE = 120;
        private static final int WATER_LEVEL_INCREMENT = 2;

        private WaterLevelThread(BasePainter o) {
            this.addObserver(o);
        }

        @Override
        public void run() {
            while (BasePainter.this.master.isAnimationRunning() && BasePainter.this.waterLevel <= 120) {
                try {
                    BasePainter.this.waterLevel += 2;
                    this.setChanged();
                    this.notifyObservers();
                    Thread.sleep(BasePainter.this.waterLevel / 4 * 30);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private final class MovingTextRunner
    extends Observable
    implements Runnable {
        private static final int MAX_ANIMATION_VALUE = 10000;
        private static final int ANIMATION_RESTART_VALUE = 1;
        private static final long MOOVING_TEXT_DELAY = 150L;

        public MovingTextRunner(Observer o) {
            this.addObserver(o);
        }

        @Override
        public void run() {
            while (BasePainter.this.master.isAnimationRunning()) {
                try {
                    BasePainter.this.animationsPosition += BasePainter.this.greyTextIncrment;
                    if (BasePainter.this.animationsPosition > 10000) {
                        BasePainter.this.animationsPosition = 1;
                    }
                    this.setChanged();
                    this.notifyObservers();
                    Thread.sleep(150L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

