/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.sourceforge.jnlp.PluginBridge;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.appletextendedsecurity.ExecuteUnsignedApplet;
import net.sourceforge.jnlp.security.appletextendedsecurity.ExtendedAppletSecurityHelp;
import net.sourceforge.jnlp.security.appletextendedsecurity.UnsignedAppletTrustConfirmation;
import net.sourceforge.jnlp.util.ScreenFinder;
import sun.misc.Launcher;

public class UnsignedAppletTrustWarningPanel
extends JPanel {
    private final int PANE_WIDTH = 500;
    private final int TOP_PANEL_HEIGHT = 60;
    private final int INFO_PANEL_HEIGHT = 140;
    private final int INFO_PANEL_HINT_HEIGHT = 25;
    private final int QUESTION_PANEL_HEIGHT = 35;
    private JButton allowButton;
    private JButton rejectButton;
    private JButton helpButton;
    private JCheckBox permanencyCheckBox;
    private JRadioButton applyToAppletButton;
    private JRadioButton applyToCodeBaseButton;
    private PluginBridge file;
    private ActionChoiceListener actionChoiceListener;

    public UnsignedAppletTrustWarningPanel(PluginBridge file, ActionChoiceListener actionChoiceListener) {
        this.file = file;
        this.actionChoiceListener = actionChoiceListener;
        this.addComponents();
    }

    public JButton getAllowButton() {
        return this.allowButton;
    }

    public JButton getRejectButton() {
        return this.rejectButton;
    }

    private String htmlWrap(String text) {
        return "<html>" + text + "</html>";
    }

    private ImageIcon infoImage() {
        String location = "net/sourceforge/jnlp/resources/info-small.png";
        ClassLoader appLoader = new Launcher().getClassLoader();
        return new ImageIcon(appLoader.getResource("net/sourceforge/jnlp/resources/info-small.png"));
    }

    private void setupTopPanel() {
        String topLabelText = Translator.R("SUnsignedSummary");
        JLabel topLabel = new JLabel(this.htmlWrap(topLabelText), this.infoImage(), 2);
        topLabel.setFont(new Font(topLabel.getFont().toString(), 1, 12));
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setBackground(Color.WHITE);
        topPanel.add((Component)topLabel, "Center");
        topPanel.setPreferredSize(new Dimension(500, 60));
        topPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add(topPanel);
    }

    private void setupInfoPanel() {
        String infoLabelText = Translator.R("SUnsignedDetail", this.file.getCodeBase(), this.file.getSourceLocation());
        ExecuteUnsignedApplet rememberedAction = UnsignedAppletTrustConfirmation.getStoredAction(this.file);
        int panelHeight = 140;
        if (rememberedAction == ExecuteUnsignedApplet.YES) {
            infoLabelText = infoLabelText + "<br>" + Translator.R("SUnsignedAllowedBefore");
            panelHeight += 25;
        } else if (rememberedAction == ExecuteUnsignedApplet.NO) {
            infoLabelText = infoLabelText + "<br>" + Translator.R("SUnsignedRejectedBefore");
            panelHeight += 25;
        }
        JLabel infoLabel = new JLabel(this.htmlWrap(infoLabelText));
        JPanel infoPanel = new JPanel(new BorderLayout());
        infoPanel.add((Component)infoLabel, "Center");
        infoPanel.setPreferredSize(new Dimension(500, panelHeight));
        infoPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add(infoPanel);
    }

    private void setupQuestionsPanel() {
        JPanel questionPanel = new JPanel(new BorderLayout());
        questionPanel.add((Component)new JLabel(this.htmlWrap(Translator.R("SUnsignedQuestion"))), "East");
        questionPanel.setPreferredSize(new Dimension(500, 35));
        questionPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.add(questionPanel);
    }

    private JPanel createMatchOptionsPanel() {
        JPanel matchOptionsPanel = new JPanel(new FlowLayout(2));
        ButtonGroup group = new ButtonGroup();
        this.applyToAppletButton = new JRadioButton(Translator.R("SRememberAppletOnly"));
        this.applyToAppletButton.setSelected(true);
        this.applyToAppletButton.setEnabled(false);
        this.applyToCodeBaseButton = new JRadioButton(this.htmlWrap(Translator.R("SRememberCodebase", this.file.getCodeBase())));
        this.applyToCodeBaseButton.setEnabled(false);
        group.add(this.applyToAppletButton);
        group.add(this.applyToCodeBaseButton);
        matchOptionsPanel.add(this.applyToAppletButton);
        matchOptionsPanel.add(this.applyToCodeBaseButton);
        return matchOptionsPanel;
    }

    private JPanel createCheckBoxPanel() {
        JPanel checkBoxPanel = new JPanel(new FlowLayout(0));
        this.permanencyCheckBox = new JCheckBox(this.htmlWrap(Translator.R("SRememberOption")));
        this.permanencyCheckBox.addActionListener(this.permanencyListener());
        checkBoxPanel.add(this.permanencyCheckBox);
        return checkBoxPanel;
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        this.allowButton = new JButton(Translator.R("ButProceed"));
        this.rejectButton = new JButton(Translator.R("ButCancel"));
        this.helpButton = new JButton(Translator.R("APPEXTSECguiPanelHelpButton"));
        this.allowButton.addActionListener(this.chosenActionSetter(true));
        this.rejectButton.addActionListener(this.chosenActionSetter(false));
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtendedAppletSecurityHelp d = new ExtendedAppletSecurityHelp(null, false, "dialogue");
                ScreenFinder.centerWindowsToCurrentScreen(d);
                d.setVisible(true);
            }
        });
        buttonPanel.add(this.allowButton);
        buttonPanel.add(this.rejectButton);
        buttonPanel.add(this.helpButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        return buttonPanel;
    }

    private void setupButtonAndCheckBoxPanel() {
        JPanel outerPanel = new JPanel(new BorderLayout());
        JPanel rememberPanel = new JPanel(new GridLayout(2, 1));
        rememberPanel.add(this.createCheckBoxPanel());
        rememberPanel.add(this.createMatchOptionsPanel());
        rememberPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        outerPanel.add((Component)rememberPanel, "West");
        outerPanel.add((Component)this.createButtonPanel(), "East");
        this.add(outerPanel);
    }

    private void addComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.setupTopPanel();
        this.setupInfoPanel();
        this.setupQuestionsPanel();
        this.setupButtonAndCheckBoxPanel();
    }

    private ActionListener permanencyListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UnsignedAppletTrustWarningPanel.this.applyToAppletButton.setEnabled(UnsignedAppletTrustWarningPanel.this.permanencyCheckBox.isSelected());
                UnsignedAppletTrustWarningPanel.this.applyToCodeBaseButton.setEnabled(UnsignedAppletTrustWarningPanel.this.permanencyCheckBox.isSelected());
            }
        };
    }

    private ActionListener chosenActionSetter(final boolean allowApplet) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExecuteUnsignedApplet action = allowApplet ? (UnsignedAppletTrustWarningPanel.this.permanencyCheckBox.isSelected() ? ExecuteUnsignedApplet.ALWAYS : ExecuteUnsignedApplet.YES) : (UnsignedAppletTrustWarningPanel.this.permanencyCheckBox.isSelected() ? ExecuteUnsignedApplet.NEVER : ExecuteUnsignedApplet.NO);
                boolean applyToCodeBase = UnsignedAppletTrustWarningPanel.this.applyToCodeBaseButton.isSelected();
                UnsignedAppletTrustWarningPanel.this.actionChoiceListener.actionChosen(new UnsignedWarningAction(action, applyToCodeBase));
            }
        };
    }

    public static interface ActionChoiceListener {
        public void actionChosen(UnsignedWarningAction var1);
    }

    public static class UnsignedWarningAction {
        private ExecuteUnsignedApplet action;
        private boolean applyToCodeBase;

        public UnsignedWarningAction(ExecuteUnsignedApplet action, boolean applyToCodeBase) {
            this.action = action;
            this.applyToCodeBase = applyToCodeBase;
        }

        public ExecuteUnsignedApplet getAction() {
            return this.action;
        }

        public boolean rememberForCodeBase() {
            return this.applyToCodeBase;
        }
    }
}

