/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.cache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jnlp.DownloadServiceListener;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.cache.CacheEntry;
import net.sourceforge.jnlp.cache.CacheLRUWrapper;
import net.sourceforge.jnlp.cache.DownloadIndicator;
import net.sourceforge.jnlp.cache.ResourceTracker;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.PropertiesFile;
import net.sourceforge.jnlp.util.UrlUtils;

public class CacheUtil {
    private static final String setCacheDir = JNLPRuntime.getConfiguration().getProperty("deployment.user.cachedir");
    private static final String cacheDir = new File(setCacheDir != null ? setCacheDir : System.getProperty("java.io.tmpdir")).getPath();
    private static final CacheLRUWrapper lruHandler = CacheLRUWrapper.getInstance();
    private static final HashMap<String, FileLock> propertiesLockPool = new HashMap();

    public static boolean urlEquals(URL u1, URL u2) {
        if (u1 == u2) {
            return true;
        }
        if (u1 == null || u2 == null) {
            return false;
        }
        if (CacheUtil.notNullUrlEquals(u1, u2)) {
            return true;
        }
        try {
            URL nu1 = UrlUtils.normalizeUrl(u1);
            URL nu2 = UrlUtils.normalizeUrl(u2);
            if (CacheUtil.notNullUrlEquals(nu1, nu2)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean notNullUrlEquals(URL u1, URL u2) {
        return CacheUtil.compare(u1.getProtocol(), u2.getProtocol(), true) && CacheUtil.compare(u1.getHost(), u2.getHost(), true) && CacheUtil.compare(u1.getPath(), u2.getPath(), false) && CacheUtil.compare(u1.getQuery(), u2.getQuery(), false) && CacheUtil.compare(u1.getRef(), u2.getRef(), false);
    }

    public static URL getCachedResource(URL location, Version version, UpdatePolicy policy) {
        ResourceTracker rt = new ResourceTracker();
        rt.addResource(location, version, null, policy);
        try {
            File f = rt.getCacheFile(location);
            return f.toURL();
        }
        catch (MalformedURLException ex) {
            return location;
        }
    }

    private static boolean compare(String s1, String s2, boolean ignore) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        if (ignore) {
            return s1.equalsIgnoreCase(s2);
        }
        return s1.equals(s2);
    }

    public static Permission getReadPermission(URL location, Version version) {
        if (CacheUtil.isCacheable(location, version)) {
            File file = CacheUtil.getCacheFile(location, version);
            return new FilePermission(file.getPath(), "read");
        }
        try {
            return location.openConnection().getPermission();
        }
        catch (IOException ioe) {
            if (JNLPRuntime.isDebug()) {
                ioe.printStackTrace();
            }
            return null;
        }
    }

    public static boolean clearCache() {
        if (!CacheUtil.okToClearCache()) {
            System.err.println(Translator.R("CCannotClearCache"));
            return false;
        }
        File cacheDir = new File(CacheUtil.cacheDir);
        if (!cacheDir.isDirectory()) {
            return false;
        }
        if (JNLPRuntime.isDebug()) {
            System.err.println("Clearing cache directory: " + cacheDir);
        }
        try {
            cacheDir = cacheDir.getCanonicalFile();
            FileUtils.recursiveDelete(cacheDir, cacheDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private static boolean okToClearCache() {
        File otherJavawsRunning = new File(JNLPRuntime.getConfiguration().getProperty("deployment.user.runningfile"));
        try {
            if (otherJavawsRunning.isFile()) {
                FileOutputStream fis = new FileOutputStream(otherJavawsRunning);
                FileChannel channel = fis.getChannel();
                if (channel.tryLock() == null) {
                    if (JNLPRuntime.isDebug()) {
                        System.out.println("Other instances of netx are running");
                    }
                    return false;
                }
                if (JNLPRuntime.isDebug()) {
                    System.out.println("No other instances of netx are running");
                }
                return true;
            }
            if (JNLPRuntime.isDebug()) {
                System.out.println("No instance file found");
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isCurrent(URL source, Version version, URLConnection connection) {
        if (!CacheUtil.isCacheable(source, version)) {
            throw new IllegalArgumentException(Translator.R("CNotCacheable", source));
        }
        try {
            if (connection == null) {
                connection = source.openConnection();
            }
            connection.connect();
            CacheEntry entry = new CacheEntry(source, version);
            boolean result = entry.isCurrent(connection);
            if (JNLPRuntime.isDebug()) {
                System.out.println("isCurrent: " + source + " = " + result);
            }
            return result;
        }
        catch (Exception ex) {
            if (JNLPRuntime.isDebug()) {
                ex.printStackTrace();
            }
            return CacheUtil.isCached(source, version);
        }
    }

    public static boolean isCached(URL source, Version version) {
        if (!CacheUtil.isCacheable(source, version)) {
            throw new IllegalArgumentException(Translator.R("CNotCacheable", source));
        }
        CacheEntry entry = new CacheEntry(source, version);
        boolean result = entry.isCached();
        if (JNLPRuntime.isDebug()) {
            System.out.println("isCached: " + source + " = " + result);
        }
        return result;
    }

    public static boolean isCacheable(URL source, Version version) {
        if (source == null) {
            return false;
        }
        if (source.getProtocol().equals("file")) {
            return false;
        }
        return !source.getProtocol().equals("jar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getCacheFile(URL source, Version version) {
        if (!CacheUtil.isCacheable(source, version)) {
            throw new IllegalArgumentException(Translator.R("CNotCacheable", source));
        }
        File cacheFile = null;
        CacheLRUWrapper cacheLRUWrapper = lruHandler;
        synchronized (cacheLRUWrapper) {
            lruHandler.lock();
            lruHandler.load();
            cacheFile = CacheUtil.getCacheFileIfExist(CacheUtil.urlToPath(source, ""));
            if (cacheFile == null) {
                cacheFile = CacheUtil.makeNewCacheFile(source, version);
            } else {
                lruHandler.store();
            }
            lruHandler.unlock();
        }
        return cacheFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getCacheFileIfExist(File urlPath) {
        CacheLRUWrapper cacheLRUWrapper = lruHandler;
        synchronized (cacheLRUWrapper) {
            File cacheFile = null;
            List<Map.Entry<String, String>> entries = lruHandler.getLRUSortedEntries();
            for (Map.Entry<String, String> e : entries) {
                String key = e.getKey();
                String path = e.getValue();
                if (!CacheUtil.pathToURLPath(path).equals(urlPath.getPath())) continue;
                cacheFile = new File(path);
                lruHandler.updateEntry(key);
                break;
            }
            return cacheFile;
        }
    }

    private static String pathToURLPath(String path) {
        int len = cacheDir.length();
        int index = path.indexOf(File.separatorChar, len + 1);
        return path.substring(index);
    }

    public static String getCacheParentDirectory(String filePath) {
        String path = filePath;
        String tempPath = "";
        while (path.startsWith(cacheDir) && !path.equals(cacheDir) && !(tempPath = new File(path).getParent()).equals(cacheDir)) {
            path = tempPath;
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File makeNewCacheFile(URL source, Version version) {
        CacheLRUWrapper cacheLRUWrapper = lruHandler;
        synchronized (cacheLRUWrapper) {
            lruHandler.lock();
            lruHandler.load();
            File cacheFile = null;
            for (long i = 0L; i < Long.MAX_VALUE; ++i) {
                String path = cacheDir + File.separator + i;
                File cDir = new File(path);
                if (cDir.exists()) continue;
                try {
                    cacheFile = CacheUtil.urlToPath(source, path);
                    FileUtils.createParentDir(cacheFile);
                    File pf = new File(cacheFile.getPath() + ".info");
                    FileUtils.createRestrictedFile(pf, true);
                    lruHandler.addEntry(lruHandler.generateKey(cacheFile.getPath()), cacheFile.getPath());
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                break;
            }
            lruHandler.store();
            lruHandler.unlock();
            return cacheFile;
        }
    }

    public static OutputStream getOutputStream(URL source, Version version) throws IOException {
        File localFile = CacheUtil.getCacheFile(source, version);
        FileOutputStream out = new FileOutputStream(localFile);
        return new BufferedOutputStream(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void streamCopy(InputStream is, OutputStream os) throws IOException {
        if (!(is instanceof BufferedInputStream)) {
            is = new BufferedInputStream(is);
        }
        if (!(os instanceof BufferedOutputStream)) {
            os = new BufferedOutputStream(os);
        }
        try {
            int c;
            byte[] b = new byte[4096];
            while ((c = is.read(b, 0, b.length)) != -1) {
                os.write(b, 0, c);
            }
        }
        finally {
            is.close();
            os.close();
        }
    }

    public static File urlToPath(URL location, String subdir) {
        if (subdir == null) {
            throw new NullPointerException();
        }
        StringBuffer path = new StringBuffer();
        path.append(subdir);
        path.append(File.separatorChar);
        path.append(location.getProtocol());
        path.append(File.separatorChar);
        path.append(location.getHost());
        path.append(File.separatorChar);
        path.append(location.getPath().replace('/', File.separatorChar));
        return new File(FileUtils.sanitizePath(path.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForResources(ApplicationInstance app, ResourceTracker tracker, URL[] resources, String title) {
        DownloadIndicator indicator = JNLPRuntime.getDefaultDownloadIndicator();
        DownloadServiceListener listener = null;
        try {
            if (indicator == null) {
                tracker.waitForResources(resources, 0L);
                return;
            }
            if (tracker.waitForResources(resources, indicator.getInitialDelay())) {
                return;
            }
            ArrayList<URL> urlList = new ArrayList<URL>();
            for (URL url : resources) {
                if (tracker.checkResource(url)) continue;
                urlList.add(url);
            }
            URL[] undownloaded = urlList.toArray(new URL[urlList.size()]);
            listener = indicator.getListener(app, title, undownloaded);
            do {
                long read = 0L;
                long total = 0L;
                for (URL url : undownloaded) {
                    total += tracker.getTotalSize(url);
                    read += tracker.getAmountRead(url);
                }
                int percent = (int)(100L * read / Math.max(1L, total));
                for (URL url : undownloaded) {
                    listener.progress(url, "version", tracker.getAmountRead(url), tracker.getTotalSize(url), percent);
                }
            } while (!tracker.waitForResources(resources, indicator.getUpdateRate()));
            for (URL url : undownloaded) {
                listener.progress(url, "version", tracker.getTotalSize(url), tracker.getTotalSize(url), 100);
            }
            if (listener != null) {
                indicator.disposeListener(listener);
            }
        }
        catch (InterruptedException ex) {
            if (JNLPRuntime.isDebug()) {
                ex.printStackTrace();
            }
        }
        finally {
            if (listener != null) {
                indicator.disposeListener(listener);
            }
        }
    }

    public static void cleanCache() {
        if (CacheUtil.okToClearCache()) {
            HashSet<String> keep = new HashSet<String>();
            HashSet<String> remove = new HashSet<String>();
            lruHandler.load();
            long maxSize = -1L;
            try {
                maxSize = Long.parseLong(JNLPRuntime.getConfiguration().getProperty("deployment.cache.max.size"));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            maxSize <<= 20;
            long curSize = 0L;
            for (Map.Entry<String, String> e : lruHandler.getLRUSortedEntries()) {
                String key = e.getKey();
                String path = e.getValue();
                File file = new File(path);
                PropertiesFile pf = new PropertiesFile(new File(path + ".info"));
                boolean delete = Boolean.parseBoolean(pf.getProperty("delete"));
                String rStr = file.getPath().substring(cacheDir.length());
                rStr = cacheDir + rStr.substring(0, rStr.indexOf(File.separatorChar, 1));
                long len = file.length();
                if (keep.contains(file.getPath().substring(rStr.length()))) {
                    lruHandler.removeEntry(key);
                    continue;
                }
                if (delete || !file.isFile() || maxSize >= 0L && curSize + len > maxSize) {
                    lruHandler.removeEntry(key);
                    remove.add(rStr);
                    continue;
                }
                curSize += len;
                keep.add(file.getPath().substring(rStr.length()));
                for (File f : file.getParentFile().listFiles()) {
                    if (f.equals(file) || f.equals(pf.getStoreFile())) continue;
                    try {
                        FileUtils.recursiveDelete(f, f);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
            lruHandler.store();
            remove.add(cacheDir + File.separator + "http");
            remove.add(cacheDir + File.separator + "https");
            CacheUtil.removeSetOfDirectories(remove);
        }
    }

    private static void removeSetOfDirectories(Set<String> remove) {
        for (String s : remove) {
            File f = new File(s);
            try {
                FileUtils.recursiveDelete(f, f);
            }
            catch (IOException e) {}
        }
    }

    public static void lockFile(PropertiesFile properties) {
        String storeFilePath = properties.getStoreFile().getPath();
        try {
            propertiesLockPool.put(storeFilePath, FileUtils.getFileLock(storeFilePath, false, true));
        }
        catch (OverlappingFileLockException e) {
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void unlockFile(PropertiesFile properties) {
        File storeFile = properties.getStoreFile();
        FileLock fl = propertiesLockPool.get(storeFile.getPath());
        try {
            if (fl == null) {
                return;
            }
            fl.release();
            fl.channel().close();
            propertiesLockPool.remove(storeFile.getPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

