#!/bin/sh
echo 'name: test-framework
version: 0.6
id: test-framework-0.6-19655e8854c1decda213fb758efad6d1

license: BSD3
copyright:
maintainer: Max Bolingbroke <batterseapower@hotmail.com>
stability:
homepage: http://batterseapower.github.com/test-framework/
package-url:
synopsis: Framework for running and organising tests, with HUnit and QuickCheck support
description: Allows tests such as QuickCheck properties and HUnit test cases to be assembled into test groups, run in
             parallel (but reported in deterministic order, to aid diff interpretation) and filtered and controlled by
             command line options. All of this comes with colored test output, progress reporting and test statistics output.
category: Testing
author: Max Bolingbroke <batterseapower@hotmail.com>
pkgpath: devel/hs-test-framework
exposed: True
exposed-modules: Test.Framework Test.Framework.Options
                 Test.Framework.Providers.API Test.Framework.Runners.Console
                 Test.Framework.Runners.Options Test.Framework.Seed
hidden-modules: Test.Framework.Core Test.Framework.Improving
                Test.Framework.Runners.Console.Colors
                Test.Framework.Runners.Console.ProgressBar
                Test.Framework.Runners.Console.Run
                Test.Framework.Runners.Console.Statistics
                Test.Framework.Runners.Console.Table
                Test.Framework.Runners.Console.Utilities
                Test.Framework.Runners.Core Test.Framework.Runners.Processors
                Test.Framework.Runners.Statistics
                Test.Framework.Runners.TestPattern
                Test.Framework.Runners.ThreadPool
                Test.Framework.Runners.TimedConsumption
                Test.Framework.Runners.XML.JUnitWriter Test.Framework.Runners.XML
                Test.Framework.Utilities
trusted: False
import-dirs: /usr/local/lib/ghc/test-framework-0.6
library-dirs: /usr/local/lib/ghc/test-framework-0.6
hs-libraries: HStest-framework-0.6
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: ansi-terminal-0.5.5-0bcc070b48372993f61d0303d56a607e
         ansi-wl-pprint-0.6.4-38b850dcea3a482fbfd22348fa4469e4
         base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         containers-0.5.0.0-ab1dae9a94cd3cc84e7b2805636ebfa2
         extensible-exceptions-0.1.1.4-255a395b3b026cb94b23754e1c372785
         hostname-1.0-7cd565c9d50dc782dc60cdde3e580813
         old-locale-1.0.0.5-6729cb9d9cc62d150655de8fc5401b91
         random-1.0.1.1-49dee13e6169a73481e9624e99220b78
         regex-posix-0.95.2-320e6bd67debb5ce05f7a0fda4ec39c1
         time-1.4.0.1-10dc4804a19dc0000fab79908f1a9f50
         xml-1.3.7-00b7b1241ff96679011901480c5466ee
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-test-framework-0.6/html/test-framework.haddock
haddock-html: /usr/local/share/doc/hs-test-framework-0.6/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
