#!/bin/sh
echo 'name: tar
version: 0.4.0.1
id: tar-0.4.0.1-74bf1f24fbf89ad16840a627dc752f28

license: BSD3
copyright: 2007 Bjorn Bringert <bjorn@bringert.net>
           2008-2012 Duncan Coutts <duncan@community.haskell.org>
maintainer: Duncan Coutts <duncan@community.haskell.org>
stability:
homepage:
package-url:
synopsis: Reading, writing and manipulating ".tar" archive files.
description: This library is for working with \"@.tar@\" archive files. It
             can read and write a range of common variations of archive
             format including V7, USTAR, POSIX and GNU formats. It provides
             support for packing and unpacking portable archives. This
             makes it suitable for distribution but not backup because
             details like file ownership and exact permissions are not
             preserved.
category: Codec
author: Bjorn Bringert <bjorn@bringert.net>
        Duncan Coutts <duncan@community.haskell.org>
pkgpath: devel/hs-tar
exposed: True
exposed-modules: Codec.Archive.Tar Codec.Archive.Tar.Entry
                 Codec.Archive.Tar.Check
hidden-modules: Codec.Archive.Tar.Types Codec.Archive.Tar.Read
                Codec.Archive.Tar.Write Codec.Archive.Tar.Pack
                Codec.Archive.Tar.Unpack
trusted: False
import-dirs: /usr/local/lib/ghc/tar-0.4.0.1
library-dirs: /usr/local/lib/ghc/tar-0.4.0.1
hs-libraries: HStar-0.4.0.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         bytestring-0.10.0.2-1c6ab0cabcb254a0e55d751d8ef17b51
         directory-1.2.0.1-1e5a1d00411e436c303c3932f4640124
         filepath-1.3.0.1-b12cbe18566fe1532a1fda4c85e31cbe
         old-time-1.1.0.1-2f8ea093d0c7014780a8a5772f948883
         time-1.4.0.1-10dc4804a19dc0000fab79908f1a9f50
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-tar-0.4.0.1/html/tar.haddock
haddock-html: /usr/local/share/doc/hs-tar-0.4.0.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
