#!/bin/sh
echo 'name: tagsoup
version: 0.12.8
id: tagsoup-0.12.8-391f49b99ac287d01d20c3f69ef601ab

license: BSD3
copyright: Neil Mitchell 2006-2012
maintainer: Neil Mitchell <ndmitchell@gmail.com>
stability:
homepage: http://community.haskell.org/~ndm/tagsoup/
package-url:
synopsis: Parsing and extracting information from (possibly malformed) HTML/XML documents
description: TagSoup is a library for parsing HTML/XML. It supports the HTML 5 specification,
             and can be used to parse either well-formed XML, or unstructured and malformed HTML
             from the web. The library also provides useful functions to extract information
             from an HTML document, making it ideal for screen-scraping.
             .
             Users should start from the "Text.HTML.TagSoup" module.
category: XML
author: Neil Mitchell <ndmitchell@gmail.com>
pkgpath: textproc/hs-tagsoup
exposed: True
exposed-modules: Text.HTML.Download Text.HTML.TagSoup
                 Text.HTML.TagSoup.Entity Text.HTML.TagSoup.Match
                 Text.HTML.TagSoup.Tree Text.StringLike
hidden-modules: Text.HTML.TagSoup.Generated
                Text.HTML.TagSoup.Implementation Text.HTML.TagSoup.Manual
                Text.HTML.TagSoup.Options Text.HTML.TagSoup.Parser
                Text.HTML.TagSoup.Render Text.HTML.TagSoup.Specification
                Text.HTML.TagSoup.Type
trusted: False
import-dirs: /usr/local/lib/ghc/tagsoup-0.12.8
library-dirs: /usr/local/lib/ghc/tagsoup-0.12.8
hs-libraries: HStagsoup-0.12.8
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         bytestring-0.10.0.2-1c6ab0cabcb254a0e55d751d8ef17b51
         containers-0.5.0.0-ab1dae9a94cd3cc84e7b2805636ebfa2
         network-2.4.1.2-3536dbdac401bfea4eb8f7e9e8ce77ed
         text-0.11.3.1-5af30448b2c3a30eee31b3ea9b549812
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-tagsoup-0.12.8/html/tagsoup.haddock
haddock-html: /usr/local/share/doc/hs-tagsoup-0.12.8/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
