#!/bin/sh
echo 'name: pango
version: 0.12.3
id: pango-0.12.3-21ea262e79746dde1ee277978b354f0c

license: LGPL-2.1
copyright: (c) 2001-2010 The Gtk2Hs Team
maintainer: gtk2hs-users@lists.sourceforge.net
stability: stable
homepage: http://projects.haskell.org/gtk2hs/
package-url:
synopsis: Binding to the Pango text rendering engine.
description: This package provides a wrapper around the Pango C library that
             allows high-quality rendering of Unicode text. It can be used
             either with Cairo to output text in PDF, PS or other
             documents or with Gtk+ to display text on-screen.
category: Graphics
author: Axel Simon, Duncan Coutts
pkgpath: devel/hs-pango
exposed: True
exposed-modules: Graphics.Rendering.Pango
                 Graphics.Rendering.Pango.Font Graphics.Rendering.Pango.Enums
                 Graphics.Rendering.Pango.Context Graphics.Rendering.Pango.Layout
                 Graphics.Rendering.Pango.Rendering Graphics.Rendering.Pango.Markup
                 Graphics.Rendering.Pango.Cairo Graphics.Rendering.Pango.Types
                 Graphics.Rendering.Pango.BasicTypes
                 Graphics.Rendering.Pango.Structs
                 Graphics.Rendering.Pango.Attributes
hidden-modules: Graphics.Rendering.Pango.GlyphStorage
                Graphics.Rendering.Pango.Description
trusted: False
import-dirs: /usr/local/lib/ghc/pango-0.12.3
library-dirs: /usr/local/lib/ghc/pango-0.12.3 /usr/local/lib
              /usr/X11R6/lib
hs-libraries: HSpango-0.12.3
extra-libraries: pangocairo-1.0 cairo pangoft2-1.0 pango-1.0 m
                 gobject-2.0 glib-2.0 intl fontconfig freetype z
extra-ghci-libraries:
include-dirs: /usr/local/include/pango-1.0 /usr/local/include/cairo
              /usr/X11R6/include/pixman-1 /usr/local/include/libpng16
              /usr/X11R6/include /usr/local/include/harfbuzz
              /usr/local/include/glib-2.0 /usr/local/lib/glib-2.0/include
              /usr/local/include /usr/X11R6/include/freetype2 /usr/include
includes: hspango.h
depends: array-0.4.0.1-3b78425c10ff2dad7acf7e8c8ae014c3
         base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         cairo-0.12.3.1-d4207e23507b2ab76569f41a8d5db686
         containers-0.5.0.0-ab1dae9a94cd3cc84e7b2805636ebfa2
         directory-1.2.0.1-1e5a1d00411e436c303c3932f4640124
         glib-0.12.4-e3c24025d434894ff47dcfccf269abe4
         mtl-2.1.2-94c72af955e94b8d7b2f359dadd0cb62
         pretty-1.1.1.0-66181c695e6a2e173ba2088cf55cc396
         process-1.1.0.2-76e05340eb66705981411022731ca84a
hugs-options:
cc-options:
ld-options: "-Wl,-rpath-link,/usr/X11R6/lib"
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-pango-0.12.3/html/pango.haddock
haddock-html: /usr/local/share/doc/hs-pango-0.12.3/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
