#!/bin/sh
echo 'name: hedis
version: 0.6.5
id: hedis-0.6.5-109eef72205cc534ad4ddf865e606577

license: BSD3
copyright: Copyright (c) 2011 Falko Peters
maintainer: falko.peters@gmail.com
stability:
homepage: https://github.com/informatikr/hedis
package-url:
synopsis: Client library for the Redis datastore: supports full command set,
          pipelining.
description: Redis is an open source, advanced key-value store. It is often referred to
             as a data structure server since keys can contain strings, hashes, lists,
             sets and sorted sets. This library is a Haskell client for the Redis
             datastore. Compared to other Haskell client libraries it has some
             advantages:
             .
             [Complete Redis 2.6 command set:] All Redis commands
             (<http://redis.io/commands>) are available as haskell functions, except
             for the MONITOR and SYNC commands. Additionally, a low-level API is
             exposed that  makes it easy for the library user to implement further
             commands, such as new commands from an experimental Redis version.
             .
             [Automatic Optimal Pipelining:] Commands are pipelined
             (<http://redis.io/topics/pipelining>) as much as possible without any
             work by the user. See
             <http://informatikr.com/2012/redis-pipelining.html> for a
             technical explanation of automatic optimal pipelining.
             .
             [Enforced Pub\/Sub semantics:] When subscribed to the Redis Pub\/Sub server
             (<http://redis.io/topics/pubsub>), clients are not allowed to issue
             commands other than subscribing to or unsubscribing from channels. This
             library uses the type system to enforce the correct behavior.
             .
             [Connect via TCP or Unix Domain Socket:] TCP sockets are the default way to
             connect to a Redis server. For connections to a server on the same
             machine, Unix domain sockets offer higher performance than the standard
             TCP connection.
             .
             For detailed documentation, see the "Database.Redis" module.
             .
category: Database
author: Falko Peters
pkgpath: databases/hs-hedis
exposed: True
exposed-modules: Database.Redis
hidden-modules: Database.Redis.Core
                Database.Redis.ProtocolPipelining Database.Redis.Protocol
                Database.Redis.PubSub Database.Redis.Transactions
                Database.Redis.Types Database.Redis.Commands
                Database.Redis.ManualCommands
trusted: False
import-dirs: /usr/local/lib/ghc/hedis-0.6.5
library-dirs: /usr/local/lib/ghc/hedis-0.6.5
hs-libraries: HShedis-0.6.5
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: BoundedChan-1.0.1.0-f189f5b9412168ec5d144896b95b6d2f
         attoparsec-0.10.4.0-d9fd97cfc1a1748b3cde35adf7fd233b
         base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         bytestring-0.10.0.2-1c6ab0cabcb254a0e55d751d8ef17b51
         bytestring-lexing-0.4.3-10ed276d4a72672123793b4e3973303c
         mtl-2.1.2-94c72af955e94b8d7b2f359dadd0cb62
         network-2.4.1.2-3536dbdac401bfea4eb8f7e9e8ce77ed
         resource-pool-0.2.1.1-1b28dbb4da861477a0a5f63a14463bbd
         time-1.4.0.1-10dc4804a19dc0000fab79908f1a9f50
         vector-0.10.0.1-869166d5d49db46ce6c328ea5f8defbf
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-hedis-0.6.5/html/hedis.haddock
haddock-html: /usr/local/share/doc/hs-hedis-0.6.5/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
