#!/bin/sh
echo 'name: haskell-src-exts
version: 1.13.3
id: haskell-src-exts-1.13.3-ae2a0d179a3bce3db5b0d0538da9f510

license: BSD3
copyright:
maintainer: Niklas Broberg <niklas.broberg@chalmers.se>
stability: Stable
homepage: http://code.haskell.org/haskell-src-exts
package-url:
synopsis: Manipulating Haskell source: abstract syntax, lexer, parser, and pretty-printer
description: Haskell-Source with Extensions (HSE, haskell-src-exts)
             is an extension of the standard haskell-src package,
             and handles most registered syntactic extensions to Haskell, including:
             .
             * Multi-parameter type classes with functional dependencies
             .
             * Indexed type families (including associated types)
             .
             * Empty data declarations
             .
             * GADTs
             .
             * Implicit parameters
             .
             * Template Haskell
             .
             and a few more. All extensions implemented in GHC are supported.
             Apart from these standard extensions,
             it also handles regular patterns as per the HaRP extension
             as well as HSX-style embedded XML syntax.
category: Language
author: Niklas Broberg
pkgpath: lang/hs-haskell-src-exts
exposed: True
exposed-modules: Language.Haskell.Exts Language.Haskell.Exts.Parser
                 Language.Haskell.Exts.Pretty Language.Haskell.Exts.Syntax
                 Language.Haskell.Exts.Extension Language.Haskell.Exts.Build
                 Language.Haskell.Exts.Fixity Language.Haskell.Exts.Comments
                 Language.Haskell.Exts.SrcLoc Language.Haskell.Exts.Annotated
                 Language.Haskell.Exts.Annotated.Syntax
                 Language.Haskell.Exts.Annotated.Fixity
                 Language.Haskell.Exts.Annotated.Build
                 Language.Haskell.Exts.Annotated.ExactPrint
                 Language.Haskell.Exts.Annotated.Simplify
hidden-modules: Language.Haskell.Exts.ExtScheme
                Language.Haskell.Exts.ParseMonad Language.Haskell.Exts.ParseSyntax
                Language.Haskell.Exts.Lexer Language.Haskell.Exts.ParseUtils
                Language.Haskell.Exts.InternalParser
trusted: False
import-dirs: /usr/local/lib/ghc/haskell-src-exts-1.13.3
library-dirs: /usr/local/lib/ghc/haskell-src-exts-1.13.3
hs-libraries: HShaskell-src-exts-1.13.3
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.4.0.1-3b78425c10ff2dad7acf7e8c8ae014c3
         base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         cpphs-1.13.3-7402b0002a60f35ee0c31667e8bb7ad4
         pretty-1.1.1.0-66181c695e6a2e173ba2088cf55cc396
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-haskell-src-exts-1.13.3/html/haskell-src-exts.haddock
haddock-html: /usr/local/share/doc/hs-haskell-src-exts-1.13.3/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
