#!/bin/sh
echo 'name: dbus
version: 0.10.5
id: dbus-0.10.5-3dd5b02bf50a30c5216760b87aea8723

license: GPL-3
copyright:
maintainer: John Millikin <jmillikin@gmail.com>
stability: experimental
homepage: https://john-millikin.com/software/haskell-dbus/
package-url:
synopsis: A client library for the D-Bus IPC system.
description: D-Bus is a simple, message-based protocol for inter-process
             communication, which allows applications to interact with other parts of
             the machine and the user'\''s session using remote procedure calls.
             .
             D-Bus is a essential part of the modern Linux desktop, where it replaces
             earlier protocols such as CORBA and DCOP.
             .
             This library is an implementation of the D-Bus protocol in Haskell. It
             can be used to add D-Bus support to Haskell applications, without the
             awkward interfaces common to foreign bindings.
             .
             Example: connect to the session bus, and get a list of active names.
             .
             @
             &#x7b;-\# LANGUAGE OverloadedStrings \#-&#x7d;
             .
             import Data.List (sort)
             import DBus
             import DBus.Client
             .
             main = do
             &#x20;   client <- connectSession
             &#x20;   //
             &#x20;   \-- Request a list of connected clients from the bus
             &#x20;   reply <- call_ client (methodCall \"\/org\/freedesktop\/DBus\" \"org.freedesktop.DBus\" \"ListNames\")
             &#x20;       &#x7b; methodCallDestination = Just \"org.freedesktop.DBus\"
             &#x20;       &#x7d;
             &#x20;   //
             &#x20;   \-- org.freedesktop.DBus.ListNames() returns a single value, which is
             &#x20;   \-- a list of names (here represented as [String])
             &#x20;   let Just names = fromVariant (methodReturnBody reply !! 0)
             &#x20;   //
             &#x20;   \-- Print each name on a line, sorted so reserved names are below
             &#x20;   \-- temporary names.
             &#x20;   mapM_ putStrLn (sort names)
             @
             .
             >$ ghc --make list-names.hs
             >$ ./list-names
             >:1.0
             >:1.1
             >:1.10
             >:1.106
             >:1.109
             >:1.110
             >ca.desrt.dconf
             >org.freedesktop.DBus
             >org.freedesktop.Notifications
             >org.freedesktop.secrets
             >org.gnome.ScreenSaver
category: Network, Desktop
author: John Millikin <jmillikin@gmail.com>
pkgpath: x11/hs-dbus
exposed: True
exposed-modules: DBus DBus.Client DBus.Introspection DBus.Socket
                 DBus.Transport
hidden-modules: DBus.Address DBus.Message DBus.Types DBus.Wire
trusted: False
import-dirs: /usr/local/lib/ghc/dbus-0.10.5
library-dirs: /usr/local/lib/ghc/dbus-0.10.5
hs-libraries: HSdbus-0.10.5
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         bytestring-0.10.0.2-1c6ab0cabcb254a0e55d751d8ef17b51
         cereal-0.3.5.2-a9ff0516a3b8fef3d6dca329fe564618
         containers-0.5.0.0-ab1dae9a94cd3cc84e7b2805636ebfa2
         libxml-sax-0.7.4-5f061f92ccfe62bb12f7a05b9ee352ff
         network-2.4.1.2-3536dbdac401bfea4eb8f7e9e8ce77ed
         parsec-3.1.3-83475a11f2461aa1a11fb4b6a9cf137c
         random-1.0.1.1-49dee13e6169a73481e9624e99220b78
         text-0.11.3.1-5af30448b2c3a30eee31b3ea9b549812
         transformers-0.3.0.0-ff2bb6ac67241ebb987351a3db564af0
         unix-2.6.0.1-eff76fcbf6509b60a4df5e8289027c63
         vector-0.10.0.1-869166d5d49db46ce6c328ea5f8defbf
         xml-types-0.3.4-b39fd38cbbdcc8921c8e2439b41c614c
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-dbus-0.10.5/html/dbus.haddock
haddock-html: /usr/local/share/doc/hs-dbus-0.10.5/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
