#!/bin/sh
echo 'name: convertible
version: 1.0.11.1
id: convertible-1.0.11.1-c646feb666e6c97920757ce006719f7e

license: BSD3
copyright: Copyright (c) 2009-2011 John Goerzen
maintainer: John Goerzen <jgoerzen@complete.org>
stability: Stable
homepage: http://hackage.haskell.org/cgi-bin/hackage-scripts/package/convertible
package-url:
synopsis: Typeclasses and instances for converting between types
description: convertible provides a typeclass with a single function
             that is designed to help convert between different types: numeric
             values, dates and times, and the like.  The conversions perform bounds
             checking and return a pure Either value.  This means that you need
             not remember which specific function performs the conversion you
             desire.
             .
             Also included in the package are optional instances that provide
             conversion for various numeric and time types, as well as utilities
             for writing your own instances.
             .
             Finally, there is a function that will raise an exception on
             bounds-checking violation, or return a bare value otherwise,
             implemented in terms of the safer function described above.
             .
             Convertible is also used by HDBC 2.0 for handling marshalling of
             data to and from databases.
             .
             Convertible is backed by an extensive test suite and passes tests
             on GHC and Hugs.
category: Data
author: John Goerzen
pkgpath: devel/hs-convertible
exposed: True
exposed-modules: Data.Convertible Data.Convertible.Base
                 Data.Convertible.Utils Data.Convertible.Instances
                 Data.Convertible.Instances.C Data.Convertible.Instances.Map
                 Data.Convertible.Instances.Num Data.Convertible.Instances.Text
                 Data.Convertible.Instances.Time
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/convertible-1.0.11.1
library-dirs: /usr/local/lib/ghc/convertible-1.0.11.1
hs-libraries: HSconvertible-1.0.11.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         bytestring-0.10.0.2-1c6ab0cabcb254a0e55d751d8ef17b51
         containers-0.5.0.0-ab1dae9a94cd3cc84e7b2805636ebfa2
         mtl-2.1.2-94c72af955e94b8d7b2f359dadd0cb62
         old-locale-1.0.0.5-6729cb9d9cc62d150655de8fc5401b91
         old-time-1.1.0.1-2f8ea093d0c7014780a8a5772f948883
         text-0.11.3.1-5af30448b2c3a30eee31b3ea9b549812
         time-1.4.0.1-10dc4804a19dc0000fab79908f1a9f50
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-convertible-1.0.11.1/html/convertible.haddock
haddock-html: /usr/local/share/doc/hs-convertible-1.0.11.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
