#!/bin/sh
echo 'name: configurator
version: 0.2.0.0
id: configurator-0.2.0.0-3768e2c0e23982f83faf58658c8b8b19

license: BSD3
copyright: Copyright 2011 MailRank, Inc.
maintainer: Bryan O'\''Sullivan <bos@serpentine.com>
stability: experimental
homepage: http://github.com/bos/configurator
package-url:
synopsis: Configuration management
description: A configuration management library for programs and daemons.
             .
             Features include:
             .
             * Automatic, dynamic reloading in response to modifications to
             configuration files.
             .
             * A simple, but flexible, configuration language, supporting several
             of the most commonly needed types of data, along with
             interpolation of strings from the configuration or the system
             environment (e.g. @$(HOME)@).
             .
             * Subscription-based notification of changes to configuration
             properties.
             .
             * An @import@ directive allows the configuration of a complex
             application to be split across several smaller files, or common
             configuration data to be shared across several applications.
             .
             For details of the configuration file format, see
             <http://hackage.haskell.org/packages/archive/configurator/latest/doc/html/Data-Configurator.html>.
category: Configuration, Data
author: Bryan O'\''Sullivan <bos@serpentine.com>
pkgpath: devel/hs-configurator
exposed: True
exposed-modules: Data.Configurator Data.Configurator.Types
hidden-modules: Data.Configurator.Instances
                Data.Configurator.Parser Data.Configurator.Types.Internal
trusted: False
import-dirs: /usr/local/lib/ghc/configurator-0.2.0.0
library-dirs: /usr/local/lib/ghc/configurator-0.2.0.0
hs-libraries: HSconfigurator-0.2.0.0
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: attoparsec-0.10.4.0-d9fd97cfc1a1748b3cde35adf7fd233b
         base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         bytestring-0.10.0.2-1c6ab0cabcb254a0e55d751d8ef17b51
         directory-1.2.0.1-1e5a1d00411e436c303c3932f4640124
         hashable-1.1.2.5-e0f2541518f84d3123a819112b4ffe20
         text-0.11.3.1-5af30448b2c3a30eee31b3ea9b549812
         unix-compat-0.4.1.1-3ecee737d68c789a8df91c9cd3d2952f
         unordered-containers-0.2.3.0-c7952fe8bed178bdf8ed4d090730c9da
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-configurator-0.2.0.0/html/configurator.haddock
haddock-html: /usr/local/share/doc/hs-configurator-0.2.0.0/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
