#!/bin/sh
echo 'name: async
version: 2.0.1.4
id: async-2.0.1.4-3eae4a440b34cbf08aad8765dbd61d40

license: BSD3
copyright: (c) Simon Marlow 2012
maintainer: Simon Marlow <marlowsd@gmail.com>
stability:
homepage: https://github.com/simonmar/async
package-url:
synopsis: Run IO operations asynchronously and wait for their results
description: This package provides a higher-level interface over
             threads, in which an @Async a@ is a concurrent
             thread that will eventually deliver a value of
             type @a@.  The package provides ways to create
             @Async@ computations, wait for their results, and
             cancel them.
             .
             Using @Async@ is safer than using threads in two
             ways:
             .
             * When waiting for a thread to return a result,
             if the thread dies with an exception then the
             caller must either re-throw the exception
             ('\''wait'\'') or handle it ('\''waitCatch'\''); the
             exception cannot be ignored.
             .
             * The API makes it possible to build a tree of
             threads that are automatically killed when
             their parent dies (see '\''withAsync'\'').
             .
             Changes in 2.0.1.4:
             .
             * Bump @base@ dependency of test suite
             .
             Changes in 2.0.1.3:
             .
             * Bump @base@ dependency to allow 4.6
             .
             Changes in 2.0.1.2:
             .
             * Bump @stm@ dependency to 2.4
             .
             Changes in 2.0.1.1:
             .
             * Safe Haskell support: @Control.Concurrent.Async@ is now @Trustworthy@
             .
             Changes in 2.0.1.0:
             .
             * Added a @Functor@ instance for @Async@
             .
             * Added @asyncBound@, @asyncOn@, @asyncWithUnmask@, @asyncOnWithUnmask@, @withAsyncBound@, @withAsyncOn@, @withAsyncWithUnmask@, @withAsyncOnWithUnmask@.
             .
             * Added @mapConcurrently@
             .
             * Added @Concurrently@ (with @Applicative@ and @Alternative@ instances)
category: Concurrency
author: Simon Marlow
pkgpath: devel/hs-async
exposed: True
exposed-modules: Control.Concurrent.Async
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/async-2.0.1.4
library-dirs: /usr/local/lib/ghc/async-2.0.1.4
hs-libraries: HSasync-2.0.1.4
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         stm-2.4.2-b5d718b1a5f1fbcdb61a336aef0c2130
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-async-2.0.1.4/html/async.haddock
haddock-html: /usr/local/share/doc/hs-async-2.0.1.4/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
