#!/bin/sh
echo 'name: HDBC
version: 2.3.1.2
id: HDBC-2.3.1.2-c728c8f33ae4e6431d6d036061980d64

license: BSD3
copyright: Copyright (c) 2005-2011 John Goerzen
maintainer: Nicolas Wu <nicolas.wu@gmail.com>
stability: Stable
homepage: https://github.com/hdbc/hdbc
package-url:
synopsis: Haskell Database Connectivity
description: HDBC provides an abstraction layer between Haskell programs and SQL
             relational databases. This lets you write database code once, in
             Haskell, and have it work with any number of backend SQL databases
             (MySQL, Oracle, PostgreSQL, ODBC-compliant databases, etc.)
category: Database
author: John Goerzen
pkgpath: databases/hs-HDBC
exposed: True
exposed-modules: Database.HDBC Database.HDBC.Types
                 Database.HDBC.DriverUtils Database.HDBC.ColTypes
                 Database.HDBC.Statement Database.HDBC.SqlValue Database.HDBC.Locale
hidden-modules: Database.HDBC.Utils
trusted: False
import-dirs: /usr/local/lib/ghc/HDBC-2.3.1.2
library-dirs: /usr/local/lib/ghc/HDBC-2.3.1.2
hs-libraries: HSHDBC-2.3.1.2
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         bytestring-0.10.0.2-1c6ab0cabcb254a0e55d751d8ef17b51
         containers-0.5.0.0-ab1dae9a94cd3cc84e7b2805636ebfa2
         convertible-1.0.11.1-c646feb666e6c97920757ce006719f7e
         mtl-2.1.2-94c72af955e94b8d7b2f359dadd0cb62
         old-locale-1.0.0.5-6729cb9d9cc62d150655de8fc5401b91
         old-time-1.1.0.1-2f8ea093d0c7014780a8a5772f948883
         text-0.11.3.1-5af30448b2c3a30eee31b3ea9b549812
         time-1.4.0.1-10dc4804a19dc0000fab79908f1a9f50
         utf8-string-0.3.8-4b98c0faca0296b4da4f390d8a63aa83
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-HDBC-2.3.1.2/html/HDBC.haddock
haddock-html: /usr/local/share/doc/hs-HDBC-2.3.1.2/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
