#!/bin/sh
exec > /dev/null 2>&1
p="${0%/*}/ghc-pkg --no-user-package-db --global-package-db ${0%/*}/package.conf.d"
$p register --force - << 'EOF'
name: bin-package-db
version: 0.0.0.0
id: bin-package-db-0.0.0.0-442ee9a1354a9a7793268091674515b2
license: BSD3
copyright:
maintainer: cvs-ghc@haskell.org
stability:
homepage:
package-url:
synopsis: A binary format for the package database
description:
category:
author:
pkgpath: lang/ghc
exposed: True
exposed-modules: Distribution.InstalledPackageInfo.Binary
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/bin-package-db-0.0.0.0
library-dirs: /usr/local/lib/ghc/bin-package-db-0.0.0.0
hs-libraries: HSbin-package-db-0.0.0.0
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: Cabal-1.16.0-cdeec7a44cc3c5e6f1ef4986c0e423ac
         base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         binary-0.5.1.1-313d93fcb82c25b3160f1d73103e143f
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/bin-package-db-0.0.0.0/bin-package-db.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/bin-package-db-0.0.0.0
pkgroot: "/usr/obj/ghc-7.6.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: ghc-prim
version: 0.3.0.0
id: ghc-prim-0.3.0.0-d5221a8c8a269b66ab9a07bdc23317dd
license: BSD3
copyright:
maintainer: libraries@haskell.org
stability:
homepage:
package-url:
synopsis: GHC primitives
description: GHC primitives.
category:
author:
pkgpath: lang/ghc
exposed: True
exposed-modules: GHC.Prim GHC.Classes GHC.CString GHC.Debug
                 GHC.Magic GHC.PrimopWrappers GHC.IntWord64 GHC.Tuple GHC.Types
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/ghc-prim-0.3.0.0
library-dirs: /usr/local/lib/ghc/ghc-prim-0.3.0.0
hs-libraries: HSghc-prim-0.3.0.0
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: builtin_rts
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/ghc-prim-0.3.0.0/ghc-prim.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/ghc-prim-0.3.0.0
pkgroot: "/usr/obj/ghc-7.6.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: utf8-string
version: 0.3.8
id: utf8-string-0.3.8-4b98c0faca0296b4da4f390d8a63aa83
license: BSD3
copyright:
maintainer: emertens@galois.com
stability:
homepage: http://github.com/glguy/utf8-string/
package-url:
synopsis: Support for reading and writing UTF8 Strings
description: A UTF8 layer for IO and Strings. The utf8-string
             package provides operations for encoding UTF8
             strings to Word8 lists and back, and for reading and
             writing UTF8 without truncation.
category: Codec
author: Eric Mertens
pkgpath: lang/ghc
exposed: True
exposed-modules: Codec.Binary.UTF8.String Codec.Binary.UTF8.Generic
                 System.IO.UTF8 System.Environment.UTF8 Data.String.UTF8
                 Data.ByteString.UTF8 Data.ByteString.Lazy.UTF8
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/utf8-string-0.3.8
library-dirs: /usr/local/lib/ghc/utf8-string-0.3.8
hs-libraries: HSutf8-string-0.3.8
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         bytestring-0.10.0.2-1c6ab0cabcb254a0e55d751d8ef17b51
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/utf8-string-0.3.8/utf8-string.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/utf8-string-0.3.8
pkgroot: "/usr/obj/ghc-7.6.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: array
version: 0.4.0.1
id: array-0.4.0.1-3b78425c10ff2dad7acf7e8c8ae014c3
license: BSD3
copyright:
maintainer: libraries@haskell.org
stability:
homepage:
package-url:
synopsis: Mutable and immutable arrays
description: This package defines the classes @IArray@ of immutable arrays and
             @MArray@ of arrays mutable within appropriate monads, as well as
             some instances of these classes.
category: Data Structures
author:
pkgpath: lang/ghc
exposed: True
exposed-modules: Data.Array.Base Data.Array.IArray Data.Array.IO
                 Data.Array.IO.Safe Data.Array.IO.Internals Data.Array.MArray
                 Data.Array.MArray.Safe Data.Array.ST Data.Array.ST.Safe
                 Data.Array.Storable Data.Array.Storable.Safe
                 Data.Array.Storable.Internals Data.Array.Unboxed Data.Array.Unsafe
                 Data.Array
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/array-0.4.0.1
library-dirs: /usr/local/lib/ghc/array-0.4.0.1
hs-libraries: HSarray-0.4.0.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/array-0.4.0.1/array.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/array-0.4.0.1
pkgroot: "/usr/obj/ghc-7.6.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: containers
version: 0.5.0.0
id: containers-0.5.0.0-ab1dae9a94cd3cc84e7b2805636ebfa2
license: BSD3
copyright:
maintainer: fox@ucw.cz
stability:
homepage:
package-url:
synopsis: Assorted concrete container types
description: This package contains efficient general-purpose implementations
             of various basic immutable container types.  The declared cost of
             each operation is either worst-case or amortized, but remains
             valid even if structures are shared.
category: Data Structures
author:
pkgpath: lang/ghc
exposed: True
exposed-modules: Data.Graph Data.Sequence Data.Tree Data.IntMap
                 Data.IntMap.Lazy Data.IntMap.Strict Data.IntSet Data.Map
                 Data.Map.Lazy Data.Map.Strict Data.Set
hidden-modules: Data.IntMap.Base Data.IntSet.Base Data.Map.Base
                Data.Set.Base Data.StrictPair
trusted: False
import-dirs: /usr/local/lib/ghc/containers-0.5.0.0
library-dirs: /usr/local/lib/ghc/containers-0.5.0.0
hs-libraries: HScontainers-0.5.0.0
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.4.0.1-3b78425c10ff2dad7acf7e8c8ae014c3
         base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         deepseq-1.3.0.1-5cc4cd89bdc2e8f6db1833d95ec36926
         ghc-prim-0.3.0.0-d5221a8c8a269b66ab9a07bdc23317dd
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/containers-0.5.0.0/containers.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/containers-0.5.0.0
pkgroot: "/usr/obj/ghc-7.6.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: integer-gmp
version: 0.5.0.0
id: integer-gmp-0.5.0.0-2f15426f5b53fe4c6490832f9b20d8d7
license: BSD3
copyright:
maintainer: libraries@haskell.org
stability:
homepage:
package-url:
synopsis: Integer library based on GMP
description: This package contains an Integer library based on GMP.
category:
author:
pkgpath: lang/ghc
exposed: True
exposed-modules: GHC.Integer GHC.Integer.GMP.Internals
                 GHC.Integer.GMP.Prim GHC.Integer.Logarithms
                 GHC.Integer.Logarithms.Internals
hidden-modules: GHC.Integer.Type
trusted: False
import-dirs: /usr/local/lib/ghc/integer-gmp-0.5.0.0
library-dirs: /usr/local/lib/ghc/integer-gmp-0.5.0.0
hs-libraries: HSinteger-gmp-0.5.0.0
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: ghc-prim-0.3.0.0-d5221a8c8a269b66ab9a07bdc23317dd
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/integer-gmp-0.5.0.0/integer-gmp.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/integer-gmp-0.5.0.0
pkgroot: "/usr/obj/ghc-7.6.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: binary
version: 0.5.1.1
id: binary-0.5.1.1-313d93fcb82c25b3160f1d73103e143f
license: BSD3
copyright:
maintainer: Lennart Kolmodin, Don Stewart <dons@galois.com>
stability: provisional
homepage: http://code.haskell.org/binary/
package-url:
synopsis: Binary serialisation for Haskell values using lazy ByteStrings
description: Efficient, pure binary serialisation using lazy ByteStrings.
             Haskell values may be encoded to and from binary formats,
             written to disk as binary, or sent over the network.
             Serialisation speeds of over 1 G\/sec have been observed,
             so this library should be suitable for high performance
             scenarios.
category: Data, Parsing
author: Lennart Kolmodin <kolmodin@gmail.com>
pkgpath: lang/ghc
exposed: True
exposed-modules: Data.Binary Data.Binary.Put Data.Binary.Get
                 Data.Binary.Builder Data.Binary.Builder.Internal
hidden-modules: Data.Binary.Builder.Base
trusted: False
import-dirs: /usr/local/lib/ghc/binary-0.5.1.1
library-dirs: /usr/local/lib/ghc/binary-0.5.1.1
hs-libraries: HSbinary-0.5.1.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.4.0.1-3b78425c10ff2dad7acf7e8c8ae014c3
         base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         bytestring-0.10.0.2-1c6ab0cabcb254a0e55d751d8ef17b51
         containers-0.5.0.0-ab1dae9a94cd3cc84e7b2805636ebfa2
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/binary-0.5.1.1/binary.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/binary-0.5.1.1
pkgroot: "/usr/obj/ghc-7.6.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: hpc
version: 0.6.0.0
id: hpc-0.6.0.0-55f3e636ecc6be9d72acdfed58598358
license: BSD3
copyright:
maintainer: libraries@haskell.org
stability:
homepage:
package-url:
synopsis: Code Coverage Library for Haskell
description:
category: Control
author: Andy Gill
pkgpath: lang/ghc
exposed: True
exposed-modules: Trace.Hpc.Util Trace.Hpc.Mix Trace.Hpc.Tix
                 Trace.Hpc.Reflect
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/hpc-0.6.0.0
library-dirs: /usr/local/lib/ghc/hpc-0.6.0.0
hs-libraries: HShpc-0.6.0.0
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         containers-0.5.0.0-ab1dae9a94cd3cc84e7b2805636ebfa2
         directory-1.2.0.1-1e5a1d00411e436c303c3932f4640124
         time-1.4.0.1-10dc4804a19dc0000fab79908f1a9f50
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/hpc-0.6.0.0/hpc.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/hpc-0.6.0.0
pkgroot: "/usr/obj/ghc-7.6.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: bytestring
version: 0.10.0.2
id: bytestring-0.10.0.2-1c6ab0cabcb254a0e55d751d8ef17b51
license: BSD3
copyright: Copyright (c) Don Stewart          2005-2009,
           (c) Duncan Coutts        2006-2012,
           (c) David Roundy         2003-2005,
           (c) Jasper Van der Jeugt 2010,
           (c) Simon Meier          2010-2011.
maintainer: Don Stewart <dons00@gmail.com>,
            Duncan Coutts <duncan@community.haskell.org>
stability:
homepage:
package-url:
synopsis: Fast, compact, strict and lazy byte strings with a list interface
description: An efficient compact, immutable byte string type (both strict and lazy)
             suitable for binary or 8-bit character data.
             .
             The 'ByteString' type represents sequences of bytes or 8-bit characters.
             It is suitable for high performance use, both in terms of large data
             quantities, or high speed requirements. The 'ByteStrin'g functions follow
             the same style as Haskell\'s ordinary lists, so it is easy to convert code
             from using 'String' to 'ByteString'.
             .
             Two 'ByteString' variants are provided:
             .
             * Strict 'ByteString's keep the string as a single large array. This
             makes them convenient for passing data between C and Haskell.
             .
             * Lazy 'ByteString's use a lazy list of strict chunks which makes it
             suitable for I\/O streaming tasks.
             .
             The @Char8@ modules provide a character-based view of the same
             underlying 'ByteString' types. This makes it convenient to handle mixed
             binary and 8-bit character content (which is common in many file formats
             and network protocols).
             .
             The 'Builder' module provides an efficient way to build up 'ByteString's
             in an ad-hoc way by repeated concatenation. This is ideal for fast
             serialisation or pretty printing.
             .
             'ByteString's are not designed for Unicode. For Unicode strings you should
             use the 'Text' type from the @text@ package.
             .
             These modules are intended to be imported qualified, to avoid name clashes
             with "Prelude" functions, e.g.
             .
             > import qualified Data.ByteString as BS
category: Data
author: Don Stewart,
        Duncan Coutts
pkgpath: lang/ghc
exposed: True
exposed-modules: Data.ByteString Data.ByteString.Char8
                 Data.ByteString.Unsafe Data.ByteString.Internal
                 Data.ByteString.Lazy Data.ByteString.Lazy.Char8
                 Data.ByteString.Lazy.Internal Data.ByteString.Lazy.Builder
                 Data.ByteString.Lazy.Builder.Extras
                 Data.ByteString.Lazy.Builder.ASCII
hidden-modules: Data.ByteString.Lazy.Builder.Internal
                Data.ByteString.Lazy.Builder.BasicEncoding
                Data.ByteString.Lazy.Builder.BasicEncoding.Extras
                Data.ByteString.Lazy.Builder.BasicEncoding.Internal
                Data.ByteString.Lazy.Builder.BasicEncoding.Binary
                Data.ByteString.Lazy.Builder.BasicEncoding.ASCII
                Data.ByteString.Lazy.Builder.BasicEncoding.Internal.Floating
                Data.ByteString.Lazy.Builder.BasicEncoding.Internal.UncheckedShifts
                Data.ByteString.Lazy.Builder.BasicEncoding.Internal.Base16
trusted: False
import-dirs: /usr/local/lib/ghc/bytestring-0.10.0.2
library-dirs: /usr/local/lib/ghc/bytestring-0.10.0.2
hs-libraries: HSbytestring-0.10.0.2
extra-libraries:
extra-ghci-libraries:
include-dirs: /usr/local/lib/ghc/bytestring-0.10.0.2/include
includes: fpstring.h
depends: base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         deepseq-1.3.0.1-5cc4cd89bdc2e8f6db1833d95ec36926
         ghc-prim-0.3.0.0-d5221a8c8a269b66ab9a07bdc23317dd
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/bytestring-0.10.0.2/bytestring.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/bytestring-0.10.0.2
pkgroot: "/usr/obj/ghc-7.6.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: rts
version: 1.0
id: builtin_rts
license: BSD3
copyright:
maintainer: glasgow-haskell-users@haskell.org
stability:
homepage:
package-url:
synopsis:
description:
category:
author:
pkgpath: lang/ghc
exposed: True
exposed-modules:
hidden-modules:
trusted: False
import-dirs:
library-dirs: /usr/local/lib/ghc
hs-libraries: HSrts
extra-libraries: m
extra-ghci-libraries:
include-dirs: /usr/local/lib/ghc/include
includes: Stg.h
depends:
hugs-options:
cc-options:
ld-options: -u ghczmprim_GHCziTypes_Izh_static_info -u
            ghczmprim_GHCziTypes_Czh_static_info -u
            ghczmprim_GHCziTypes_Fzh_static_info -u
            ghczmprim_GHCziTypes_Dzh_static_info -u
            base_GHCziPtr_Ptr_static_info -u
            ghczmprim_GHCziTypes_Wzh_static_info -u
            base_GHCziInt_I8zh_static_info -u base_GHCziInt_I16zh_static_info
            -u base_GHCziInt_I32zh_static_info -u
            base_GHCziInt_I64zh_static_info -u base_GHCziWord_W8zh_static_info
            -u base_GHCziWord_W16zh_static_info -u
            base_GHCziWord_W32zh_static_info -u
            base_GHCziWord_W64zh_static_info -u
            base_GHCziStable_StablePtr_static_info -u
            ghczmprim_GHCziTypes_Izh_con_info -u
            ghczmprim_GHCziTypes_Czh_con_info -u
            ghczmprim_GHCziTypes_Fzh_con_info -u
            ghczmprim_GHCziTypes_Dzh_con_info -u base_GHCziPtr_Ptr_con_info -u
            base_GHCziPtr_FunPtr_con_info -u
            base_GHCziStable_StablePtr_con_info -u
            ghczmprim_GHCziTypes_False_closure -u
            ghczmprim_GHCziTypes_True_closure -u
            base_GHCziPack_unpackCString_closure -u
            base_GHCziIOziException_stackOverflow_closure -u
            base_GHCziIOziException_heapOverflow_closure -u
            base_ControlziExceptionziBase_nonTermination_closure -u
            base_GHCziIOziException_blockedIndefinitelyOnMVar_closure -u
            base_GHCziIOziException_blockedIndefinitelyOnSTM_closure -u
            base_ControlziExceptionziBase_nestedAtomically_closure -u
            base_GHCziWeak_runFinalizzerBatch_closure -u
            base_GHCziTopHandler_flushStdHandles_closure -u
            base_GHCziTopHandler_runIO_closure -u
            base_GHCziTopHandler_runNonIO_closure -u
            base_GHCziConcziIO_ensureIOManagerIsRunning_closure -u
            base_GHCziConcziSync_runSparks_closure -u
            base_GHCziConcziSignal_runHandlers_closure
framework-dirs:
frameworks:
haddock-interfaces:
haddock-html:
pkgroot: "/usr/obj/ghc-7.6.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: old-locale
version: 1.0.0.5
id: old-locale-1.0.0.5-6729cb9d9cc62d150655de8fc5401b91
license: BSD3
copyright:
maintainer: libraries@haskell.org
stability:
homepage:
package-url:
synopsis: locale library
description: This package provides the ability to adapt to
             locale conventions such as date and time formats.
category: System
author:
pkgpath: lang/ghc
exposed: True
exposed-modules: System.Locale
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/old-locale-1.0.0.5
library-dirs: /usr/local/lib/ghc/old-locale-1.0.0.5
hs-libraries: HSold-locale-1.0.0.5
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/old-locale-1.0.0.5/old-locale.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/old-locale-1.0.0.5
pkgroot: "/usr/obj/ghc-7.6.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: old-time
version: 1.1.0.1
id: old-time-1.1.0.1-2f8ea093d0c7014780a8a5772f948883
license: BSD3
copyright:
maintainer: libraries@haskell.org
stability:
homepage:
package-url:
synopsis: Time library
description: This package provides the old time library.
             For new code, the new time library is recommended.
category: System
author:
pkgpath: lang/ghc
exposed: True
exposed-modules: System.Time
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/old-time-1.1.0.1
library-dirs: /usr/local/lib/ghc/old-time-1.1.0.1
hs-libraries: HSold-time-1.1.0.1
extra-libraries:
extra-ghci-libraries:
include-dirs: /usr/local/lib/ghc/old-time-1.1.0.1/include
includes: HsTime.h
depends: base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         old-locale-1.0.0.5-6729cb9d9cc62d150655de8fc5401b91
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/old-time-1.1.0.1/old-time.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/old-time-1.1.0.1
pkgroot: "/usr/obj/ghc-7.6.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: process
version: 1.1.0.2
id: process-1.1.0.2-76e05340eb66705981411022731ca84a
license: BSD3
copyright:
maintainer: libraries@haskell.org
stability:
homepage:
package-url:
synopsis: Process libraries
description: This package contains libraries for dealing with system processes.
category: System
author:
pkgpath: lang/ghc
exposed: True
exposed-modules: System.Process.Internals System.Process System.Cmd
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/process-1.1.0.2
library-dirs: /usr/local/lib/ghc/process-1.1.0.2
hs-libraries: HSprocess-1.1.0.2
extra-libraries:
extra-ghci-libraries:
include-dirs: /usr/local/lib/ghc/process-1.1.0.2/include
includes: runProcess.h
depends: base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         deepseq-1.3.0.1-5cc4cd89bdc2e8f6db1833d95ec36926
         directory-1.2.0.1-1e5a1d00411e436c303c3932f4640124
         filepath-1.3.0.1-b12cbe18566fe1532a1fda4c85e31cbe
         unix-2.6.0.1-eff76fcbf6509b60a4df5e8289027c63
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/process-1.1.0.2/process.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/process-1.1.0.2
pkgroot: "/usr/obj/ghc-7.6.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: haskell2010
version: 1.1.1.0
id: haskell2010-1.1.1.0-1871a795558889e905323f5d1c80b451
license: BSD3
copyright:
maintainer: libraries@haskell.org
stability:
homepage: http://www.haskell.org/definition/
package-url:
synopsis: Compatibility with Haskell 2010
description: This package provides exactly the library modules defined by
             the Haskell 2010 standard.
category: Haskell2010
author:
pkgpath: lang/ghc
exposed: False
exposed-modules: Data.Array Data.Char Data.Complex System.IO
                 System.IO.Error Data.Ix Data.List Data.Maybe Control.Monad
                 Data.Ratio System.Environment System.Exit Numeric Prelude Data.Int
                 Data.Word Data.Bits Foreign Foreign.Ptr Foreign.ForeignPtr
                 Foreign.StablePtr Foreign.Storable Foreign.C Foreign.C.Error
                 Foreign.C.String Foreign.C.Types Foreign.Marshal
                 Foreign.Marshal.Alloc Foreign.Marshal.Array Foreign.Marshal.Error
                 Foreign.Marshal.Utils
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/haskell2010-1.1.1.0
library-dirs: /usr/local/lib/ghc/haskell2010-1.1.1.0
hs-libraries: HShaskell2010-1.1.1.0
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.4.0.1-3b78425c10ff2dad7acf7e8c8ae014c3
         base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         ghc-prim-0.3.0.0-d5221a8c8a269b66ab9a07bdc23317dd
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/haskell2010-1.1.1.0/haskell2010.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/haskell2010-1.1.1.0
pkgroot: "/usr/obj/ghc-7.6.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: pretty
version: 1.1.1.0
id: pretty-1.1.1.0-66181c695e6a2e173ba2088cf55cc396
license: BSD3
copyright:
maintainer: David Terei <dave.terei@gmail.com>
stability: Stable
homepage: http://github.com/haskell/pretty
package-url:
synopsis: Pretty-printing library
description: This package contains a pretty-printing library, a set of API's
             that provides a way to easily print out text in a consistent
             format of your choosing. This is useful for compilers and related
             tools.
             .
             This library was originally designed by John Hughes's and has since
             been heavily modified by Simon Peyton Jones.
category: Text
author:
pkgpath: lang/ghc
exposed: True
exposed-modules: Text.PrettyPrint Text.PrettyPrint.HughesPJ
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/pretty-1.1.1.0
library-dirs: /usr/local/lib/ghc/pretty-1.1.1.0
hs-libraries: HSpretty-1.1.1.0
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/pretty-1.1.1.0/pretty.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/pretty-1.1.1.0
pkgroot: "/usr/obj/ghc-7.6.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: directory
version: 1.2.0.1
id: directory-1.2.0.1-1e5a1d00411e436c303c3932f4640124
license: BSD3
copyright:
maintainer: libraries@haskell.org
stability:
homepage:
package-url:
synopsis: library for directory handling
description: This package provides a library for handling directories.
category: System
author:
pkgpath: lang/ghc
exposed: True
exposed-modules: System.Directory
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/directory-1.2.0.1
library-dirs: /usr/local/lib/ghc/directory-1.2.0.1
hs-libraries: HSdirectory-1.2.0.1
extra-libraries:
extra-ghci-libraries:
include-dirs: /usr/local/lib/ghc/directory-1.2.0.1/include
includes: HsDirectory.h
depends: base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         filepath-1.3.0.1-b12cbe18566fe1532a1fda4c85e31cbe
         time-1.4.0.1-10dc4804a19dc0000fab79908f1a9f50
         unix-2.6.0.1-eff76fcbf6509b60a4df5e8289027c63
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/directory-1.2.0.1/directory.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/directory-1.2.0.1
pkgroot: "/usr/obj/ghc-7.6.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: deepseq
version: 1.3.0.1
id: deepseq-1.3.0.1-5cc4cd89bdc2e8f6db1833d95ec36926
license: BSD3
copyright:
maintainer: libraries@haskell.org
stability:
homepage:
package-url:
synopsis: Deep evaluation of data structures
description: This package provides methods for fully evaluating data structures
             (\"deep evaluation\"). Deep evaluation is often used for adding
             strictness to a program, e.g. in order to force pending exceptions,
             remove space leaks, or force lazy I/O to happen. It is also useful
             in parallel programs, to ensure pending work does not migrate to the
             wrong thread.
             .
             The primary use of this package is via the 'deepseq' function, a
             \"deep\" version of 'seq'. It is implemented on top of an 'NFData'
             typeclass (\"Normal Form Data\", data structures with no unevaluated
             components) which defines strategies for fully evaluating different
             data types.
             .
category: Control
author:
pkgpath: lang/ghc
exposed: True
exposed-modules: Control.DeepSeq
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/deepseq-1.3.0.1
library-dirs: /usr/local/lib/ghc/deepseq-1.3.0.1
hs-libraries: HSdeepseq-1.3.0.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.4.0.1-3b78425c10ff2dad7acf7e8c8ae014c3
         base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/deepseq-1.3.0.1/deepseq.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/deepseq-1.3.0.1
pkgroot: "/usr/obj/ghc-7.6.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: filepath
version: 1.3.0.1
id: filepath-1.3.0.1-b12cbe18566fe1532a1fda4c85e31cbe
license: BSD3
copyright:
maintainer:
stability:
homepage: http://www-users.cs.york.ac.uk/~ndm/filepath/
package-url:
synopsis: Library for manipulating FilePaths in a cross platform way.
description:
category: System
author: Neil Mitchell
pkgpath: lang/ghc
exposed: True
exposed-modules: System.FilePath System.FilePath.Posix
                 System.FilePath.Windows
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/filepath-1.3.0.1
library-dirs: /usr/local/lib/ghc/filepath-1.3.0.1
hs-libraries: HSfilepath-1.3.0.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/filepath-1.3.0.1/filepath.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/filepath-1.3.0.1
pkgroot: "/usr/obj/ghc-7.6.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: time
version: 1.4.0.1
id: time-1.4.0.1-10dc4804a19dc0000fab79908f1a9f50
license: BSD3
copyright:
maintainer: <ashley@semantic.org>
stability: stable
homepage: http://semantic.org/TimeLib/
package-url:
synopsis: A time library
description: A time library
category: System
author: Ashley Yakeley
pkgpath: lang/ghc
exposed: True
exposed-modules: Data.Time.Calendar Data.Time.Calendar.MonthDay
                 Data.Time.Calendar.OrdinalDate Data.Time.Calendar.WeekDate
                 Data.Time.Calendar.Julian Data.Time.Calendar.Easter Data.Time.Clock
                 Data.Time.Clock.POSIX Data.Time.Clock.TAI Data.Time.LocalTime
                 Data.Time.Format Data.Time
hidden-modules: Data.Time.Calendar.Private Data.Time.Calendar.Days
                Data.Time.Calendar.Gregorian Data.Time.Calendar.JulianYearDay
                Data.Time.Clock.Scale Data.Time.Clock.UTC Data.Time.Clock.CTimeval
                Data.Time.Clock.UTCDiff Data.Time.LocalTime.TimeZone
                Data.Time.LocalTime.TimeOfDay Data.Time.LocalTime.LocalTime
                Data.Time.Format.Parse
trusted: False
import-dirs: /usr/local/lib/ghc/time-1.4.0.1
library-dirs: /usr/local/lib/ghc/time-1.4.0.1
hs-libraries: HStime-1.4.0.1
extra-libraries:
extra-ghci-libraries:
include-dirs: /usr/local/lib/ghc/time-1.4.0.1/include
includes:
depends: base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         deepseq-1.3.0.1-5cc4cd89bdc2e8f6db1833d95ec36926
         old-locale-1.0.0.5-6729cb9d9cc62d150655de8fc5401b91
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/time-1.4.0.1/time.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/time-1.4.0.1
pkgroot: "/usr/obj/ghc-7.6.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: Cabal
version: 1.16.0
id: Cabal-1.16.0-cdeec7a44cc3c5e6f1ef4986c0e423ac
license: BSD3
copyright: 2003-2006, Isaac Jones
           2005-2011, Duncan Coutts
maintainer: cabal-devel@haskell.org
stability:
homepage: http://www.haskell.org/cabal/
package-url:
synopsis: A framework for packaging Haskell software
description: The Haskell Common Architecture for Building Applications and
             Libraries: a framework defining a common interface for authors to more
             easily build their Haskell applications in a portable way.
             .
             The Haskell Cabal is part of a larger infrastructure for distributing,
             organizing, and cataloging Haskell libraries and tools.
category: Distribution
author: Isaac Jones <ijones@syntaxpolice.org>
        Duncan Coutts <duncan@community.haskell.org>
pkgpath: lang/ghc
exposed: True
exposed-modules: Distribution.Compiler
                 Distribution.InstalledPackageInfo Distribution.License
                 Distribution.Make Distribution.ModuleName Distribution.Package
                 Distribution.PackageDescription
                 Distribution.PackageDescription.Configuration
                 Distribution.PackageDescription.Parse
                 Distribution.PackageDescription.Check
                 Distribution.PackageDescription.PrettyPrint Distribution.ParseUtils
                 Distribution.ReadE Distribution.Simple Distribution.Simple.Build
                 Distribution.Simple.Build.Macros
                 Distribution.Simple.Build.PathsModule
                 Distribution.Simple.BuildPaths Distribution.Simple.Bench
                 Distribution.Simple.Command Distribution.Simple.Compiler
                 Distribution.Simple.Configure Distribution.Simple.GHC
                 Distribution.Simple.LHC Distribution.Simple.Haddock
                 Distribution.Simple.Hpc Distribution.Simple.Hugs
                 Distribution.Simple.Install Distribution.Simple.InstallDirs
                 Distribution.Simple.JHC Distribution.Simple.LocalBuildInfo
                 Distribution.Simple.NHC Distribution.Simple.PackageIndex
                 Distribution.Simple.PreProcess Distribution.Simple.PreProcess.Unlit
                 Distribution.Simple.Program Distribution.Simple.Program.Ar
                 Distribution.Simple.Program.Builtin Distribution.Simple.Program.Db
                 Distribution.Simple.Program.GHC Distribution.Simple.Program.HcPkg
                 Distribution.Simple.Program.Hpc Distribution.Simple.Program.Ld
                 Distribution.Simple.Program.Run Distribution.Simple.Program.Script
                 Distribution.Simple.Program.Types Distribution.Simple.Register
                 Distribution.Simple.Setup Distribution.Simple.SrcDist
                 Distribution.Simple.Test Distribution.Simple.UHC
                 Distribution.Simple.UserHooks Distribution.Simple.Utils
                 Distribution.System Distribution.TestSuite Distribution.Text
                 Distribution.Verbosity Distribution.Version
                 Distribution.Compat.ReadP Language.Haskell.Extension
hidden-modules: Distribution.GetOpt Distribution.Compat.Exception
                Distribution.Compat.CopyFile Distribution.Compat.TempFile
                Distribution.Simple.GHC.IPI641 Distribution.Simple.GHC.IPI642
                Paths_Cabal
trusted: False
import-dirs: /usr/local/lib/ghc/Cabal-1.16.0
library-dirs: /usr/local/lib/ghc/Cabal-1.16.0
hs-libraries: HSCabal-1.16.0
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.4.0.1-3b78425c10ff2dad7acf7e8c8ae014c3
         base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         containers-0.5.0.0-ab1dae9a94cd3cc84e7b2805636ebfa2
         directory-1.2.0.1-1e5a1d00411e436c303c3932f4640124
         filepath-1.3.0.1-b12cbe18566fe1532a1fda4c85e31cbe
         old-time-1.1.0.1-2f8ea093d0c7014780a8a5772f948883
         pretty-1.1.1.0-66181c695e6a2e173ba2088cf55cc396
         process-1.1.0.2-76e05340eb66705981411022731ca84a
         unix-2.6.0.1-eff76fcbf6509b60a4df5e8289027c63
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/Cabal-1.16.0/Cabal.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/Cabal-1.16.0
pkgroot: "/usr/obj/ghc-7.6.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: haskell98
version: 2.0.0.2
id: haskell98-2.0.0.2-63b4202f374946e3acc8d863abe99370
license: BSD3
copyright:
maintainer: libraries@haskell.org
stability:
homepage: http://www.haskell.org/definition/
package-url:
synopsis: Compatibility with Haskell 98
description: This package provides compatibility with the modules of Haskell
             98 and the FFI addendum, by means of wrappers around modules from
             the base package (which in many cases have additional features).
             However Prelude, Numeric and Foreign are provided directly by
             the base package.
category: Haskell98
author:
pkgpath: lang/ghc
exposed: False
exposed-modules: Prelude Array CPUTime Char Complex Directory IO Ix
                 List Locale Maybe Monad Numeric Random Ratio System Time Bits
                 CError CForeign CString CTypes ForeignPtr Int MarshalAlloc
                 MarshalArray MarshalError MarshalUtils Ptr StablePtr Storable Word
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/haskell98-2.0.0.2
library-dirs: /usr/local/lib/ghc/haskell98-2.0.0.2
hs-libraries: HShaskell98-2.0.0.2
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.4.0.1-3b78425c10ff2dad7acf7e8c8ae014c3
         base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         directory-1.2.0.1-1e5a1d00411e436c303c3932f4640124
         old-locale-1.0.0.5-6729cb9d9cc62d150655de8fc5401b91
         old-time-1.1.0.1-2f8ea093d0c7014780a8a5772f948883
         process-1.1.0.2-76e05340eb66705981411022731ca84a
         time-1.4.0.1-10dc4804a19dc0000fab79908f1a9f50
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/haskell98-2.0.0.2/haskell98.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/haskell98-2.0.0.2
pkgroot: "/usr/obj/ghc-7.6.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: unix
version: 2.6.0.1
id: unix-2.6.0.1-eff76fcbf6509b60a4df5e8289027c63
license: BSD3
copyright:
maintainer: libraries@haskell.org
stability:
homepage:
package-url:
synopsis: POSIX functionality
description: This package gives you access to the set of operating system
             services standardised by POSIX 1003.1b (or the IEEE Portable
             Operating System Interface for Computing Environments -
             IEEE Std. 1003.1).
             .
             The package is not supported under Windows (except under Cygwin).
category: System
author:
pkgpath: lang/ghc
exposed: True
exposed-modules: System.Posix System.Posix.ByteString
                 System.Posix.Error System.Posix.Resource System.Posix.Time
                 System.Posix.Unistd System.Posix.User System.Posix.Signals
                 System.Posix.Signals.Exts System.Posix.Semaphore
                 System.Posix.SharedMem System.Posix.ByteString.FilePath
                 System.Posix.Directory System.Posix.Directory.ByteString
                 System.Posix.DynamicLinker.Module
                 System.Posix.DynamicLinker.Module.ByteString
                 System.Posix.DynamicLinker.Prim
                 System.Posix.DynamicLinker.ByteString System.Posix.DynamicLinker
                 System.Posix.Files System.Posix.Files.ByteString System.Posix.IO
                 System.Posix.IO.ByteString System.Posix.Env
                 System.Posix.Env.ByteString System.Posix.Process
                 System.Posix.Process.Internals System.Posix.Process.ByteString
                 System.Posix.Temp System.Posix.Temp.ByteString
                 System.Posix.Terminal System.Posix.Terminal.ByteString
hidden-modules: System.Posix.Directory.Common
                System.Posix.DynamicLinker.Common System.Posix.Files.Common
                System.Posix.IO.Common System.Posix.Process.Common
                System.Posix.Terminal.Common
trusted: False
import-dirs: /usr/local/lib/ghc/unix-2.6.0.1
library-dirs: /usr/local/lib/ghc/unix-2.6.0.1
hs-libraries: HSunix-2.6.0.1
extra-libraries: util pthread
extra-ghci-libraries:
include-dirs: /usr/local/lib/ghc/unix-2.6.0.1/include
includes: HsUnix.h execvpe.h
depends: base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         bytestring-0.10.0.2-1c6ab0cabcb254a0e55d751d8ef17b51
         time-1.4.0.1-10dc4804a19dc0000fab79908f1a9f50
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/unix-2.6.0.1/unix.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/unix-2.6.0.1
pkgroot: "/usr/obj/ghc-7.6.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: template-haskell
version: 2.8.0.0
id: template-haskell-2.8.0.0-2f3447bb22ecbbb93fd4d823f6841241
license: BSD3
copyright:
maintainer: libraries@haskell.org
stability:
homepage:
package-url:
synopsis:
description: Facilities for manipulating Haskell source code using Template Haskell.
category:
author:
pkgpath: lang/ghc
exposed: True
exposed-modules: Language.Haskell.TH.Syntax
                 Language.Haskell.TH.PprLib Language.Haskell.TH.Ppr
                 Language.Haskell.TH.Lib Language.Haskell.TH.Quote
                 Language.Haskell.TH
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/template-haskell-2.8.0.0
library-dirs: /usr/local/lib/ghc/template-haskell-2.8.0.0
hs-libraries: HStemplate-haskell-2.8.0.0
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         containers-0.5.0.0-ab1dae9a94cd3cc84e7b2805636ebfa2
         pretty-1.1.1.0-66181c695e6a2e173ba2088cf55cc396
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/template-haskell-2.8.0.0/template-haskell.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/template-haskell-2.8.0.0
pkgroot: "/usr/obj/ghc-7.6.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: hoopl
version: 3.9.0.0
id: hoopl-3.9.0.0-8eb345277798867f0cea79054910a0c6
license: BSD3
copyright:
maintainer: nr@cs.tufts.edu
stability:
homepage: http://ghc.cs.tufts.edu/hoopl/
package-url:
synopsis: A library to support dataflow analysis and optimization
description: Higher-order optimization library
             .
             Changes in 3.9.0.0
             .
             * Lots of API changes; mainly a new API for working with Blocks
category: Compilers/Interpreters
author: Norman Ramsey, João Dias, Simon Marlow and Simon Peyton Jones
pkgpath: lang/ghc
exposed: True
exposed-modules: Compiler.Hoopl Compiler.Hoopl.Internals
                 Compiler.Hoopl.Wrappers Compiler.Hoopl.Passes.Dominator
                 Compiler.Hoopl.Passes.DList
hidden-modules: Compiler.Hoopl.Checkpoint
                Compiler.Hoopl.Collections Compiler.Hoopl.Combinators
                Compiler.Hoopl.Dataflow Compiler.Hoopl.Debug Compiler.Hoopl.Block
                Compiler.Hoopl.Graph Compiler.Hoopl.Label Compiler.Hoopl.MkGraph
                Compiler.Hoopl.Fuel Compiler.Hoopl.Pointed Compiler.Hoopl.Shape
                Compiler.Hoopl.Show Compiler.Hoopl.Unique Compiler.Hoopl.XUtil
trusted: False
import-dirs: /usr/local/lib/ghc/hoopl-3.9.0.0
library-dirs: /usr/local/lib/ghc/hoopl-3.9.0.0
hs-libraries: HShoopl-3.9.0.0
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         containers-0.5.0.0-ab1dae9a94cd3cc84e7b2805636ebfa2
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/hoopl-3.9.0.0/hoopl.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/hoopl-3.9.0.0
pkgroot: "/usr/obj/ghc-7.6.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: base
version: 4.6.0.1
id: base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
license: BSD3
copyright:
maintainer: libraries@haskell.org
stability:
homepage:
package-url:
synopsis: Basic libraries
description: This package contains the Prelude and its support libraries,
             and a large collection of useful libraries ranging from data
             structures to parsing combinators and debugging utilities.
category:
author:
pkgpath: lang/ghc
exposed: True
exposed-modules: Foreign.Concurrent GHC.Arr GHC.Base GHC.Char
                 GHC.Conc GHC.Conc.IO GHC.Conc.Signal GHC.Conc.Sync
                 GHC.ConsoleHandler GHC.Constants GHC.Desugar GHC.Enum
                 GHC.Environment GHC.Err GHC.Exception GHC.Exts GHC.Fingerprint
                 GHC.Fingerprint.Type GHC.Float GHC.Float.ConversionUtils
                 GHC.Float.RealFracMethods GHC.Foreign GHC.ForeignPtr GHC.Generics
                 GHC.GHCi GHC.Handle GHC.IO GHC.IO.Buffer GHC.IO.BufferedIO
                 GHC.IO.Device GHC.IO.Encoding GHC.IO.Encoding.CodePage
                 GHC.IO.Encoding.Failure GHC.IO.Encoding.Iconv
                 GHC.IO.Encoding.Latin1 GHC.IO.Encoding.Types GHC.IO.Encoding.UTF16
                 GHC.IO.Encoding.UTF32 GHC.IO.Encoding.UTF8 GHC.IO.Exception
                 GHC.IO.FD GHC.IO.Handle GHC.IO.Handle.FD GHC.IO.Handle.Internals
                 GHC.IO.Handle.Text GHC.IO.Handle.Types GHC.IO.IOMode GHC.IOArray
                 GHC.IOBase GHC.IORef GHC.IP GHC.Int GHC.List GHC.MVar GHC.Num
                 GHC.PArr GHC.Pack GHC.Ptr GHC.Read GHC.Real GHC.ST GHC.Stack
                 GHC.Stats GHC.Show GHC.Stable GHC.Storable GHC.STRef GHC.TypeLits
                 GHC.TopHandler GHC.Unicode GHC.Weak GHC.Word System.Timeout
                 GHC.Event Control.Applicative Control.Arrow Control.Category
                 Control.Concurrent Control.Concurrent.Chan Control.Concurrent.MVar
                 Control.Concurrent.QSem Control.Concurrent.QSemN
                 Control.Concurrent.SampleVar Control.Exception
                 Control.Exception.Base Control.Monad Control.Monad.Fix
                 Control.Monad.Instances Control.Monad.ST Control.Monad.ST.Safe
                 Control.Monad.ST.Unsafe Control.Monad.ST.Lazy
                 Control.Monad.ST.Lazy.Safe Control.Monad.ST.Lazy.Unsafe
                 Control.Monad.ST.Strict Control.Monad.Zip Data.Bits Data.Bool
                 Data.Char Data.Complex Data.Dynamic Data.Either Data.Eq Data.Data
                 Data.Fixed Data.Foldable Data.Function Data.Functor Data.HashTable
                 Data.IORef Data.Int Data.Ix Data.List Data.Maybe Data.Monoid
                 Data.Ord Data.Ratio Data.STRef Data.STRef.Lazy Data.STRef.Strict
                 Data.String Data.Traversable Data.Tuple Data.Typeable
                 Data.Typeable.Internal Data.Unique Data.Version Data.Word
                 Debug.Trace Foreign Foreign.C Foreign.C.Error Foreign.C.String
                 Foreign.C.Types Foreign.ForeignPtr Foreign.ForeignPtr.Safe
                 Foreign.ForeignPtr.Unsafe Foreign.Marshal Foreign.Marshal.Alloc
                 Foreign.Marshal.Array Foreign.Marshal.Error Foreign.Marshal.Pool
                 Foreign.Marshal.Safe Foreign.Marshal.Utils Foreign.Marshal.Unsafe
                 Foreign.Ptr Foreign.Safe Foreign.StablePtr Foreign.Storable Numeric
                 Prelude System.Console.GetOpt System.CPUTime System.Environment
                 System.Exit System.IO System.IO.Error System.IO.Unsafe System.Info
                 System.Mem System.Mem.StableName System.Mem.Weak
                 System.Posix.Internals System.Posix.Types
                 Text.ParserCombinators.ReadP Text.ParserCombinators.ReadPrec
                 Text.Printf Text.Read Text.Read.Lex Text.Show Text.Show.Functions
                 Unsafe.Coerce
hidden-modules: GHC.Event.Array GHC.Event.Clock GHC.Event.Control
                GHC.Event.EPoll GHC.Event.IntMap GHC.Event.Internal
                GHC.Event.KQueue GHC.Event.Manager GHC.Event.PSQ GHC.Event.Poll
                GHC.Event.Thread GHC.Event.Unique Control.Monad.ST.Imp
                Control.Monad.ST.Lazy.Imp Foreign.ForeignPtr.Imp
                System.Environment.ExecutablePath
trusted: False
import-dirs: /usr/local/lib/ghc/base-4.6.0.1
library-dirs: /usr/local/lib/ghc/base-4.6.0.1 /usr/local/lib
hs-libraries: HSbase-4.6.0.1
extra-libraries: iconv
extra-ghci-libraries:
include-dirs: /usr/local/include
              /usr/local/lib/ghc/base-4.6.0.1/include
includes: HsBase.h
depends: ghc-prim-0.3.0.0-d5221a8c8a269b66ab9a07bdc23317dd
         integer-gmp-0.5.0.0-2f15426f5b53fe4c6490832f9b20d8d7 builtin_rts
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/base-4.6.0.1/base.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/base-4.6.0.1
pkgroot: "/usr/obj/ghc-7.6.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: ghc
version: 7.6.3
id: ghc-7.6.3-fd258c9ca51dcf51b7dd445ef2ebea8e
license: BSD3
copyright:
maintainer: glasgow-haskell-users@haskell.org
stability:
homepage: http://www.haskell.org/ghc/
package-url:
synopsis: The GHC API
description: GHC's functionality can be useful for more things than just
             compiling Haskell programs. Important use cases are programs
             that analyse (and perhaps transform) Haskell code. Others
             include loading Haskell code dynamically in a GHCi-like manner.
             For this reason, a lot of GHC's functionality is made available
             through this package.
category: Development
author: The GHC Team
pkgpath: lang/ghc
exposed: False
exposed-modules: DsMeta TcSplice Convert ByteCodeAsm ByteCodeGen
                 ByteCodeInstr ByteCodeItbls ByteCodeLink Debugger LibFFI Linker
                 ObjLink RtClosureInspect DebuggerUtils Avail BasicTypes DataCon
                 Demand Exception GhcMonad Id IdInfo Literal Llvm Llvm.AbsSyn
                 Llvm.PpLlvm Llvm.Types LlvmCodeGen LlvmCodeGen.Base
                 LlvmCodeGen.CodeGen LlvmCodeGen.Data LlvmCodeGen.Ppr
                 LlvmCodeGen.Regs LlvmMangler MkId Module Name NameEnv NameSet
                 OccName RdrName SrcLoc UniqSupply Unique Var VarEnv VarSet BlockId
                 CLabel Cmm CmmBuildInfoTables CmmPipeline CmmCallConv
                 CmmCommonBlockElim CmmContFlowOpt CmmCvt CmmExpr CmmInfo CmmLex
                 CmmLint CmmLive CmmMachOp CmmNode CmmOpt CmmParse CmmProcPoint
                 CmmRewriteAssignments CmmSink CmmType CmmUtils CmmLayoutStack
                 MkGraph OldCmm OldCmmLint OldCmmUtils OldPprCmm PprBase PprC PprCmm
                 PprCmmDecl PprCmmExpr Bitmap CgBindery CgCallConv CgCase CgClosure
                 CgCon CgExpr CgExtCode CgForeignCall CgHeapery CgHpc CgInfoTbls
                 CgLetNoEscape CgMonad CgParallel CgPrimOp CgProf CgStackery
                 CgTailCall CgTicky CgUtils StgCmm StgCmmBind StgCmmClosure
                 StgCmmCon StgCmmEnv StgCmmExpr StgCmmForeign StgCmmGran StgCmmHeap
                 StgCmmHpc StgCmmLayout StgCmmMonad StgCmmPrim StgCmmProf
                 StgCmmTicky StgCmmUtils ClosureInfo CodeGen SMRep CoreArity CoreFVs
                 CoreLint CorePrep CoreSubst CoreSyn TrieMap CoreTidy CoreUnfold
                 CoreUtils ExternalCore MkCore MkExternalCore PprCore
                 PprExternalCore Check Coverage Desugar DsArrows DsBinds DsCCall
                 DsExpr DsForeign DsGRHSs DsListComp DsMonad DsUtils Match MatchCon
                 MatchLit HsBinds HsDecls HsDoc HsExpr HsImpExp HsLit HsPat HsSyn
                 HsTypes HsUtils BinIface BuildTyCl IfaceEnv IfaceSyn IfaceType
                 LoadIface MkIface TcIface FlagChecker Annotations BreakArray
                 CmdLineParser CodeOutput Config Constants DriverMkDepend
                 DriverPhases DriverPipeline DynFlags ErrUtils Finder GHC GhcMake
                 GhcPlugins DynamicLoading HeaderInfo HscMain HscStats HscTypes
                 InteractiveEval PackageConfig Packages PprTyThing StaticFlags
                 StaticFlagParser SysTools TidyPgm Ctype HaddockUtils LexCore Lexer
                 OptCoercion Parser ParserCore ParserCoreUtils RdrHsSyn ForeignCall
                 PrelInfo PrelNames PrelRules PrimOp TysPrim TysWiredIn CostCentre
                 ProfInit SCCfinal RnBinds RnEnv RnExpr RnHsDoc RnNames RnPat
                 RnSource RnTypes CoreMonad CSE FloatIn FloatOut LiberateCase
                 OccurAnal SAT SetLevels SimplCore SimplEnv SimplMonad SimplUtils
                 Simplify SRT SimplStg StgStats UnariseStg Rules SpecConstr
                 Specialise CoreToStg StgLint StgSyn DmdAnal WorkWrap WwLib FamInst
                 Inst TcAnnotations TcArrows TcBinds TcClassDcl TcDefaults TcDeriv
                 TcEnv TcExpr TcForeign TcGenDeriv TcGenGenerics TcHsSyn TcHsType
                 TcInstDcls TcMType TcMatches TcPat TcRnDriver TcRnMonad TcRnTypes
                 TcRules TcSimplify TcErrors TcTyClsDecls TcTyDecls TcType
                 TcEvidence TcUnify TcInteract TcCanonical TcSMonad Class Coercion
                 FamInstEnv FunDeps InstEnv TyCon Kind Type TypeRep Unify Bag Binary
                 BufWrite Digraph Encoding FastBool FastFunctions FastMutInt
                 FastString FastTypes Fingerprint FiniteMap GraphBase GraphColor
                 GraphOps GraphPpr IOEnv ListSetOps Maybes MonadUtils OrdList
                 Outputable Pair Panic Pretty Serialized State Stream StringBuffer
                 UniqFM UniqSet Util Vectorise.Builtins.Base
                 Vectorise.Builtins.Initialise Vectorise.Builtins
                 Vectorise.Monad.Base Vectorise.Monad.Naming Vectorise.Monad.Local
                 Vectorise.Monad.Global Vectorise.Monad.InstEnv Vectorise.Monad
                 Vectorise.Utils.Base Vectorise.Utils.Closure
                 Vectorise.Utils.Hoisting Vectorise.Utils.PADict
                 Vectorise.Utils.Poly Vectorise.Utils Vectorise.Generic.Description
                 Vectorise.Generic.PAMethods Vectorise.Generic.PADict
                 Vectorise.Generic.PData Vectorise.Type.Env Vectorise.Type.Type
                 Vectorise.Type.TyConDecl Vectorise.Type.Classify Vectorise.Convert
                 Vectorise.Vect Vectorise.Var Vectorise.Env Vectorise.Exp Vectorise
                 Hoopl.Dataflow Hoopl AsmCodeGen TargetReg NCGMonad Instruction Size
                 Reg RegClass PIC Platform CPrim X86.Regs X86.RegInfo X86.Instr
                 X86.Cond X86.Ppr X86.CodeGen PPC.Regs PPC.RegInfo PPC.Instr
                 PPC.Cond PPC.Ppr PPC.CodeGen SPARC.Base SPARC.Regs SPARC.RegPlate
                 SPARC.Imm SPARC.AddrMode SPARC.Cond SPARC.Instr SPARC.Stack
                 SPARC.ShortcutJump SPARC.Ppr SPARC.CodeGen SPARC.CodeGen.Amode
                 SPARC.CodeGen.Base SPARC.CodeGen.CondCode SPARC.CodeGen.Gen32
                 SPARC.CodeGen.Gen64 SPARC.CodeGen.Sanity SPARC.CodeGen.Expand
                 RegAlloc.Liveness RegAlloc.Graph.Main RegAlloc.Graph.Stats
                 RegAlloc.Graph.ArchBase RegAlloc.Graph.ArchX86
                 RegAlloc.Graph.Coalesce RegAlloc.Graph.Spill
                 RegAlloc.Graph.SpillClean RegAlloc.Graph.SpillCost
                 RegAlloc.Graph.TrivColorable RegAlloc.Linear.Main
                 RegAlloc.Linear.JoinToTargets RegAlloc.Linear.State
                 RegAlloc.Linear.Stats RegAlloc.Linear.FreeRegs
                 RegAlloc.Linear.StackMap RegAlloc.Linear.Base
                 RegAlloc.Linear.X86.FreeRegs RegAlloc.Linear.PPC.FreeRegs
                 RegAlloc.Linear.SPARC.FreeRegs
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/ghc-7.6.3
library-dirs: /usr/local/lib/ghc/ghc-7.6.3
hs-libraries: HSghc-7.6.3
extra-libraries:
extra-ghci-libraries:
include-dirs: /usr/local/lib/ghc/ghc-7.6.3/include
includes:
depends: Cabal-1.16.0-cdeec7a44cc3c5e6f1ef4986c0e423ac
         array-0.4.0.1-3b78425c10ff2dad7acf7e8c8ae014c3
         base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         bin-package-db-0.0.0.0-442ee9a1354a9a7793268091674515b2
         bytestring-0.10.0.2-1c6ab0cabcb254a0e55d751d8ef17b51
         containers-0.5.0.0-ab1dae9a94cd3cc84e7b2805636ebfa2
         directory-1.2.0.1-1e5a1d00411e436c303c3932f4640124
         filepath-1.3.0.1-b12cbe18566fe1532a1fda4c85e31cbe
         hoopl-3.9.0.0-8eb345277798867f0cea79054910a0c6
         hpc-0.6.0.0-55f3e636ecc6be9d72acdfed58598358
         process-1.1.0.2-76e05340eb66705981411022731ca84a
         template-haskell-2.8.0.0-2f3447bb22ecbbb93fd4d823f6841241
         time-1.4.0.1-10dc4804a19dc0000fab79908f1a9f50
         unix-2.6.0.1-eff76fcbf6509b60a4df5e8289027c63
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/ghc-7.6.3/ghc.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/ghc-7.6.3
pkgroot: "/usr/obj/ghc-7.6.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: xhtml
version: 3000.2.1
id: xhtml-3000.2.1-89a5c919f215855496a2d27855701edd
license: BSD3
copyright: Bjorn Bringert 2004-2006, Andy Gill and the Oregon
           Graduate Institute of Science and Technology, 1999-2001
maintainer: Chris Dornan <chris@chrisdornan.com>
stability: Stable
homepage: https://github.com/haskell/xhtml
package-url:
synopsis: An XHTML combinator library
description: This package provides combinators for producing
             XHTML 1.0, including the Strict, Transitional and
             Frameset variants.
category: Web, XML, Pretty Printer
author: Bjorn Bringert
pkgpath: lang/ghc
exposed: True
exposed-modules: Text.XHtml Text.XHtml.Frameset Text.XHtml.Strict
                 Text.XHtml.Transitional Text.XHtml.Debug Text.XHtml.Table
hidden-modules: Text.XHtml.Strict.Attributes
                Text.XHtml.Strict.Elements Text.XHtml.Frameset.Attributes
                Text.XHtml.Frameset.Elements Text.XHtml.Transitional.Attributes
                Text.XHtml.Transitional.Elements Text.XHtml.BlockTable
                Text.XHtml.Extras Text.XHtml.Internals
trusted: False
import-dirs: /usr/local/lib/ghc/xhtml-3000.2.1
library-dirs: /usr/local/lib/ghc/xhtml-3000.2.1
hs-libraries: HSxhtml-3000.2.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/xhtml-3000.2.1/xhtml.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/xhtml-3000.2.1
pkgroot: "/usr/obj/ghc-7.6.3/fake-amd64/usr/local/lib/ghc"

EOF
