/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalSplitPaneUI;
import javax.swing.plaf.metal.MetalUtils;

class MetalSplitPaneDivider
extends BasicSplitPaneDivider {
    static final byte[][] BUTTON_SPRITE_L;
    static final byte[][] BUTTON_SPRITE_R;
    Color dark;
    Color light;
    JSplitPane splitPane;
    int orientation;

    static {
        byte[][] byArrayArray = new byte[5][];
        byte[] byArray = new byte[8];
        byArray[3] = 2;
        byArrayArray[0] = byArray;
        byte[] byArray2 = new byte[8];
        byArray2[2] = 2;
        byArray2[3] = 1;
        byArray2[4] = 1;
        byArrayArray[1] = byArray2;
        byte[] byArray3 = new byte[8];
        byArray3[1] = 2;
        byArray3[2] = 1;
        byArray3[3] = 1;
        byArray3[4] = 1;
        byArray3[5] = 1;
        byArrayArray[2] = byArray3;
        byte[] byArray4 = new byte[8];
        byArray4[0] = 2;
        byArray4[1] = 1;
        byArray4[2] = 1;
        byArray4[3] = 1;
        byArray4[4] = 1;
        byArray4[5] = 1;
        byArray4[6] = 1;
        byArrayArray[3] = byArray4;
        byte[] byArray5 = new byte[8];
        byArray5[1] = 3;
        byArray5[2] = 3;
        byArray5[3] = 3;
        byArray5[4] = 3;
        byArray5[5] = 3;
        byArray5[6] = 3;
        byArray5[7] = 3;
        byArrayArray[4] = byArray5;
        BUTTON_SPRITE_L = byArrayArray;
        byte[][] byArrayArray2 = new byte[5][];
        byArrayArray2[0] = new byte[]{2, 2, 2, 2, 2, 2, 2, 2};
        byte[] byArray6 = new byte[8];
        byArray6[1] = 1;
        byArray6[2] = 1;
        byArray6[3] = 1;
        byArray6[4] = 1;
        byArray6[5] = 1;
        byArray6[6] = 1;
        byArray6[7] = 3;
        byArrayArray2[1] = byArray6;
        byte[] byArray7 = new byte[8];
        byArray7[2] = 1;
        byArray7[3] = 1;
        byArray7[4] = 1;
        byArray7[5] = 1;
        byArray7[6] = 3;
        byArrayArray2[2] = byArray7;
        byte[] byArray8 = new byte[8];
        byArray8[3] = 1;
        byArray8[4] = 1;
        byArray8[5] = 3;
        byArrayArray2[3] = byArray8;
        byte[] byArray9 = new byte[8];
        byArray9[4] = 3;
        byArrayArray2[4] = byArray9;
        BUTTON_SPRITE_R = byArrayArray2;
    }

    public MetalSplitPaneDivider(MetalSplitPaneUI ui, Color light, Color dark) {
        super(ui);
        this.splitPane = ((BasicSplitPaneDivider)this).splitPane;
        this.orientation = ((BasicSplitPaneDivider)this).orientation;
        this.light = light;
        this.dark = dark;
    }

    public void paint(Graphics g) {
        Border border;
        Dimension s = this.getSize();
        if (this.splitPane.hasFocus()) {
            g.setColor(UIManager.getColor("SplitPane.dividerFocusColor"));
            g.fillRect(0, 0, s.width, s.height);
        }
        if ((border = this.getBorder()) != null) {
            border.paintBorder(this, g, 0, 0, s.width, s.height);
        }
        Insets i = this.getInsets();
        MetalUtils.fillMetalPattern(this.splitPane, g, i.left + 2, i.top + 2, s.width - i.left - i.right - 4, s.height - i.top - i.bottom - 4, this.light, this.dark);
        super.paint(g);
    }

    protected JButton createLeftOneTouchButton() {
        MetalOneTouchButton b = new MetalOneTouchButton(0);
        b.setMinimumSize(new Dimension(6, 6));
        b.setRequestFocusEnabled(false);
        return b;
    }

    protected JButton createRightOneTouchButton() {
        MetalOneTouchButton b = new MetalOneTouchButton(1);
        b.setMinimumSize(new Dimension(6, 6));
        b.setRequestFocusEnabled(false);
        return b;
    }

    private class MetalOneTouchButton
    extends JButton {
        static final int LEFT = 0;
        static final int RIGHT = 1;
        private Color[] colors;
        private int direction;

        MetalOneTouchButton(int dir) {
            this.direction = dir;
            this.colors = new Color[4];
        }

        public void setBorder(Border b) {
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void paint(Graphics g) {
            block9: {
                if (MetalSplitPaneDivider.this.splitPane == null) break block9;
                this.colors[0] = this.getBackground();
                this.colors[1] = MetalLookAndFeel.getPrimaryControlDarkShadow();
                this.colors[2] = MetalLookAndFeel.getPrimaryControlInfo();
                this.colors[3] = MetalLookAndFeel.getPrimaryControlHighlight();
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                if (this.getModel().isPressed()) {
                    this.colors[1] = this.colors[2];
                }
                byte[][] sprite = this.direction == 0 ? BUTTON_SPRITE_L : BUTTON_SPRITE_R;
                if (MetalSplitPaneDivider.this.orientation == 0) {
                    int y = 0;
                    while (y < sprite.length) {
                        byte[] line = sprite[y];
                        int x = 0;
                        while (x < line.length) {
                            byte c = line[x];
                            if (c != 0) {
                                g.setColor(this.colors[c]);
                                g.fillRect(x + 1, y + 1, 1, 1);
                            }
                            ++x;
                        }
                        ++y;
                    }
                } else {
                    int y = 0;
                    while (y < sprite.length) {
                        byte[] line = sprite[y];
                        int x = 0;
                        while (x < line.length) {
                            byte c = line[x];
                            if (c != 0) {
                                g.setColor(this.colors[c]);
                                g.fillRect(y + 1, x + 1, 1, 1);
                            }
                            ++x;
                        }
                        ++y;
                    }
                }
            }
        }
    }
}

