/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JLayeredPane
extends JComponent
implements Accessible {
    private static final long serialVersionUID = 5534920399324590459L;
    public static final String LAYER_PROPERTY = "layeredContainerLayer";
    public static final Integer FRAME_CONTENT_LAYER = new Integer(-30000);
    public static final Integer DEFAULT_LAYER = new Integer(0);
    public static final Integer PALETTE_LAYER = new Integer(100);
    public static final Integer MODAL_LAYER = new Integer(200);
    public static final Integer POPUP_LAYER = new Integer(300);
    public static final Integer DRAG_LAYER = new Integer(400);
    private Hashtable componentToLayer = new Hashtable();

    public JLayeredPane() {
        this.setLayout(null);
    }

    public int getLayer(Component c) {
        Integer layerObj;
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            layerObj = (Integer)jc.getClientProperty(LAYER_PROPERTY);
        } else {
            layerObj = (Integer)this.componentToLayer.get(c);
        }
        if (layerObj == null) {
            layerObj = DEFAULT_LAYER;
        }
        return layerObj;
    }

    public static int getLayer(JComponent comp) {
        Integer layerObj = (Integer)comp.getClientProperty(LAYER_PROPERTY);
        if (layerObj == null) {
            layerObj = DEFAULT_LAYER;
        }
        return layerObj;
    }

    public static JLayeredPane getLayeredPaneAbove(Component comp) {
        JLayeredPane lp = (JLayeredPane)SwingUtilities.getAncestorOfClass(JLayeredPane.class, comp);
        return lp;
    }

    public int highestLayer() {
        int highest;
        Component[] components = this.getComponents();
        if (components.length == 0) {
            highest = 0;
        } else {
            highest = Integer.MIN_VALUE;
            int i = 0;
            while (i < components.length) {
                highest = Math.max(highest, this.getLayer(components[i]));
                ++i;
            }
        }
        return highest;
    }

    public int lowestLayer() {
        int lowest;
        Component[] components = this.getComponents();
        if (components.length == 0) {
            lowest = 0;
        } else {
            lowest = Integer.MAX_VALUE;
            int i = 0;
            while (i < components.length) {
                lowest = Math.max(lowest, this.getLayer(components[i]));
                ++i;
            }
        }
        return lowest;
    }

    public void moveToFront(Component c) {
        this.setPosition(c, 0);
    }

    public void moveToBack(Component c) {
        this.setPosition(c, -1);
    }

    public int getPosition(Component c) {
        int pos = -1;
        int index = this.getIndexOf(c);
        if (index >= 0) {
            pos = 0;
            int layer = this.getLayer(c);
            int i = index - 1;
            while (i >= 0) {
                if (layer != this.getLayer(this.getComponent(i))) break;
                ++pos;
                --i;
            }
        }
        return pos;
    }

    public void setPosition(Component c, int position) {
        this.setLayer(c, this.getLayer(c), position);
    }

    public Component[] getComponentsInLayer(int layer) {
        Component[] inLayer = new Component[this.getComponentCountInLayer(layer)];
        Component[] components = this.getComponents();
        int j = 0;
        int i = 0;
        while (i < components.length) {
            if (layer == this.getLayer(components[i])) {
                inLayer[j] = components[i];
                ++j;
            }
            ++i;
        }
        return inLayer;
    }

    public int getComponentCountInLayer(int layer) {
        Component[] components = this.getComponents();
        int count = 0;
        int i = components.length - 1;
        while (i >= 0) {
            if (this.getLayer(components[i]) == layer) {
                ++count;
            }
            --i;
        }
        return count;
    }

    protected Hashtable<Component, Integer> getComponentToLayer() {
        return this.componentToLayer;
    }

    public int getIndexOf(Component c) {
        return this.getComponentZOrder(c);
    }

    protected Integer getObjectForLayer(int layer) {
        switch (layer) {
            case -30000: {
                return FRAME_CONTENT_LAYER;
            }
            case 0: {
                return DEFAULT_LAYER;
            }
            case 100: {
                return PALETTE_LAYER;
            }
            case 200: {
                return MODAL_LAYER;
            }
            case 300: {
                return POPUP_LAYER;
            }
            case 400: {
                return DRAG_LAYER;
            }
        }
        return new Integer(layer);
    }

    protected int insertIndexForLayer(int layer, int position) {
        return this.insertIndexForLayer(null, layer, position);
    }

    private int insertIndexForLayer(Component comp, int layer, int position) {
        int insertIndex;
        ArrayList<Component> l = new ArrayList<Component>();
        int count = this.getComponentCount();
        int i = 0;
        while (i < count) {
            Component c = this.getComponent(i);
            if (c != comp) {
                l.add(c);
            }
            ++i;
        }
        count = l.size();
        int layerStart = -1;
        int layerEnd = -1;
        int i2 = 0;
        while (i2 < count) {
            int layerOfComponent = this.getLayer((Component)l.get(i2));
            if (layerStart == -1 && layerOfComponent == layer) {
                layerStart = i2;
            }
            if (layerOfComponent < layer) {
                if (i2 == 0) {
                    layerStart = 0;
                    layerEnd = 0;
                    break;
                }
                layerEnd = i2;
                break;
            }
            ++i2;
        }
        if (layerStart == -1 && layerEnd == -1) {
            insertIndex = count;
        } else {
            if (layerStart != -1 && layerEnd == -1) {
                layerEnd = count;
            }
            if (layerStart == -1 && layerEnd != -1) {
                layerStart = layerEnd;
            }
            insertIndex = position == -1 ? layerEnd : (position > -1 && layerStart + position <= layerEnd ? layerStart + position : layerEnd);
        }
        return insertIndex;
    }

    @Override
    public void remove(int index) {
        Component c = this.getComponent(index);
        if (!(c instanceof JComponent)) {
            this.componentToLayer.remove(c);
        }
        super.remove(index);
    }

    @Override
    public void removeAll() {
        this.componentToLayer.clear();
        super.removeAll();
    }

    public void setLayer(Component c, int layer) {
        this.setLayer(c, layer, -1);
    }

    public void setLayer(Component c, int layer, int position) {
        Integer layerObj = this.getObjectForLayer(layer);
        if (layer != this.getLayer(c) || position != this.getPosition(c)) {
            if (c instanceof JComponent) {
                JComponent jc = (JComponent)c;
                jc.putClientProperty(LAYER_PROPERTY, layerObj);
            } else {
                this.componentToLayer.put(c, layerObj);
            }
            Container parent = c.getParent();
            if (parent == this) {
                int index = this.insertIndexForLayer(c, layer, position);
                this.setComponentZOrder(c, index);
            }
        }
        this.repaint(c.getX(), c.getY(), c.getWidth(), c.getHeight());
    }

    @Override
    protected void addImpl(Component comp, Object layerConstraint, int index) {
        int layer;
        if (layerConstraint != null && layerConstraint instanceof Integer) {
            layer = (Integer)layerConstraint;
            this.setLayer(comp, layer);
        } else {
            layer = this.getLayer(comp);
        }
        int newIdx = this.insertIndexForLayer(layer, index);
        super.addImpl(comp, layerConstraint, newIdx);
        comp.validate();
        comp.repaint();
    }

    public static void putLayer(JComponent component, int layer) {
        component.putClientProperty(LAYER_PROPERTY, new Integer(layer));
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJLayeredPane();
        }
        return this.accessibleContext;
    }

    @Override
    public void paint(Graphics g) {
        if (this.isOpaque()) {
            Color oldColor = g.getColor();
            Rectangle clip = g.getClipBounds();
            g.setColor(this.getBackground());
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
            g.setColor(oldColor);
        }
        super.paint(g);
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        int numChildren = this.getComponentCount();
        boolean result = true;
        int i = 0;
        while (i < numChildren) {
            Rectangle r1;
            Component c1 = this.getComponent(i);
            if (c1.isVisible() && !(r1 = c1.getBounds()).isEmpty()) {
                int j = i + 1;
                while (j < numChildren) {
                    Rectangle r2;
                    Component c2 = this.getComponent(j);
                    if (c2.isVisible() && !(r2 = c2.getBounds()).isEmpty()) {
                        if (r1.intersects(r2)) {
                            result = false;
                            break;
                        }
                        if (!result) break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    protected class AccessibleJLayeredPane
    extends JComponent.AccessibleJComponent {
        protected AccessibleJLayeredPane() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LAYERED_PANE;
        }
    }
}

