/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.lang.reflect.Proxy;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MXBean;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMX {
    public static final String DEFAULT_VALUE_FIELD = "defaultValue";
    public static final String IMMUTABLE_INFO_FIELD = "immutableInfo";
    public static final String INTERFACE_CLASS_NAME_FIELD = "interfaceClassName";
    public static final String LEGAL_VALUES_FIELD = "legalValues";
    public static final String MAX_VALUE_FIELD = "maxValue";
    public static final String MIN_VALUE_FIELD = "minValue";
    public static final String MXBEAN_FIELD = "mxbean";
    public static final String OPEN_TYPE_FIELD = "openType";
    public static final String ORIGINAL_TYPE_FIELD = "originalType";

    private JMX() {
    }

    public static boolean isMXBeanInterface(Class<?> iface) {
        MXBean annotation = iface.getAnnotation(MXBean.class);
        if (annotation != null) {
            return annotation.value();
        }
        return iface.getName().endsWith("MXBean");
    }

    public static <T> T newMBeanProxy(MBeanServerConnection conn, ObjectName name, Class<T> iface) {
        return JMX.newMBeanProxy(conn, name, iface, false);
    }

    public static <T> T newMBeanProxy(MBeanServerConnection conn, ObjectName name, Class<T> iface, boolean bcast) {
        return MBeanServerInvocationHandler.newProxyInstance(conn, name, iface, bcast);
    }

    public static <T> T newMXBeanProxy(MBeanServerConnection conn, ObjectName name, Class<T> iface) {
        return JMX.newMXBeanProxy(conn, name, iface, false);
    }

    public static <T> T newMXBeanProxy(MBeanServerConnection conn, ObjectName name, Class<T> iface, boolean bcast) {
        if (bcast) {
            return (T)Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface, NotificationEmitter.class}, new MBeanServerInvocationHandler(conn, name, true));
        }
        return (T)Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, new MBeanServerInvocationHandler(conn, name, true));
    }
}

