/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class Win32Process
extends Process {
    private OutputStream outputStream;
    private InputStream inputStream;
    private InputStream errorStream;
    private int procHandle;
    private int exitCode;

    public native void destroy();

    public int exitValue() {
        if (!this.hasExited()) {
            throw new IllegalThreadStateException("Process has not exited");
        }
        return this.exitCode;
    }

    public InputStream getErrorStream() {
        return this.errorStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public native int waitFor() throws InterruptedException;

    public Win32Process(String[] progarray, String[] envp, File dir, boolean redirect) throws IOException {
        int i = 0;
        while (i < progarray.length) {
            String s = progarray[i];
            if (s.indexOf(32) >= 0 || s.indexOf(9) >= 0) {
                progarray[i] = "\"" + s + "\"";
            }
            ++i;
        }
        this.startProcess(progarray, envp, dir, redirect);
    }

    private native boolean hasExited();

    private native void startProcess(String[] var1, String[] var2, File var3, boolean var4) throws IOException;

    private native void cleanup();

    private static class EOFInputStream
    extends InputStream {
        static EOFInputStream instance = new EOFInputStream();

        private EOFInputStream() {
        }

        public int read() {
            return -1;
        }
    }
}

