/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.kwa;

import gnu.javax.crypto.cipher.Rijndael;
import gnu.javax.crypto.kwa.BaseKeyWrappingAlgorithm;
import gnu.javax.crypto.kwa.KeyUnwrappingException;
import java.security.InvalidKeyException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class AESKeyWrap
extends BaseKeyWrappingAlgorithm {
    private static final byte[] DEFAULT_IV = new byte[]{-90, -90, -90, -90, -90, -90, -90, -90};
    private Rijndael aes = new Rijndael();
    private byte[] iv;

    public AESKeyWrap() {
        super("kw-aes");
    }

    protected void engineInit(Map attributes) throws InvalidKeyException {
        HashMap<String, Integer> cipherAttributes = new HashMap<String, Integer>();
        cipherAttributes.put("gnu.crypto.cipher.block.size", 16);
        cipherAttributes.put("gnu.crypto.cipher.key.material", (Integer)attributes.get("gnu.crypto.kwa.kek"));
        this.aes.reset();
        this.aes.init(cipherAttributes);
        byte[] initialValue = (byte[])attributes.get("gnu.crypto.kwa.iv");
        this.iv = initialValue == null ? DEFAULT_IV : (byte[])initialValue.clone();
    }

    protected byte[] engineWrap(byte[] in, int inOffset, int length) {
        if (length % 8 != 0) {
            throw new IllegalArgumentException("Input length MUST be a multiple of 8");
        }
        int n = length / 8;
        byte[] result = new byte[length + 8];
        System.arraycopy(this.iv, 0, result, 0, 8);
        System.arraycopy(in, inOffset, result, 8, length);
        byte[] B = new byte[16];
        int j = 0;
        while (j < 6) {
            int i = 1;
            while (i <= n) {
                System.arraycopy(result, 0, B, 0, 8);
                System.arraycopy(result, i * 8, B, 8, 8);
                this.aes.encryptBlock(B, 0, B, 0);
                long t = n * j + i;
                result[0] = (byte)((long)B[0] ^ t >>> 56);
                result[1] = (byte)((long)B[1] ^ t >>> 48);
                result[2] = (byte)((long)B[2] ^ t >>> 40);
                result[3] = (byte)((long)B[3] ^ t >>> 32);
                result[4] = (byte)((long)B[4] ^ t >>> 24);
                result[5] = (byte)((long)B[5] ^ t >>> 16);
                result[6] = (byte)((long)B[6] ^ t >>> 8);
                result[7] = (byte)((long)B[7] ^ t);
                System.arraycopy(B, 8, result, i * 8, 8);
                ++i;
            }
            ++j;
        }
        return result;
    }

    protected byte[] engineUnwrap(byte[] in, int inOffset, int length) throws KeyUnwrappingException {
        if (length % 8 != 0) {
            throw new IllegalArgumentException("Input length MUST be a multiple of 8");
        }
        byte[] result = new byte[length - 8];
        byte[] A = new byte[8];
        System.arraycopy(in, inOffset, A, 0, 8);
        System.arraycopy(in, inOffset + 8, result, 0, result.length);
        byte[] B = new byte[16];
        int n = length / 8 - 1;
        int j = 5;
        while (j >= 0) {
            int i = n;
            while (i >= 1) {
                long t = n * j + i;
                B[0] = (byte)((long)A[0] ^ t >>> 56);
                B[1] = (byte)((long)A[1] ^ t >>> 48);
                B[2] = (byte)((long)A[2] ^ t >>> 40);
                B[3] = (byte)((long)A[3] ^ t >>> 32);
                B[4] = (byte)((long)A[4] ^ t >>> 24);
                B[5] = (byte)((long)A[5] ^ t >>> 16);
                B[6] = (byte)((long)A[6] ^ t >>> 8);
                B[7] = (byte)((long)A[7] ^ t);
                System.arraycopy(result, (i - 1) * 8, B, 8, 8);
                this.aes.decryptBlock(B, 0, B, 0);
                System.arraycopy(B, 0, A, 0, 8);
                System.arraycopy(B, 8, result, (i - 1) * 8, 8);
                --i;
            }
            --j;
        }
        if (!Arrays.equals(A, this.iv)) {
            throw new KeyUnwrappingException();
        }
        return result;
    }
}

