/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.generator;

import java.util.EnumMap;
import java.util.Map;
import net.sf.freecol.common.model.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiverSection {
    private static final char[] template = new char[]{'0', '1', '2', '3'};
    private Map<Map.Direction, Integer> branches = new EnumMap<Map.Direction, Integer>(Map.Direction.class);
    private int size = 1;
    public Map.Direction direction;
    private Map.Position position;

    public RiverSection(Map<Map.Direction, Integer> branches) {
        this.branches = branches;
    }

    public RiverSection(Map.Position position, Map.Direction direction) {
        this.position = position;
        this.direction = direction;
        this.setBranch(direction, 1);
    }

    public Map.Position getPosition() {
        return this.position;
    }

    public int getSize() {
        return this.size;
    }

    public void setBranch(Map.Direction direction, int size) {
        if (size != 1) {
            size = 2;
        }
        this.branches.put(direction, size);
    }

    public int getBranch(Map.Direction direction) {
        if (this.branches.containsKey((Object)direction)) {
            return this.branches.get((Object)direction);
        }
        return 0;
    }

    public void removeBranch(Map.Direction direction) {
        this.branches.remove((Object)direction);
    }

    public void growBranch(Map.Direction direction, int increment) {
        int newSize = Math.min(2, Math.max(0, this.getBranch(direction) + increment));
        this.setBranch(direction, newSize);
    }

    public void grow() {
        ++this.size;
        this.setBranch(this.direction, 2);
    }

    public String encodeStyle() {
        String result = new String();
        for (Map.Direction direction : Map.Direction.longSides) {
            result = result.concat(Integer.toString(this.getBranch(direction), 36));
        }
        return result;
    }
}

