/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.control;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.Feature;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.LastSale;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeSet {
    private ArrayList<Change> changes;
    private static Comparator<Change> changeComparator = new Comparator<Change>(){

        @Override
        public int compare(Change c1, Change c2) {
            return c1.getPriority() - c2.getPriority();
        }
    };

    public ChangeSet() {
        this.changes = new ArrayList();
    }

    public ChangeSet(ChangeSet other) {
        this.changes = new ArrayList<Change>(other.changes);
    }

    public ChangeSet add(See see, FreeColGameObject ... objects) {
        for (FreeColGameObject o : objects) {
            this.changes.add(new ObjectChange(see, o));
        }
        return this;
    }

    public ChangeSet add(See see, List<FreeColGameObject> objects) {
        for (FreeColGameObject o : objects) {
            this.changes.add(new ObjectChange(see, o));
        }
        return this;
    }

    public ChangeSet add(See see, ChangePriority cp, DOMMessage message) {
        this.changes.add(new MessageChange(see, cp, message));
        return this;
    }

    public ChangeSet addAttack(See see, Unit attacker, Unit defender, Tile attackerTile, Tile defenderTile, boolean success) {
        this.changes.add(new AttackChange(see, attacker, defender, attackerTile, defenderTile, success));
        return this;
    }

    public ChangeSet addAttribute(See see, String key, String value) {
        this.changes.add(new AttributeChange(see, key, value));
        return this;
    }

    public ChangeSet addDead(ServerPlayer serverPlayer) {
        this.addTrivial(See.all(), "setDead", ChangePriority.CHANGE_EARLY, "player", serverPlayer.getId());
        return this;
    }

    public ChangeSet addDispose(See see, Location loc, FreeColGameObject obj) {
        this.changes.add(new RemoveChange(see, loc, obj.disposeList()));
        return this;
    }

    public ChangeSet addDisappear(ServerPlayer owner, Tile tile, FreeColGameObject fcgo) {
        ArrayList<FreeColGameObject> objects = new ArrayList<FreeColGameObject>();
        objects.add(fcgo);
        this.changes.add(new RemoveChange(See.perhaps().except(owner), tile, objects));
        this.changes.add(new ObjectChange(See.perhaps().except(owner), tile));
        return this;
    }

    public ChangeSet addFather(ServerPlayer serverPlayer, FoundingFather father) {
        this.changes.add(new OwnedChange(See.only(serverPlayer), father));
        serverPlayer.addFather(father);
        return this;
    }

    public ChangeSet addFeatureChange(ServerPlayer serverPlayer, FreeColGameObject object, Ability ability, boolean add) {
        this.changes.add(new FeatureChange(See.only(serverPlayer), object, ability, add));
        if (add) {
            object.addAbility(ability);
        } else {
            object.removeAbility(ability);
        }
        return this;
    }

    public ChangeSet addFeatureChange(ServerPlayer serverPlayer, FreeColGameObject object, Modifier modifier, boolean add) {
        this.changes.add(new FeatureChange(See.only(serverPlayer), object, modifier, add));
        if (add) {
            object.addModifier(modifier);
        } else {
            object.removeModifier(modifier);
        }
        return this;
    }

    public ChangeSet addGlobalHistory(Game game, HistoryEvent history) {
        this.changes.add(new OwnedChange(See.all(), history));
        for (Player p : game.getLiveEuropeanPlayers()) {
            p.addHistory(history);
        }
        return this;
    }

    public ChangeSet addHistory(ServerPlayer serverPlayer, HistoryEvent history) {
        this.changes.add(new OwnedChange(See.only(serverPlayer), history));
        serverPlayer.addHistory(history);
        return this;
    }

    public ChangeSet addMessage(See see, ModelMessage message) {
        this.changes.add(new OwnedChange(see, message));
        return this;
    }

    public ChangeSet addMove(See see, Unit unit, Location loc, Tile tile) {
        this.changes.add(new MoveChange(see, unit, loc, tile));
        return this;
    }

    public ChangeSet addPartial(See see, FreeColGameObject fcgo, String ... fields) {
        this.changes.add(new PartialObjectChange(see, fcgo, fields));
        return this;
    }

    public ChangeSet addRegion(ServerPlayer serverPlayer, Region region, String name) {
        Game game = serverPlayer.getGame();
        HistoryEvent h = region.discover(serverPlayer, game.getTurn(), name);
        this.changes.add(new ObjectChange(See.all(), region));
        this.addGlobalHistory(game, h);
        return this;
    }

    public ChangeSet addSale(ServerPlayer serverPlayer, Settlement settlement, GoodsType type, int price) {
        Game game = settlement.getGame();
        LastSale sale = new LastSale(settlement, type, game.getTurn(), price);
        this.changes.add(new OwnedChange(See.only(serverPlayer), sale));
        serverPlayer.saveSale(sale);
        return this;
    }

    public ChangeSet addRemoves(See see, Location loc, List<? extends FreeColGameObject> objects) {
        ArrayList<FreeColGameObject> fcgos = new ArrayList<FreeColGameObject>();
        for (FreeColGameObject freeColGameObject : objects) {
            fcgos.clear();
            fcgos.add(freeColGameObject);
            this.changes.add(new RemoveChange(see, loc, fcgos));
        }
        return this;
    }

    public ChangeSet addSpy(See see, Settlement settlement) {
        this.changes.add(new SpyChange(see, settlement));
        return this;
    }

    public ChangeSet addStance(See see, Player first, Player.Stance stance, Player second) {
        this.changes.add(new StanceChange(see, first, stance, second));
        return this;
    }

    public ChangeSet addTradeRoute(ServerPlayer serverPlayer, TradeRoute tradeRoute) {
        this.changes.add(new OwnedChange(See.only(serverPlayer), tradeRoute));
        serverPlayer.getTradeRoutes().add(tradeRoute);
        return this;
    }

    public ChangeSet addTrivial(See see, String name, ChangePriority cp, String ... attributes) {
        this.changes.add(new TrivialChange(see, name, cp.getPriority(), attributes));
        return this;
    }

    private static void collapseElements(Element head, Element tail) {
        while (tail.hasChildNodes()) {
            head.appendChild(tail.removeChild(tail.getFirstChild()));
        }
    }

    private static boolean collapseOK(Element e1, Element e2) {
        if (e1.getTagName() != e2.getTagName()) {
            return false;
        }
        NamedNodeMap nnm1 = e1.getAttributes();
        NamedNodeMap nnm2 = e2.getAttributes();
        if (nnm1.getLength() != nnm2.getLength()) {
            return false;
        }
        for (int i = 0; i < nnm1.getLength(); ++i) {
            if (nnm1.item(i).getNodeType() != nnm2.item(i).getNodeType()) {
                return false;
            }
            if (nnm1.item(i).getNodeName() != nnm2.item(i).getNodeName()) {
                return false;
            }
            if (nnm1.item(i).getNodeValue() == nnm2.item(i).getNodeValue()) continue;
            return false;
        }
        return true;
    }

    private static List<Element> collapseElementList(List<Element> elements) {
        ArrayList<Element> results = new ArrayList<Element>();
        if (!elements.isEmpty()) {
            Element head = elements.remove(0);
            while (!elements.isEmpty()) {
                Element e = elements.remove(0);
                if (ChangeSet.collapseOK(head, e)) {
                    ChangeSet.collapseElements(head, e);
                    continue;
                }
                results.add(head);
                head = e;
            }
            results.add(head);
        }
        return results;
    }

    public Element build(ServerPlayer serverPlayer) {
        Element result;
        ArrayList<Change> c = new ArrayList<Change>(this.changes);
        List<Element> elements = new ArrayList<Element>();
        ArrayList<Change> diverted = new ArrayList<Change>();
        Document doc = DOMMessage.createNewDocument();
        Collections.sort(c, changeComparator);
        while (!c.isEmpty()) {
            Change change = (Change)c.remove(0);
            if (!change.isNotifiable(serverPlayer)) continue;
            if (change.convertsToElement()) {
                elements.add(change.toElement(serverPlayer, doc));
            } else {
                diverted.add(change);
            }
            c.addAll(change.consequences(serverPlayer));
        }
        elements = ChangeSet.collapseElementList(elements);
        switch (elements.size()) {
            case 0: {
                if (diverted.isEmpty()) {
                    return null;
                }
                result = doc.createElement("update");
                break;
            }
            case 1: {
                result = elements.get(0);
                break;
            }
            default: {
                result = doc.createElement("multiple");
                for (Element e : elements) {
                    result.appendChild(e);
                }
            }
        }
        doc.appendChild(result);
        for (Change change : diverted) {
            change.attachToElement(result);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Collections.sort(this.changes, changeComparator);
        for (Change c : this.changes) {
            sb.append(c.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    private static class TrivialChange
    extends Change {
        private int priority;
        private String name;
        private String[] attributes;

        public TrivialChange(See see, String name, int priority, String[] attributes) {
            super(see);
            if ((attributes.length & 1) == 1) {
                throw new IllegalArgumentException("Attributes must be even sized");
            }
            this.name = name;
            this.priority = priority;
            this.attributes = attributes;
        }

        public int getPriority() {
            return this.priority;
        }

        public Element toElement(ServerPlayer serverPlayer, Document doc) {
            Element element = doc.createElement(this.name);
            for (int i = 0; i < this.attributes.length; i += 2) {
                element.setAttribute(this.attributes[i], this.attributes[i + 1]);
            }
            return element;
        }

        public String toString() {
            String ret = "[" + this.getClass().getName() + " " + this.see.toString() + " #" + this.getPriority() + " " + this.name;
            for (String a : this.attributes) {
                ret = ret + " " + a;
            }
            return ret + "]";
        }
    }

    private static class StanceChange
    extends Change {
        private Player first;
        private Player.Stance stance;
        private Player second;

        public StanceChange(See see, Player first, Player.Stance stance, Player second) {
            super(see);
            this.first = first;
            this.stance = stance;
            this.second = second;
        }

        public int getPriority() {
            return ChangePriority.CHANGE_STANCE.getPriority();
        }

        public Element toElement(ServerPlayer serverPlayer, Document doc) {
            Element element = doc.createElement("setStance");
            element.setAttribute("stance", this.stance.toString());
            element.setAttribute("first", this.first.getId());
            element.setAttribute("second", this.second.getId());
            return element;
        }

        public String toString() {
            return "[" + this.getClass().getName() + " " + this.see.toString() + " #" + this.getPriority() + " " + this.first.getId() + " " + (Object)((Object)this.stance) + " " + this.second.getId() + "]";
        }
    }

    private static class SpyChange
    extends Change {
        private Tile tile;

        public SpyChange(See see, Settlement settlement) {
            super(see);
            this.tile = settlement.getTile();
        }

        public int getPriority() {
            return ChangePriority.CHANGE_NORMAL.getPriority();
        }

        public Element toElement(ServerPlayer serverPlayer, Document doc) {
            Element element = doc.createElement("spyResult");
            element.setAttribute("tile", this.tile.getId());
            element.appendChild(this.tile.toXMLElement(serverPlayer, doc, true, false));
            element.appendChild(this.tile.toXMLElement(serverPlayer, doc, false, false));
            return element;
        }

        public String toString() {
            return "[" + this.getClass().getName() + " " + this.see.toString() + " #" + this.getPriority() + " " + this.tile.getId() + "]";
        }
    }

    private static class FeatureChange
    extends Change {
        private FreeColGameObject object;
        private Feature feature;
        private boolean add;

        public FeatureChange(See see, FreeColGameObject object, Feature feature, boolean add) {
            super(see);
            this.object = object;
            this.feature = feature;
            this.add = add;
        }

        public int getPriority() {
            return ChangePriority.CHANGE_OWNED.getPriority();
        }

        public Element toElement(ServerPlayer serverPlayer, Document doc) {
            Element element = doc.createElement("featureChange");
            element.setAttribute("add", Boolean.toString(this.add));
            element.setAttribute("id", this.object.getId());
            Element child = this.feature.toXMLElement(doc);
            element.appendChild(child);
            return element;
        }

        public String toString() {
            return "[" + this.getClass().getName() + " " + this.see.toString() + " #" + this.getPriority() + " " + (this.add ? "add" : "remove") + " " + this.feature + " " + (this.add ? "to" : "from") + " " + this.object.getId() + "]";
        }
    }

    private static class OwnedChange
    extends Change {
        private FreeColObject fco;

        public OwnedChange(See see, FreeColObject fco) {
            super(see);
            this.fco = fco;
        }

        public int getPriority() {
            return ChangePriority.CHANGE_OWNED.getPriority();
        }

        public Element toElement(ServerPlayer serverPlayer, Document doc) {
            Element element = doc.createElement("addObject");
            Element child = this.fco.toXMLElement(serverPlayer, doc, false, false);
            child.setAttribute("owner", serverPlayer.getId());
            element.appendChild(child);
            return element;
        }

        public String toString() {
            return "[" + this.getClass().getName() + " " + this.see.toString() + " #" + this.getPriority() + " " + this.fco.getId() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RemoveChange
    extends Change {
        private Tile tile;
        private FreeColGameObject fcgo;
        private List<? extends FreeColGameObject> contents;

        public RemoveChange(See see, Location loc, List<? extends FreeColGameObject> objects) {
            super(see);
            this.tile = loc instanceof Tile ? (Tile)loc : null;
            this.fcgo = objects.remove(objects.size() - 1);
            this.contents = objects;
        }

        @Override
        public int getPriority() {
            return ChangePriority.CHANGE_REMOVE.getPriority();
        }

        @Override
        public boolean isPerhapsNotifiable(ServerPlayer serverPlayer) {
            Settlement settlement;
            return this.tile != null && serverPlayer.canSee(this.tile) && ((settlement = this.tile.getSettlement()) == null || settlement.isDisposed() || (ServerPlayer)settlement.getOwner() == serverPlayer);
        }

        @Override
        public Element toElement(ServerPlayer serverPlayer, Document doc) {
            Element element = doc.createElement("remove");
            if (this.fcgo instanceof Ownable && ((Ownable)((Object)this.fcgo)).getOwner() == serverPlayer) {
                for (FreeColGameObject freeColGameObject : this.contents) {
                    element.appendChild(freeColGameObject.toXMLElementPartial(doc, new String[0]));
                }
                element.setAttribute("divert", this.tile != null ? this.tile.getId() : serverPlayer.getId());
            }
            element.appendChild(this.fcgo.toXMLElementPartial(doc, new String[0]));
            return element;
        }

        @Override
        public String toString() {
            String ret = "[" + this.getClass().getName() + " " + this.see.toString() + " #" + this.getPriority() + " " + (this.tile == null ? "<null>" : this.tile.getId());
            for (FreeColGameObject freeColGameObject : this.contents) {
                ret = ret + " " + freeColGameObject.getId();
            }
            return ret + " " + this.fcgo.getId() + "]";
        }
    }

    private static class PartialObjectChange
    extends ObjectChange {
        private String[] fields;

        public PartialObjectChange(See see, FreeColGameObject fcgo, String ... fields) {
            super(see, fcgo);
            this.fields = fields;
        }

        public int getPriority() {
            return ChangePriority.CHANGE_UPDATE.getPriority();
        }

        public boolean isPerhapsNotifiable(ServerPlayer serverPlayer) {
            return false;
        }

        public Element toElement(ServerPlayer serverPlayer, Document doc) {
            Element element = doc.createElement("update");
            element.appendChild(this.fcgo.toXMLElement(serverPlayer, doc, false, false, this.fields));
            return element;
        }

        public String toString() {
            String ret = "[" + this.getClass().getName() + " " + this.see.toString() + " #" + this.getPriority() + " " + this.fcgo.getId();
            for (String f : this.fields) {
                ret = ret + " " + f;
            }
            return ret + "]";
        }
    }

    private static class ObjectChange
    extends Change {
        protected FreeColGameObject fcgo;

        public ObjectChange(See see, FreeColGameObject fcgo) {
            super(see);
            this.fcgo = fcgo;
        }

        public int getPriority() {
            return ChangePriority.CHANGE_UPDATE.getPriority();
        }

        public boolean isPerhapsNotifiable(ServerPlayer serverPlayer) {
            if (this.fcgo instanceof Unit) {
                return ((Unit)this.fcgo).isVisibleTo(serverPlayer);
            }
            if (this.fcgo instanceof Ownable && ((Ownable)((Object)this.fcgo)).getOwner() == serverPlayer) {
                return true;
            }
            if (this.fcgo instanceof WorkLocation) {
                return false;
            }
            return this.fcgo instanceof Location && ((Location)((Object)this.fcgo)).getTile() != null && serverPlayer.canSee(((Location)((Object)this.fcgo)).getTile());
        }

        public Element toElement(ServerPlayer serverPlayer, Document doc) {
            Element element = doc.createElement("update");
            element.appendChild(this.fcgo.toXMLElement(serverPlayer, doc, false, false));
            return element;
        }

        public String toString() {
            return "[" + this.getClass().getName() + " " + this.see.toString() + " #" + this.getPriority() + " " + this.fcgo.getId() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MoveChange
    extends Change {
        private Unit unit;
        private Location oldLocation;
        private Tile newTile;

        private boolean seeOld(ServerPlayer serverPlayer) {
            Tile oldTile = this.oldLocation.getTile();
            return this.unit.getOwner() == serverPlayer || oldTile != null && serverPlayer.canSee(oldTile) && oldTile.getSettlement() == null && !(this.oldLocation instanceof Unit);
        }

        private boolean seeNew(ServerPlayer serverPlayer) {
            return this.unit.getOwner() == serverPlayer || this.unit.isVisibleTo(serverPlayer);
        }

        public MoveChange(See see, Unit unit, Location oldLocation, Tile newTile) {
            super(see);
            this.unit = unit;
            this.oldLocation = oldLocation;
            this.newTile = newTile;
        }

        @Override
        public int getPriority() {
            return ChangePriority.CHANGE_ANIMATION.getPriority();
        }

        @Override
        public boolean isPerhapsNotifiable(ServerPlayer serverPlayer) {
            return this.seeOld(serverPlayer) || this.seeNew(serverPlayer);
        }

        @Override
        public List<Change> consequences(ServerPlayer serverPlayer) {
            if (this.seeOld(serverPlayer) && !this.seeNew(serverPlayer)) {
                ArrayList<Unit> units = new ArrayList<Unit>();
                units.add(this.unit);
                ArrayList<Change> changes = new ArrayList<Change>();
                changes.add(new RemoveChange(See.only(serverPlayer), this.unit.getLocation(), units));
                return changes;
            }
            return Collections.emptyList();
        }

        @Override
        public Element toElement(ServerPlayer serverPlayer, Document doc) {
            Element element = doc.createElement("animateMove");
            element.setAttribute("unit", this.unit.getId());
            element.setAttribute("oldTile", this.oldLocation.getTile().getId());
            element.setAttribute("newTile", this.newTile.getId());
            if (!this.seeOld(serverPlayer)) {
                element.appendChild(this.unit.toXMLElement(serverPlayer, doc, false, false));
            }
            return element;
        }

        @Override
        public String toString() {
            return "[" + this.getClass().getName() + " " + this.see.toString() + " #" + this.getPriority() + " " + this.unit.getId() + " " + ((FreeColGameObject)((Object)this.oldLocation)).getId() + " " + this.newTile.getId() + "]";
        }
    }

    private static class MessageChange
    extends Change {
        private ChangePriority priority;
        private DOMMessage message;

        public MessageChange(See see, ChangePriority priority, DOMMessage message) {
            super(see);
            this.priority = priority;
            this.message = message;
        }

        public int getPriority() {
            return this.priority.getPriority();
        }

        public Element toElement(ServerPlayer serverPlayer, Document doc) {
            Element element = this.message.toXMLElement();
            return (Element)doc.importNode(element, true);
        }

        public String toString() {
            return "[" + this.getClass().getName() + " " + this.see.toString() + " #" + this.getPriority() + " " + this.message + "]";
        }
    }

    private static class AttributeChange
    extends Change {
        private String key;
        private String value;

        public AttributeChange(See see, String key, String value) {
            super(see);
            this.key = key;
            this.value = value;
        }

        public int getPriority() {
            return ChangePriority.CHANGE_ATTRIBUTE.getPriority();
        }

        public boolean convertsToElement() {
            return false;
        }

        public Element toElement(ServerPlayer serverPlayer, Document doc) {
            return null;
        }

        public void attachToElement(Element element) {
            element.setAttribute(this.key, this.value);
        }

        public String toString() {
            return "[" + this.getClass().getName() + " " + this.see.toString() + " #" + this.getPriority() + " " + this.key + "=" + this.value + "]";
        }
    }

    private static class AttackChange
    extends Change {
        private Unit attacker;
        private Unit defender;
        private Tile attackerTile;
        private Tile defenderTile;
        private boolean success;

        public AttackChange(See see, Unit attacker, Unit defender, Tile attackerTile, Tile defenderTile, boolean success) {
            super(see);
            this.attacker = attacker;
            this.defender = defender;
            this.attackerTile = attackerTile;
            this.defenderTile = defenderTile;
            this.success = success;
        }

        public int getPriority() {
            return ChangePriority.CHANGE_ANIMATION.getPriority();
        }

        public boolean isPerhapsNotifiable(ServerPlayer serverPlayer) {
            return serverPlayer == this.attacker.getOwner() || serverPlayer == this.defender.getOwner() || serverPlayer.canSee(this.attackerTile) && serverPlayer.canSee(this.defenderTile);
        }

        public Element toElement(ServerPlayer serverPlayer, Document doc) {
            Element element = doc.createElement("animateAttack");
            element.setAttribute("attacker", this.attacker.getId());
            element.setAttribute("defender", this.defender.getId());
            element.setAttribute("attackerTile", this.attackerTile.getId());
            element.setAttribute("defenderTile", this.defenderTile.getId());
            element.setAttribute("success", Boolean.toString(this.success));
            if (!this.attacker.isVisibleTo(serverPlayer)) {
                element.appendChild(this.attacker.toXMLElement(serverPlayer, doc, false, false));
                if (this.attacker.getLocation() instanceof Unit) {
                    Unit loc = (Unit)this.attacker.getLocation();
                    element.appendChild(loc.toXMLElement(serverPlayer, doc, false, false));
                }
            }
            if (!this.defender.isVisibleTo(serverPlayer)) {
                element.appendChild(this.defender.toXMLElement(serverPlayer, doc, false, false));
            }
            return element;
        }

        public String toString() {
            return "[" + this.getClass().getName() + " " + this.see.toString() + " #" + this.getPriority() + " " + this.attacker.getId() + "@" + this.attackerTile.getId() + " " + this.success + " " + this.defender.getId() + "@" + this.defenderTile.getId() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Change {
        protected See see;

        Change(See see) {
            this.see = see;
        }

        public abstract int getPriority();

        public boolean isNotifiable(ServerPlayer serverPlayer) {
            return this.see.check(serverPlayer, this.isPerhapsNotifiable(serverPlayer));
        }

        public boolean isPerhapsNotifiable(ServerPlayer serverPlayer) {
            return false;
        }

        public List<Change> consequences(ServerPlayer serverPlayer) {
            return Collections.emptyList();
        }

        public boolean convertsToElement() {
            return true;
        }

        public abstract Element toElement(ServerPlayer var1, Document var2);

        public void attachToElement(Element element) {
        }

        public abstract String toString();
    }

    public static class See {
        private static final int ALL = 1;
        private static final int PERHAPS = 0;
        private static final int ONLY = -1;
        private ServerPlayer seeAlways = null;
        private ServerPlayer seePerhaps = null;
        private ServerPlayer seeNever = null;
        private int type;

        private See(int type) {
            this.type = type;
        }

        public boolean check(ServerPlayer player, boolean perhapsResult) {
            return this.seeNever == player ? false : (this.seeAlways == player ? true : (this.type == -1 ? false : (this.type == 1 ? true : perhapsResult)));
        }

        public static See all() {
            return new See(1);
        }

        public static See perhaps() {
            return new See(0);
        }

        public static See only(ServerPlayer player) {
            return new See(-1).always(player);
        }

        public See always(ServerPlayer player) {
            this.seeAlways = player;
            return this;
        }

        public See perhaps(ServerPlayer player) {
            this.seePerhaps = player;
            return this;
        }

        public See except(ServerPlayer player) {
            this.seeNever = player;
            return this;
        }

        public String toString() {
            String ret;
            String string = this.type == 1 ? "ALL" : (this.type == 0 ? "PERHAPS" : (ret = this.type == -1 ? "ONLY" : "BADTYPE"));
            if (this.seeAlways != null) {
                ret = ret + ",always(" + this.seeAlways.getId() + ")";
            }
            if (this.seePerhaps != null) {
                ret = ret + ",perhaps(" + this.seePerhaps.getId() + ")";
            }
            if (this.seeNever != null) {
                ret = ret + ",never(" + this.seeNever.getId() + ")";
            }
            return ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChangePriority {
        CHANGE_ATTRIBUTE(-1),
        CHANGE_ANIMATION(0),
        CHANGE_REMOVE(100),
        CHANGE_STANCE(5),
        CHANGE_OWNED(20),
        CHANGE_UPDATE(10),
        CHANGE_EARLY(1),
        CHANGE_NORMAL(15),
        CHANGE_LATE(90);

        private int level;

        private ChangePriority(int level) {
            this.level = level;
        }

        public int getPriority() {
            return this.level;
        }
    }
}

