/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.TransportMission;

public class PrivateerMission
extends Mission {
    private static final Logger logger = Logger.getLogger(PrivateerMission.class.getName());
    private static String tag = "AI privateer";
    private Location target = null;

    public PrivateerMission(AIMain aiMain, AIUnit aiUnit) {
        this(aiMain, aiUnit, PrivateerMission.findTarget(aiUnit, 8, true));
    }

    public PrivateerMission(AIMain aiMain, AIUnit aiUnit, Location target) {
        super(aiMain, aiUnit);
        this.setTarget(target);
        Unit unit = aiUnit.getUnit();
        logger.finest(tag + " begins at " + unit.getLocation() + ": " + this);
        this.uninitialized = false;
    }

    public PrivateerMission(AIMain aiMain, AIUnit aiUnit, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, aiUnit);
        this.readFromXML(in);
        this.uninitialized = this.getAIUnit() == null;
    }

    public static Location extractTarget(AIUnit aiUnit, PathNode path) {
        Unit other;
        if (path == null) {
            return null;
        }
        Unit unit = aiUnit.getUnit();
        Player owner = unit.getOwner();
        Location loc = path.getLastNode().getLocation();
        Settlement settlement = loc.getSettlement();
        Tile tile = loc.getTile();
        Unit unit2 = other = tile == null ? null : tile.getDefendingUnit(unit);
        return loc instanceof Europe ? loc : (other != null && PrivateerMission.invalidUnitReason(aiUnit, other) == null ? other : (settlement != null && PrivateerMission.invalidTargetReason(settlement, owner) == null ? settlement : null));
    }

    private static int scoreUnit(AIUnit aiUnit, Unit defender) {
        Unit attacker = aiUnit.getUnit();
        int value = 1000;
        value += defender.getVisibleGoodsCount() * 200;
        if (defender.isOffensiveUnit()) {
            value = (int)((float)value - attacker.getGame().getCombatModel().getDefencePower(attacker, defender) * 100.0f);
        }
        return value;
    }

    public static int scorePath(AIUnit aiUnit, PathNode path) {
        Location loc = PrivateerMission.extractTarget(aiUnit, path);
        if (loc instanceof Europe || loc instanceof Colony) {
            return 1000 / (path.getTotalTurns() + 1);
        }
        if (loc instanceof Unit) {
            return PrivateerMission.scoreUnit(aiUnit, (Unit)loc) / (path.getTotalTurns() + 1);
        }
        return Integer.MIN_VALUE;
    }

    private static GoalDecider getGoalDecider(final AIUnit aiUnit, boolean deferOK) {
        return new GoalDecider(){
            private PathNode bestPath = null;
            private int bestValue = 0;

            public PathNode getGoal() {
                return this.bestPath;
            }

            public boolean hasSubGoals() {
                return true;
            }

            public boolean check(Unit u, PathNode path) {
                int value = PrivateerMission.scorePath(aiUnit, path);
                if (this.bestValue < value) {
                    this.bestValue = value;
                    this.bestPath = path;
                    return true;
                }
                return false;
            }
        };
    }

    public static PathNode findTargetPath(AIUnit aiUnit, int range, boolean deferOK) {
        if (PrivateerMission.invalidAIUnitReason(aiUnit) != null) {
            return null;
        }
        Unit unit = aiUnit.getUnit();
        Tile startTile = unit.getPathStartTile();
        if (startTile == null) {
            return null;
        }
        return unit.search(startTile, PrivateerMission.getGoalDecider(aiUnit, deferOK), CostDeciders.avoidIllegal(), range, null);
    }

    public static Location findTarget(AIUnit aiUnit, int range, boolean deferOK) {
        PathNode path = PrivateerMission.findTargetPath(aiUnit, range, deferOK);
        return path != null ? PrivateerMission.extractTarget(aiUnit, path) : null;
    }

    public Location getTransportDestination() {
        return null;
    }

    public Location getTarget() {
        return this.target;
    }

    public void setTarget(Location target) {
        if (target == null || target instanceof Colony || target instanceof Europe || target instanceof Unit) {
            boolean retarget = this.target != null && this.target != target;
            this.target = target;
            if (retarget) {
                this.retargetTransportable();
            }
        }
    }

    public Location findTarget() {
        return PrivateerMission.findTarget(this.getAIUnit(), 8, true);
    }

    private static String invalidMissionReason(AIUnit aiUnit) {
        String reason = PrivateerMission.invalidAIUnitReason(aiUnit);
        if (reason != null) {
            return reason;
        }
        Unit unit = aiUnit.getUnit();
        return !unit.isCarrier() ? "unit-not-a-carrier" : (!unit.isOffensiveUnit() ? "unit-not-offensive" : (!unit.hasAbility("model.ability.piracy") ? "unit-not-a-pirate" : null));
    }

    private static String invalidSettlementReason(AIUnit aiUnit, Settlement settlement) {
        return settlement instanceof Colony ? PrivateerMission.invalidTargetReason(settlement, aiUnit.getUnit().getOwner()) : "target-invalid";
    }

    private static String invalidUnitReason(AIUnit aiUnit, Unit unit) {
        Player player = aiUnit.getUnit().getOwner();
        Player other = unit.getOwner();
        return unit == null ? "target-invalid" : (!unit.isNaval() ? "privateer-ignores-land-unit" : (player == other ? "target-ownership" : (player.getStance(other) == Player.Stance.ALLIANCE ? "privateer-avoids-ally" : (PrivateerMission.scoreUnit(aiUnit, unit) <= 0 ? "privateer-avoids-trouble" : null))));
    }

    public static String invalidReason(AIUnit aiUnit) {
        return PrivateerMission.invalidMissionReason(aiUnit);
    }

    public static String invalidReason(AIUnit aiUnit, Location loc) {
        String reason = PrivateerMission.invalidMissionReason(aiUnit);
        return reason != null ? reason : (aiUnit.getUnit().isInEurope() ? null : (loc == null ? null : (loc instanceof Europe ? PrivateerMission.invalidTargetReason(loc, aiUnit.getUnit().getOwner()) : (loc instanceof Settlement ? PrivateerMission.invalidSettlementReason(aiUnit, (Settlement)loc) : (loc instanceof Unit ? PrivateerMission.invalidUnitReason(aiUnit, (Unit)loc) : "target-invalid")))));
    }

    public String invalidReason() {
        return PrivateerMission.invalidReason(this.getAIUnit(), this.getTarget());
    }

    public void doMission() {
        Unit unit;
        AIMain aiMain = this.getAIMain();
        AIUnit aiUnit = this.getAIUnit();
        if (aiUnit.hasCargo()) {
            aiUnit.setMission(new TransportMission(aiMain, aiUnit));
            aiUnit.getMission().doMission();
            return;
        }
        String reason = this.invalidReason();
        if (this.isTargetReason(reason)) {
            if (!this.retargetMission(tag, reason)) {
                return;
            }
        } else if (reason != null) {
            logger.finest(tag + " broken(" + reason + "): " + this);
            return;
        }
        if ((unit = this.getUnit()).isAtSea()) {
            return;
        }
        if (unit.isInEurope()) {
            Settlement settlement = PrivateerMission.getBestSettlement(unit.getOwner());
            Tile tile = settlement != null ? settlement.getTile() : unit.getFullEntryLocation();
            unit.setDestination(tile);
            aiUnit.moveToAmerica();
            return;
        }
        Location newTarget = PrivateerMission.findTarget(aiUnit, 1, true);
        if (newTarget == null) {
            this.moveRandomlyTurn(tag);
            return;
        }
        this.setTarget(newTarget);
        Unit.MoveType mt = this.travelToTarget(tag, this.getTarget(), null);
        switch (mt) {
            case MOVE: 
            case MOVE_HIGH_SEAS: 
            case MOVE_NO_MOVES: 
            case MOVE_NO_REPAIR: {
                return;
            }
            case MOVE_ILLEGAL: {
                logger.finest(tag + " hit unexpected blockage: " + this);
                this.moveRandomly(tag, null);
                unit.setMovesLeft(0);
                return;
            }
            case ATTACK_UNIT: {
                Map.Direction direction = unit.getTile().getDirection(this.getTarget().getTile());
                if (direction != null) {
                    logger.finest(tag + " completed hunt for target " + this.getTarget() + ", attacking: " + this);
                    AIMessage.askAttack(aiUnit, direction);
                    break;
                }
                Location blocker = PrivateerMission.resolveBlockage(aiUnit, this.getTarget());
                if (blocker instanceof Unit && PrivateerMission.scoreUnit(aiUnit, (Unit)blocker) > 0) {
                    logger.finest(tag + " bumped into " + blocker + ", attacking: " + this);
                    AIMessage.askAttack(aiUnit, unit.getTile().getDirection(blocker.getTile()));
                    break;
                }
                logger.finest(tag + " bumped into " + blocker + ", avoiding: " + this);
                this.moveRandomlyTurn(tag);
                break;
            }
            default: {
                logger.warning(tag + " unexpected hunt move " + (Object)((Object)mt) + ": " + this);
            }
        }
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        if (this.isValid()) {
            this.toXML(out, PrivateerMission.getXMLElementTagName());
        }
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        if (this.target != null) {
            this.writeAttribute(out, "target", (FreeColGameObject)((Object)this.target));
        }
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        String str = in.getAttributeValue(null, "target");
        this.target = str == null ? null : this.getGame().getFreeColLocation(str);
    }

    public static String getXMLElementTagName() {
        return "privateerMission";
    }
}

