/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.WorkInsideColonyMission;

public class DefendSettlementMission
extends Mission {
    private static final Logger logger = Logger.getLogger(DefendSettlementMission.class.getName());
    private String tag = "AI defender";
    private static int MAX_TURNS = 20;
    private Location target = null;

    public DefendSettlementMission(AIMain aiMain, AIUnit aiUnit, Settlement settlement) {
        super(aiMain, aiUnit);
        this.setTarget(settlement);
        logger.finest(this.tag + " started with " + this.target + ": " + this);
        this.uninitialized = false;
    }

    public DefendSettlementMission(AIMain aiMain, AIUnit aiUnit, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, aiUnit);
        this.readFromXML(in);
        this.uninitialized = this.getAIUnit() == null;
    }

    public static Location extractTarget(AIUnit aiUnit, PathNode path) {
        if (path == null) {
            return null;
        }
        Location loc = path.getLastNode().getLocation();
        Settlement settlement = loc.getSettlement();
        return DefendSettlementMission.invalidReason(aiUnit, settlement) == null ? settlement : null;
    }

    public static int scorePath(AIUnit aiUnit, PathNode path) {
        Location loc = DefendSettlementMission.extractTarget(aiUnit, path);
        return loc instanceof Settlement ? aiUnit.getAIOwner().adjustMission(aiUnit, path, DefendSettlementMission.class, (int)(1000.0f * ((Settlement)loc).getDefenceRatio() / (float)(path.getTotalTurns() + 1))) : Integer.MIN_VALUE;
    }

    private static GoalDecider getGoalDecider(final AIUnit aiUnit) {
        return new GoalDecider(){
            private PathNode bestPath = null;
            private int bestValue = 0;

            public PathNode getGoal() {
                return this.bestPath;
            }

            public boolean hasSubGoals() {
                return true;
            }

            public boolean check(Unit u, PathNode path) {
                int value = DefendSettlementMission.scorePath(aiUnit, path);
                if (this.bestValue < value) {
                    this.bestValue = value;
                    this.bestPath = path;
                    return true;
                }
                return false;
            }
        };
    }

    public static PathNode findTargetPath(AIUnit aiUnit, int range, boolean deferOK) {
        if (DefendSettlementMission.invalidAIUnitReason(aiUnit) != null) {
            return null;
        }
        Unit unit = aiUnit.getUnit();
        Tile startTile = unit.getPathStartTile();
        if (startTile == null) {
            return null;
        }
        return unit.search(startTile, DefendSettlementMission.getGoalDecider(aiUnit), CostDeciders.avoidSettlementsAndBlockingUnits(), range, unit.getCarrier());
    }

    public static Location findTarget(AIUnit aiUnit, int range, boolean deferOK) {
        PathNode path = DefendSettlementMission.findTargetPath(aiUnit, range, deferOK);
        return path != null ? DefendSettlementMission.extractTarget(aiUnit, path) : null;
    }

    public Location getTransportDestination() {
        return this.getUnit().shouldTakeTransportTo(this.getTarget()) ? this.getTarget() : null;
    }

    public int getTransportPriority() {
        return this.getTransportDestination() == null ? 0 : 105;
    }

    public Location getTarget() {
        return this.target;
    }

    public void setTarget(Location target) {
        if (target == null || target instanceof Settlement) {
            boolean retarget = this.target != null && this.target != target;
            this.target = target;
            if (retarget) {
                this.retargetTransportable();
            }
        }
    }

    public Location findTarget() {
        return DefendSettlementMission.findTarget(this.getAIUnit(), 4, true);
    }

    private static String invalidMissionReason(AIUnit aiUnit) {
        String reason = DefendSettlementMission.invalidAIUnitReason(aiUnit);
        if (reason != null) {
            return reason;
        }
        Unit unit = aiUnit.getUnit();
        return unit.getGame().getCombatModel().getDefencePower(null, unit) <= 0.0f ? "unit-not-defender" : null;
    }

    private static String invalidSettlementReason(AIUnit aiUnit, Settlement settlement) {
        return DefendSettlementMission.invalidTargetReason(settlement, aiUnit.getUnit().getOwner());
    }

    public static String invalidReason(AIUnit aiUnit) {
        String reason = DefendSettlementMission.invalidMissionReason(aiUnit);
        return reason != null ? reason : (aiUnit.getUnit().getOwner().getNumberOfSettlements() <= 0 ? "target-not-found" : null);
    }

    public static String invalidReason(AIUnit aiUnit, Location loc) {
        String reason = DefendSettlementMission.invalidMissionReason(aiUnit);
        return reason != null ? reason : (loc instanceof Settlement ? DefendSettlementMission.invalidSettlementReason(aiUnit, (Settlement)loc) : "target-invalid");
    }

    public String invalidReason() {
        return DefendSettlementMission.invalidReason(this.getAIUnit(), this.getTarget());
    }

    public void doMission() {
        String reason = this.invalidReason();
        if (this.isTargetReason(reason)) {
            if (!this.retargetMission(this.tag, reason)) {
                return;
            }
        } else if (reason != null) {
            logger.finest(this.tag + " broken(" + reason + "): " + this);
            return;
        }
        if (this.travelToTarget(this.tag, this.getTarget(), CostDeciders.avoidSettlementsAndBlockingUnits()) != Unit.MoveType.MOVE) {
            return;
        }
        AIMain aiMain = this.getAIMain();
        AIUnit aiUnit = this.getAIUnit();
        Unit unit = this.getUnit();
        WorkInsideColonyMission m = null;
        if (this.getTarget() instanceof Colony) {
            Colony colony = (Colony)this.getTarget();
            if (unit.getLocation() instanceof WorkLocation || unit.isPerson() && colony.getUnitCount() <= 1) {
                m = new WorkInsideColonyMission(aiMain, aiUnit, aiMain.getAIColony(colony));
                aiUnit.setMission(m);
                ((Mission)m).doMission();
                return;
            }
        }
        if (unit.getState() == Unit.UnitState.FORTIFIED || unit.getState() == Unit.UnitState.FORTIFYING) {
            return;
        }
        Settlement settlement = (Settlement)this.getTarget();
        int defenderCount = 0;
        int fortifiedCount = 0;
        List<Unit> units = settlement.getUnitList();
        units.addAll(settlement.getTile().getUnitList());
        for (Unit u : units) {
            AIUnit aiu = this.getAIMain().getAIUnit(u);
            if (DefendSettlementMission.invalidMissionReason(aiu) != null) continue;
            ++defenderCount;
            if (u.getState() != Unit.UnitState.FORTIFIED) continue;
            ++fortifiedCount;
        }
        if (defenderCount <= 2 || fortifiedCount <= 1) {
            String logMe = !unit.checkSetState(Unit.UnitState.FORTIFYING) ? " waiting to fortify at " : (AIMessage.askChangeState(aiUnit, Unit.UnitState.FORTIFYING) && unit.getState() == Unit.UnitState.FORTIFYING ? " completed (fortifying) at " : " fortify failed at ");
            logger.finest(this.tag + logMe + settlement.getName() + ": " + this);
            return;
        }
        if (!unit.isOffensiveUnit()) {
            return;
        }
        CombatModel cm = unit.getGame().getCombatModel();
        Unit bestTarget = null;
        float bestDifference = Float.MIN_VALUE;
        Map.Direction bestDirection = null;
        for (Map.Direction d : Map.Direction.getRandomDirections("defendSettlements", this.getAIRandom())) {
            float weDefend;
            float enemyDefend;
            Unit defender;
            Tile t = unit.getTile().getNeighbourOrNull(d);
            if (t == null || (defender = t.getFirstUnit()) == null || !defender.getOwner().atWarWith(unit.getOwner()) || !unit.getMoveType(d).isAttack()) continue;
            Unit enemyUnit = t.getDefendingUnit(unit);
            float enemyAttack = cm.getOffencePower(enemyUnit, unit);
            float weAttack = cm.getOffencePower(unit, enemyUnit);
            float difference = weAttack / (weAttack + (enemyDefend = cm.getDefencePower(unit, enemyUnit))) - enemyAttack / (enemyAttack + (weDefend = cm.getDefencePower(enemyUnit, unit)));
            if (!(difference > bestDifference) || !(difference > 0.0f) && !(weAttack > enemyDefend)) continue;
            bestDifference = difference;
            bestTarget = enemyUnit;
            bestDirection = d;
        }
        if (bestTarget != null) {
            logger.finest(this.tag + " attacking " + bestTarget + " from " + ((Settlement)this.getTarget()).getName() + ": " + this);
            AIMessage.askAttack(this.getAIUnit(), bestDirection);
        }
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        if (this.isValid()) {
            this.toXML(out, DefendSettlementMission.getXMLElementTagName());
        }
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        if (this.target != null) {
            this.writeAttribute(out, "settlement", (FreeColGameObject)((Object)this.target));
        }
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        String str = in.getAttributeValue(null, "settlement");
        this.target = str == null ? null : this.getGame().getFreeColGameObject(str, Settlement.class);
    }

    public static String getXMLElementTagName() {
        return "defendSettlementMission";
    }
}

