/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.Comparator;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.Wish;

public interface Transportable {
    public static final int IMPORTANT_DELIVERY = 110;
    public static final int FULL_DELIVERY = 100;
    public static final int TOOLS_FOR_COLONY_PRIORITY = 10;
    public static final int TOOLS_FOR_IMPROVEMENT = 10;
    public static final int TOOLS_FOR_PIONEER = 90;
    public static final int TOOLS_FOR_BUILDING = 100;
    public static final Comparator<Transportable> transportableComparator = new Comparator<Transportable>(){

        @Override
        public int compare(Transportable t1, Transportable t2) {
            return t2.getTransportPriority() - t1.getTransportPriority();
        }
    };

    public int getSpaceTaken();

    public Location getTransportSource();

    public Location getTransportDestination();

    public int getTransportPriority();

    public void setTransportPriority(int var1);

    public void increaseTransportPriority();

    public Locatable getTransportLocatable();

    public AIUnit getTransport();

    public void setTransport(AIUnit var1, String var2);

    public void abortWish(Wish var1);

    public String getId();

    public boolean leaveTransport(Map.Direction var1);

    public boolean joinTransport(Unit var1, Map.Direction var2);

    public boolean carriableBy(Unit var1);
}

