/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.Transportable;
import net.sf.freecol.server.ai.Wish;
import org.w3c.dom.Element;

public class AIGoods
extends AIObject
implements Transportable {
    private static final Logger logger = Logger.getLogger(AIGoods.class.getName());
    private Goods goods;
    private Location destination;
    private int transportPriority;
    private AIUnit transport = null;

    public AIGoods(AIMain aiMain, String id) {
        super(aiMain, id);
        this.goods = null;
        this.destination = null;
        this.transportPriority = -1;
        this.transport = null;
    }

    public AIGoods(AIMain aiMain, Location location, GoodsType type, int amount, Location destination) {
        this(aiMain, AIGoods.getXMLElementTagName() + ":" + aiMain.getNextId());
        this.goods = new Goods(aiMain.getGame(), location, type, amount);
        this.destination = destination;
        this.uninitialized = false;
    }

    public AIGoods(AIMain aiMain, Element element) {
        super(aiMain, element);
        this.uninitialized = this.getGoods() == null;
    }

    public AIGoods(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, in);
        this.uninitialized = this.getGoods() == null;
    }

    public void dispose() {
        this.setTransport(null, "disposing");
        if (this.destination != null) {
            if (this.destination instanceof Colony) {
                AIColony aic = this.getAIMain().getAIColony((Colony)this.destination);
                if (aic != null) {
                    aic.removeAIGoods(this);
                }
            } else if (!(this.destination instanceof Europe)) {
                logger.warning("Unknown type of destination: " + this.destination);
            }
            this.destination = null;
        }
        this.goods = null;
        super.dispose();
    }

    public Goods getGoods() {
        return this.goods;
    }

    public void setGoods(Goods goods) {
        this.goods = goods;
    }

    public GoodsType getGoodsType() {
        return this.goods.getType();
    }

    public int getGoodsAmount() {
        return this.goods.getAmount();
    }

    public boolean checkIntegrity() {
        String why;
        String string = !super.checkIntegrity() ? "super" : (this.goods == null ? "null-goods" : (this.goods.getType() == null ? "null-goods-type" : (this.goods.getAmount() <= 0 ? "non-positive-goods-amount" : (this.goods.getLocation() == null ? "null-location" : (((FreeColGameObject)((Object)this.goods.getLocation())).isDisposed() ? "disposed-location" : (this.destination == null ? "null-destination" : (why = ((FreeColGameObject)((Object)this.destination)).isDisposed() ? "disposed-destination" : "ok")))))));
        if (!"ok".equals(why)) {
            logger.finest("checkIntegrity(" + this.toString() + ") = " + why);
        }
        return super.checkIntegrity() && this.goods != null && this.goods.getType() != null && this.goods.getAmount() > 0 && this.goods.getLocation() != null && !((FreeColGameObject)((Object)this.goods.getLocation())).isDisposed() && this.destination != null && !((FreeColGameObject)((Object)this.destination)).isDisposed();
    }

    public int getSpaceTaken() {
        return this.goods == null ? 0 : this.goods.getSpaceTaken();
    }

    public Location getTransportSource() {
        return this.goods == null ? null : this.goods.getLocation();
    }

    public Location getTransportDestination() {
        return this.destination;
    }

    public void setTransportDestination(Location destination) {
        this.destination = destination;
    }

    public int getTransportPriority() {
        return this.transportPriority;
    }

    public void setTransportPriority(int transportPriority) {
        this.transportPriority = transportPriority;
    }

    public void increaseTransportPriority() {
        ++this.transportPriority;
    }

    public Locatable getTransportLocatable() {
        return this.getGoods();
    }

    public AIUnit getTransport() {
        return this.transport;
    }

    public void setTransport(AIUnit transport, String reason) {
        logger.finest("setTransport " + this + " on " + transport + ": " + reason);
        this.transport = transport;
    }

    public void abortWish(Wish w) {
        if (this.destination == w.getDestination()) {
            this.destination = null;
        }
        if (w.getTransportable() == this) {
            w.dispose();
        }
    }

    public boolean leaveTransport(int amount) {
        int newAmount;
        boolean result;
        GoodsType type;
        if (!(this.goods.getLocation() instanceof Unit)) {
            return false;
        }
        Unit carrier = (Unit)this.goods.getLocation();
        if (carrier.getGoodsCount(type = this.goods.getType()) < amount) {
            return false;
        }
        AIUnit aiCarrier = this.getAIMain().getAIUnit(carrier);
        Colony colony = carrier.getColony();
        int oldAmount = carrier.getGoodsCount(type);
        Goods newGoods = new Goods(carrier.getGame(), carrier, type, amount);
        if (carrier.isInEurope()) {
            if (carrier.getOwner().canTrade(type)) {
                result = AIMessage.askSellGoods(aiCarrier, newGoods);
                logger.finest("Sell " + newGoods + " in Europe " + (result ? "succeeds" : "fails") + ": " + this);
            } else {
                result = AIMessage.askUnloadCargo(aiCarrier, newGoods);
            }
        } else {
            result = AIMessage.askUnloadCargo(aiCarrier, newGoods);
        }
        if (result && oldAmount - (newAmount = carrier.getGoodsCount(type)) != amount) {
            logger.warning(carrier + " at " + carrier.getLocation() + " only unloaded " + (oldAmount - newAmount) + " " + type + " (" + amount + " expected)");
            result = false;
        }
        if (result && colony != null) {
            AIColony aiColony = this.getAIMain().getAIColony(colony);
            if (aiColony != null) {
                aiColony.completeWish(newGoods);
            }
            colony.firePropertyChange("rearrangeWorkers", true, false);
        }
        return result;
    }

    public boolean leaveTransport(Map.Direction direction) {
        if (direction != null) {
            return false;
        }
        return this.leaveTransport(this.goods.getAmount());
    }

    public boolean joinTransport(Unit carrier, Map.Direction direction) {
        int newAmount;
        if (direction != null) {
            return false;
        }
        AIUnit aiCarrier = this.getAIMain().getAIUnit(carrier);
        if (aiCarrier == null) {
            return false;
        }
        GoodsType goodsType = this.goods.getType();
        int goodsAmount = this.goods.getAmount();
        int oldAmount = carrier.getGoodsCount(goodsType);
        boolean result = carrier.isInEurope() ? AIMessage.askBuyGoods(aiCarrier, goodsType, goodsAmount) : AIMessage.askLoadCargo(aiCarrier, this.goods);
        if (result && (newAmount = carrier.getGoodsCount(goodsType)) - oldAmount != goodsAmount) {
            logger.warning(carrier + " at " + carrier.getLocation() + " only loaded " + (newAmount - oldAmount) + " " + goodsType + " (" + goodsAmount + " expected)");
            goodsAmount = newAmount - oldAmount;
            boolean bl = result = goodsAmount > 0;
        }
        if (result) {
            Colony colony = carrier.getColony();
            if (colony != null) {
                this.getAIMain().getAIColony(colony).removeAIGoods(this);
            }
            this.setGoods(new Goods(this.getGame(), carrier, goodsType, goodsAmount));
        }
        return result;
    }

    public boolean carriableBy(Unit carrier) {
        return carrier.couldCarry(this.getGoods());
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(AIGoods.getXMLElementTagName());
        this.writeAttributes(out);
        this.goods.toXML(out);
        out.writeEndElement();
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        if (this.destination != null) {
            out.writeAttribute("destination", this.destination.getId());
        }
        out.writeAttribute("transportPriority", Integer.toString(this.transportPriority));
        if (this.transport != null) {
            if (this.getAIMain().getAIObject(this.transport.getId()) == null) {
                logger.warning("broken reference to transport");
            } else {
                out.writeAttribute("transport", this.transport.getId());
            }
        }
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        AIMain aiMain = this.getAIMain();
        this.setId(in.getAttributeValue(null, "ID"));
        String str = in.getAttributeValue(null, "destination");
        this.destination = aiMain.getGame().getFreeColLocation(str);
        this.transportPriority = this.getAttribute(in, "transportPriority", -1);
        str = in.getAttributeValue(null, "transport");
        if (str == null) {
            this.transport = null;
        } else {
            this.transport = (AIUnit)aiMain.getAIObject(str);
            if (this.transport == null) {
                this.transport = new AIUnit(aiMain, str);
            }
        }
    }

    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        if (Goods.getXMLElementTagName().equals(in.getLocalName())) {
            if (this.goods != null) {
                this.goods.readFromXML(in);
            } else {
                this.goods = new Goods(this.getAIMain().getGame(), in);
            }
        }
    }

    public String toString() {
        return "[" + this.getId() + " " + this.goods + (this.goods == null ? "" : " at " + this.goods.getLocation()) + " -> " + this.destination + (this.transport == null ? "" : " using " + this.transport) + " /" + this.transportPriority + "]";
    }

    public static String getXMLElementTagName() {
        return "aiGoods";
    }
}

