/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitWas;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.ai.AIGoods;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.ColonyPlan;
import net.sf.freecol.server.ai.EuropeanAIPlayer;
import net.sf.freecol.server.ai.GoodsWish;
import net.sf.freecol.server.ai.TileImprovementPlan;
import net.sf.freecol.server.ai.Transportable;
import net.sf.freecol.server.ai.Wish;
import net.sf.freecol.server.ai.WorkLocationPlan;
import net.sf.freecol.server.ai.WorkerWish;
import net.sf.freecol.server.ai.mission.BuildColonyMission;
import net.sf.freecol.server.ai.mission.DefendSettlementMission;
import net.sf.freecol.server.ai.mission.IdleAtSettlementMission;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.TransportMission;
import net.sf.freecol.server.ai.mission.WorkInsideColonyMission;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AIColony
extends AIObject
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(AIColony.class.getName());
    private static final String LIST_ELEMENT = "ListElement";
    private static final int FOREST_MINIMUM = 1;
    private static final int EXPORT_MINIMUM = 10;
    private Colony colony = null;
    private ColonyPlan colonyPlan = null;
    private final List<AIGoods> aiGoods;
    private final List<Wish> wishes;
    private final List<TileImprovementPlan> tileImprovementPlans;
    private Turn rearrangeTurn = new Turn(0);
    private static final Set<GoodsType> fullExport = new HashSet<GoodsType>();
    private static final Set<GoodsType> partExport = new HashSet<GoodsType>();
    private static final Comparator<Unit> scoutComparator = new Comparator<Unit>(){

        @Override
        public int compare(Unit u1, Unit u2) {
            boolean a2;
            boolean a1 = u1.hasAbility("model.ability.expertScout");
            if (a1 != (a2 = u2.hasAbility("model.ability.expertScout"))) {
                return a1 ? -1 : 1;
            }
            a1 = u1.hasAbility("model.ability.scoutIndianSettlement");
            if (a1 != (a2 = u2.hasAbility("model.ability.scoutIndianSettlement"))) {
                return a1 ? -1 : 1;
            }
            return u1.getType().getSkill() - u2.getType().getSkill();
        }
    };

    public AIColony(AIMain aiMain, String id) {
        super(aiMain, id);
        this.aiGoods = new ArrayList<AIGoods>();
        this.wishes = new ArrayList<Wish>();
        this.tileImprovementPlans = new ArrayList<TileImprovementPlan>();
    }

    public AIColony(AIMain aiMain, Colony colony) {
        this(aiMain, colony.getId());
        this.colony = colony;
        this.colonyPlan = new ColonyPlan(aiMain, colony);
        colony.addPropertyChangeListener("rearrangeWorkers", this);
        this.uninitialized = false;
    }

    public AIColony(AIMain aiMain, Element element) {
        this(aiMain, (String)null);
        this.readFromXMLElement(element);
        this.addAIObjectWithId();
        this.uninitialized = this.getColony() == null;
    }

    public AIColony(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        this(aiMain, (String)null);
        this.readFromXML(in);
        this.addAIObjectWithId();
        this.uninitialized = this.getColony() == null;
    }

    @Override
    public void dispose() {
        ArrayList<AIObject> disposeList = new ArrayList<AIObject>();
        for (AIGoods ag : this.aiGoods) {
            if (ag.getGoods().getLocation() != this.colony) continue;
            disposeList.add(ag);
        }
        for (Wish w : this.wishes) {
            disposeList.add(w);
        }
        for (TileImprovementPlan ti : this.tileImprovementPlans) {
            disposeList.add(ti);
        }
        for (AIObject o : disposeList) {
            o.dispose();
        }
        this.colonyPlan = null;
        super.dispose();
    }

    @Override
    public String getId() {
        if (this.colony == null) {
            logger.warning("Uninitialized AI colony");
            return null;
        }
        return this.colony.getId();
    }

    public Colony getColony() {
        return this.colony;
    }

    public ColonyPlan getColonyPlan() {
        return this.colonyPlan;
    }

    protected AIUnit getAIUnit(Unit unit) {
        return this.getAIMain().getAIUnit(unit);
    }

    protected AIPlayer getAIOwner() {
        return this.getAIMain().getAIPlayer(this.colony.getOwner());
    }

    public static boolean isBadlyDefended(Colony colony) {
        return colony.getTotalDefencePower() < 1.25f * (float)colony.getWorkLocationUnitCount() - 2.5f;
    }

    public boolean isBadlyDefended() {
        return AIColony.isBadlyDefended(this.colony);
    }

    public boolean rearrangeWorkers() {
        int turn = this.getGame().getTurn().getNumber();
        if (this.colony.getWorkLocationUnitCount() <= 0) {
            this.avertAutoDestruction();
        } else if (this.rearrangeTurn.getNumber() > turn) {
            if (this.colony.getCurrentlyBuilding() == null && this.colonyPlan.getBestBuildableType() != null) {
                logger.warning(this.colony.getName() + " could be building but" + " is asleep until turn: " + this.rearrangeTurn.getNumber() + "( > " + turn + ")");
            }
            return false;
        }
        Tile tile = this.colony.getTile();
        AIMain aiMain = this.getAIMain();
        Player player = this.colony.getOwner();
        Specification spec = this.getSpecification();
        int nextRearrange = 15;
        this.exploreLCRs();
        this.stealTiles();
        for (Tile t : tile.getSurroundingTiles(1)) {
            if (player.owns(t) || !player.canClaimForSettlement(t)) continue;
            AIMessage.askClaimLand(t, this, 0);
        }
        this.colonyPlan.update();
        BuildableType oldBuild = this.colony.getCurrentlyBuilding();
        BuildableType build = this.colonyPlan.getBestBuildableType();
        if (build != oldBuild) {
            ArrayList<BuildableType> queue = new ArrayList<BuildableType>();
            if (build != null) {
                queue.add(build);
            }
            AIMessage.askSetBuildQueue(this, queue);
            build = this.colony.getCurrentlyBuilding();
        }
        this.colonyPlan.refine(build);
        List<Unit> workers = this.colony.getUnitList();
        ArrayList<UnitWas> was = new ArrayList<UnitWas>();
        for (Unit u : workers) {
            was.add(new UnitWas(u));
        }
        for (Unit u : tile.getUnitList()) {
            Mission mission;
            if (!u.isPerson() || this.getAIUnit(u) == null || (mission = this.getAIUnit(u).getMission()) != null && !(mission instanceof IdleAtSettlementMission) && !(mission instanceof WorkInsideColonyMission) && (!(mission instanceof BuildColonyMission) || ((BuildColonyMission)mission).getTarget() != tile) && !(mission instanceof DefendSettlementMission)) continue;
            workers.add(u);
            was.add(new UnitWas(u));
        }
        AIPlayer aiPlayer = this.getAIOwner();
        boolean preferScouts = ((EuropeanAIPlayer)aiPlayer).scoutsNeeded() > 0;
        Colony scratch = this.colonyPlan.assignWorkers(workers, preferScouts);
        if (scratch == null) {
            if (!UnitWas.revertAll(was)) {
                String complain = "Failed to revert:";
                for (UnitWas w : was) {
                    complain = complain + " " + w.getUnit() + ",";
                }
                logger.warning(complain.substring(0, complain.length() - 1));
            }
            this.rearrangeTurn = new Turn(turn + 1);
            return false;
        }
        for (Unit u : scratch.getUnitList()) {
            WorkLocation wl = (WorkLocation)u.getLocation();
            wl = this.colony.getCorrespondingWorkLocation(wl);
            u.setLocation(wl);
        }
        for (Unit u : scratch.getTile().getUnitList()) {
            u.setLocation(tile);
        }
        for (GoodsType g : spec.getGoodsTypeList()) {
            if (!g.isStorable()) continue;
            int oldCount = this.colony.getGoodsCount(g);
            int newCount = scratch.getGoodsCount(g);
            if (newCount == oldCount) continue;
            this.colony.getGoodsContainer().addGoods(g, newCount - oldCount);
        }
        scratch.disposeScratchColony();
        if (this.colony.getWorkLocationUnitCount() <= 0) {
            String destruct = "Autodestruct at " + this.colony.getName() + " in " + turn + ":";
            for (UnitWas uw : was) {
                destruct = destruct + "\n" + uw.toString();
            }
            logger.warning(destruct);
            this.avertAutoDestruction();
        }
        if (build != null && !this.colony.canBuild(build)) {
            logger.warning(this.colony.getName() + " reneged building " + Utils.lastPart(build.toString(), ".") + ": " + (Object)((Object)this.colony.getNoBuildReason(build)));
            ArrayList<BuildableType> queue = new ArrayList<BuildableType>();
            build = this.colonyPlan.getBestBuildableType();
            if (build != null) {
                queue.add(build);
            }
            AIMessage.askSetBuildQueue(this, queue);
            nextRearrange = 1;
        }
        if (this.colony.getNetProductionOf(spec.getPrimaryFoodType()) < 0) {
            int net = this.colony.getNetProductionOf(spec.getPrimaryFoodType());
            int when = this.colony.getGoodsCount(spec.getPrimaryFoodType()) / -net;
            nextRearrange = Math.max(0, Math.min(nextRearrange, when - 1));
        }
        int warehouse = this.colony.getWarehouseCapacity();
        for (GoodsType g : spec.getGoodsTypeList()) {
            if (!g.isStorable() || g.isFoodType()) continue;
            int have = this.colony.getGoodsCount(g);
            int net = this.colony.getAdjustedNetProductionOf(g);
            if (net >= 0 && (have >= warehouse || g.limitIgnored())) continue;
            int when = net < 0 ? have / -net - 1 : (net > 0 ? (warehouse - have) / net - 1 : Integer.MAX_VALUE);
            nextRearrange = Math.max(1, Math.min(nextRearrange, when));
        }
        build = this.colony.getCurrentlyBuilding();
        String buildStr = build != null ? build.toString() : ((build = this.colonyPlan.getBestBuildableType()) != null ? "unexpected-null(" + build.toString() + ")" : "expected-null");
        String report = "Rearrange " + this.colony.getName() + " (" + this.colony.getWorkLocationUnitCount() + ")" + " build=" + buildStr + " " + this.getGame().getTurn() + " + " + nextRearrange;
        for (UnitWas uw : was) {
            report = report + "\n" + uw.toString();
        }
        logger.finest(report);
        for (Unit u : this.colony.getUnitList()) {
            AIUnit aiU = this.getAIUnit(u);
            if (aiU.getMission() instanceof WorkInsideColonyMission && ((WorkInsideColonyMission)aiU.getMission()).getAIColony() == this) continue;
            aiU.setMission(new WorkInsideColonyMission(aiMain, aiU, this));
        }
        EuropeanAIPlayer aip = (EuropeanAIPlayer)aiMain.getAIPlayer(player);
        boolean pioneersWanted = aip.pioneersNeeded() > 0;
        for (Unit u : tile.getUnitList()) {
            AIUnit aiU = this.getAIUnit(u);
            if (aiU == null || aiU.getMission() != null) continue;
            Mission m = null;
            switch (u.getRole()) {
                case SOLDIER: 
                case DRAGOON: {
                    m = new DefendSettlementMission(aiMain, aiU, this.colony);
                    break;
                }
                case SCOUT: {
                    if (!preferScouts) break;
                    m = aip.getScoutingMission(aiU);
                    break;
                }
                case PIONEER: {
                    if (!pioneersWanted) break;
                    m = aip.getPioneeringMission(aiU);
                    break;
                }
                case MISSIONARY: {
                    m = aip.getMissionaryMission(aiU);
                    break;
                }
            }
            if (m == null) continue;
            aiU.setMission(m);
        }
        this.resetExports();
        this.createTileImprovementPlans();
        this.updateWishes();
        this.rearrangeTurn = new Turn(turn + nextRearrange);
        return true;
    }

    private void resetExports() {
        Specification spec = this.getSpecification();
        if (fullExport.isEmpty()) {
            for (GoodsType g : spec.getGoodsTypeList()) {
                if (!g.isStorable() || g.isFoodType() || g.isBuildingMaterial() || g.isMilitaryGoods() || g.isTradeGoods()) continue;
                if (g.isRawMaterial()) {
                    partExport.add(g);
                    continue;
                }
                fullExport.add(g);
            }
            for (EquipmentType e : spec.getEquipmentTypeList()) {
                for (AbstractGoods ag : e.getRequiredGoods()) {
                    if (!fullExport.contains(ag.getType())) continue;
                    fullExport.remove(ag.getType());
                    partExport.add(ag.getType());
                }
            }
        }
        if (this.colony.getOwner().getMarket() == null) {
            for (GoodsType g : spec.getGoodsTypeList()) {
                this.colony.getExportData(g).setExported(false);
            }
        } else {
            int exportLevel = 4 * this.colony.getWarehouseCapacity() / 5;
            for (GoodsType g : spec.getGoodsTypeList()) {
                if (fullExport.contains(g)) {
                    this.colony.getExportData(g).setExportLevel(0);
                    this.colony.getExportData(g).setExported(true);
                    continue;
                }
                if (partExport.contains(g)) {
                    this.colony.getExportData(g).setExportLevel(exportLevel);
                    this.colony.getExportData(g).setExported(true);
                    continue;
                }
                this.colony.getExportData(g).setExported(false);
            }
        }
    }

    private void exploreLCRs() {
        Tile tile = this.colony.getTile();
        ArrayList<Unit> explorers = new ArrayList<Unit>();
        for (Unit u : tile.getUnitList()) {
            if (!u.isPerson() || u.getType().getSkill() > 0 && !u.hasAbility("model.ability.expertScout")) continue;
            explorers.add(u);
        }
        Collections.sort(explorers, scoutComparator);
        for (Tile t : tile.getSurroundingTiles(1)) {
            Unit u;
            if (!t.hasLostCityRumour()) continue;
            Map.Direction direction = tile.getDirection(t);
            do {
                if (!explorers.isEmpty()) continue;
                return;
            } while (!(u = (Unit)explorers.remove(0)).getMoveType(t).isProgress() || !this.getAIUnit(u).move(direction) || t.hasLostCityRumour());
            u.setDestination(tile);
        }
    }

    private void stealTiles() {
        Specification spec = this.getSpecification();
        Tile tile = this.colony.getTile();
        Player player = this.colony.getOwner();
        boolean hasDefender = false;
        for (Unit u : tile.getUnitList()) {
            if (!u.isDefensiveUnit() || !(this.getAIUnit(u).getMission() instanceof DefendSettlementMission)) continue;
            hasDefender = true;
            break;
        }
        if (!hasDefender) {
            return;
        }
        ArrayList<GoodsType> needed = new ArrayList<GoodsType>();
        for (GoodsType g : spec.getRawBuildingGoodsTypeList()) {
            if (this.colony.getTotalProductionOf(g) > 0) continue;
            needed.add(g);
        }
        UnitType unitType = spec.getDefaultUnitType();
        Tile steal = null;
        float score = 1.0f;
        for (Tile t : tile.getSurroundingTiles(1)) {
            Player owner = t.getOwner();
            if (owner == null || owner == player || owner.isEuropean()) continue;
            if (owner.atWarWith(player)) {
                if (!AIMessage.askClaimLand(t, this, -1) || !player.owns(t)) continue;
                logger.info(player.getName() + " stole tile " + t + " from hostile " + owner.getName());
                continue;
            }
            float s = 0.0f;
            for (GoodsType g : needed) {
                s += (float)t.potential(g, unitType);
            }
            for (GoodsType g : spec.getFoodGoodsTypeList()) {
                s = (float)((double)s + 0.1 * (double)t.potential(g, unitType));
            }
            if (!(s > score)) continue;
            score = s;
            steal = t;
        }
        if (steal != null) {
            Player owner = steal.getOwner();
            if (AIMessage.askClaimLand(steal, this, -1) && player.owns(steal)) {
                logger.info(player.getName() + " stole tile " + steal + " (score = " + score + ") from " + owner.getName());
            }
        }
    }

    private void avertAutoDestruction() {
        String msg = "Colony " + this.colony.getName() + " rearrangement leaves no units, " + this.colony.getTile().getUnitCount() + " available";
        for (Unit u : this.colony.getTile().getUnitList()) {
            msg = msg + ", " + u.toString();
        }
        List<GoodsType> libertyGoods = this.getSpecification().getLibertyGoodsTypeList();
        for (Unit u : this.colony.getTile().getUnitList()) {
            if (!u.isPerson()) continue;
            block2: for (WorkLocation wl : this.colony.getAvailableWorkLocations()) {
                if (!wl.canAdd(u)) continue;
                for (GoodsType type : libertyGoods) {
                    if (wl.getPotentialProduction(type, u.getType()) <= 0 || !AIMessage.askWork(this.getAIUnit(u), wl) || u.getLocation() != wl) continue;
                    AIMessage.askChangeWorkType(this.getAIUnit(u), type);
                    msg = msg + ".  Autodestruct averted with " + u + ".";
                    logger.warning(msg);
                    continue block2;
                }
            }
        }
        if (this.colony.getWorkLocationUnitCount() <= 0) {
            throw new IllegalStateException(msg);
        }
    }

    public List<AIGoods> getAIGoods() {
        return new ArrayList<AIGoods>(this.aiGoods);
    }

    public void removeAIGoods(AIGoods ag) {
        while (this.aiGoods.remove(ag)) {
        }
    }

    private void dropGoods(AIGoods ag) {
        if (ag.getTransport() != null && ag.getTransport().getMission() instanceof TransportMission) {
            ((TransportMission)ag.getTransport().getMission()).removeTransportable(ag, "No longer required by " + this.colony.getName());
        }
        this.removeAIGoods(ag);
        ag.dispose();
    }

    private void goodsLog(AIGoods ag, String action) {
        Goods goods = ag == null ? null : ag.getGoods();
        int amount = goods == null ? -1 : goods.getAmount();
        String type = goods == null ? "(null)" : Utils.lastPart(ag.getGoods().getType().getId(), ".");
        logger.finest(String.format("%-20s %-10s %s %s %s", this.colony.getName(), action, ag == null ? "(null)" : ag.getId(), amount >= 100 ? "full" : Integer.toString(amount), type));
    }

    public void updateAIGoods() {
        if (this.colony.hasAbility("model.ability.export")) {
            while (!this.aiGoods.isEmpty()) {
                AIGoods ag = this.aiGoods.remove(0);
                this.goodsLog(ag, "customizes");
                this.dropGoods(ag);
            }
            return;
        }
        int i = 0;
        while (i < this.aiGoods.size()) {
            AIGoods ag = this.aiGoods.get(i);
            if (ag == null) {
                this.aiGoods.remove(i);
                continue;
            }
            if (!ag.checkIntegrity()) {
                this.goodsLog(ag, "reaps");
                this.dropGoods(ag);
                continue;
            }
            if (ag.getGoods().getLocation() != this.colony) {
                this.goodsLog(ag, "sends");
                this.aiGoods.remove(i);
                continue;
            }
            if (this.colony.getAdjustedNetProductionOf(ag.getGoods().getType()) < 0) {
                this.goodsLog(ag, "needs");
                this.dropGoods(ag);
                continue;
            }
            ++i;
        }
        Europe europe = this.colony.getOwner().getEurope();
        int capacity = this.colony.getWarehouseCapacity();
        ArrayList<AIGoods> newAIGoods = new ArrayList<AIGoods>();
        for (GoodsType g : this.getSpecification().getGoodsTypeList()) {
            Europe destination;
            int exportAmount;
            if (this.colony.getAdjustedNetProductionOf(g) < 0) continue;
            int count = this.colony.getGoodsCount(g);
            int n = fullExport.contains(g) ? count : (exportAmount = partExport.contains(g) ? count - this.colony.getExportData(g).getExportLevel() : -1);
            int priority = exportAmount >= capacity ? 110 : (exportAmount >= 100 ? 100 : 0);
            i = 0;
            while (i < this.aiGoods.size()) {
                AIGoods ag = this.aiGoods.get(i);
                Goods goods = ag.getGoods();
                if (goods.getType() != g) {
                    ++i;
                    continue;
                }
                int amount = goods.getAmount();
                if (amount <= exportAmount) {
                    if (amount < 100) {
                        amount = Math.min(exportAmount, 100);
                        goods.setAmount(amount);
                        ag.setTransportPriority(priority);
                    }
                    this.goodsLog(ag, "exports");
                } else if (exportAmount >= 10) {
                    goods.setAmount(exportAmount);
                    this.goodsLog(ag, "clamps");
                } else {
                    this.goodsLog(ag, "unexports");
                    this.dropGoods(ag);
                    continue;
                }
                exportAmount -= amount;
                ++i;
            }
            Europe europe2 = destination = this.colony.getOwner().canTrade(g) ? europe : null;
            while (exportAmount >= 10) {
                int amount = Math.min(exportAmount, 100);
                AIGoods newGoods = new AIGoods(this.getAIMain(), this.colony, g, amount, destination);
                newGoods.setTransportPriority(priority);
                newAIGoods.add(newGoods);
                this.goodsLog(newGoods, "makes");
                exportAmount -= amount;
            }
        }
        this.aiGoods.addAll(newAIGoods);
        Collections.sort(this.aiGoods, Transportable.transportableComparator);
    }

    public void addWish(Wish wish) {
        this.wishes.add(wish);
    }

    public boolean completeWish(Wish wish, String reason) {
        if (!this.wishes.remove(wish)) {
            return false;
        }
        ((EuropeanAIPlayer)this.getAIOwner()).completeWish(wish);
        logger.finest(this.colony.getName() + " completes " + reason + " wish: " + wish);
        wish.dispose();
        return true;
    }

    public boolean completeWish(Goods goods) {
        boolean ret = false;
        int i = 0;
        while (i < this.wishes.size()) {
            GoodsWish gw;
            if (this.wishes.get(i) instanceof GoodsWish && (gw = (GoodsWish)this.wishes.get(i)).satisfiedBy(goods) && this.completeWish(gw, "satisfied(" + goods + ")")) {
                ret = true;
                continue;
            }
            ++i;
        }
        return ret;
    }

    public boolean completeWish(Unit unit) {
        boolean ret = false;
        int i = 0;
        while (i < this.wishes.size()) {
            WorkerWish ww;
            if (this.wishes.get(i) instanceof WorkerWish && (ww = (WorkerWish)this.wishes.get(i)).satisfiedBy(unit) && this.completeWish(ww, "satisfied (" + unit.getId() + ")")) {
                ret = true;
                continue;
            }
            ++i;
        }
        return ret;
    }

    public List<Wish> getWishes() {
        return new ArrayList<Wish>(this.wishes);
    }

    public List<GoodsWish> getGoodsWishes() {
        ArrayList<GoodsWish> result = new ArrayList<GoodsWish>();
        for (Wish wish : this.wishes) {
            if (!(wish instanceof GoodsWish)) continue;
            result.add((GoodsWish)wish);
        }
        return result;
    }

    public List<WorkerWish> getWorkerWishes() {
        ArrayList<WorkerWish> result = new ArrayList<WorkerWish>();
        for (Wish wish : this.wishes) {
            if (!(wish instanceof WorkerWish)) continue;
            result.add((WorkerWish)wish);
        }
        return result;
    }

    public void requireGoodsWish(GoodsType type, int amount, int value) {
        GoodsWish gw = null;
        for (Wish w : this.wishes) {
            if (!(w instanceof GoodsWish) || ((GoodsWish)w).getGoodsType() != type) continue;
            gw = (GoodsWish)w;
            break;
        }
        if (gw != null) {
            gw.setGoodsAmount(amount);
            gw.setValue(value);
        } else {
            gw = new GoodsWish(this.getAIMain(), this.colony, value, amount, type);
            this.wishes.add(gw);
            logger.finest(this.colony.getName() + " makes new goods wish: " + gw);
        }
    }

    public void requireWorkerWish(UnitType type, boolean expertNeeded, int value) {
        WorkerWish ww = null;
        for (Wish w : this.wishes) {
            if (!(w instanceof WorkerWish) || ((WorkerWish)w).getUnitType() != type) continue;
            ww = (WorkerWish)w;
            break;
        }
        if (ww != null) {
            ww.update(type, expertNeeded, value);
        } else {
            ww = new WorkerWish(this.getAIMain(), this.colony, value, type, expertNeeded);
            this.wishes.add(ww);
            logger.finest(this.colony.getName() + " makes new worker wish: " + ww);
        }
    }

    private void updateWishes() {
        this.updateWorkerWishes();
        this.updateGoodsWishes();
        Collections.sort(this.wishes);
    }

    private void updateWorkerWishes() {
        UnitType bestDefender;
        GoodsType goods;
        Specification spec = this.getSpecification();
        int baseValue = 25;
        int priorityMax = 50;
        int priorityDecay = 5;
        int multipleBonus = 5;
        int multipleMax = 5;
        ArrayList<GoodsType> producing = new ArrayList<GoodsType>();
        for (WorkLocation wl : this.colony.getAvailableWorkLocations()) {
            for (Unit u : wl.getUnitList()) {
                GoodsType work = u.getWorkType();
                if (work == null || producing.contains(work = work.getStoredAs())) continue;
                producing.add(work);
            }
        }
        Collections.sort(producing, new Comparator<GoodsType>(){

            @Override
            public int compare(GoodsType g1, GoodsType g2) {
                return AIColony.this.colony.getAdjustedNetProductionOf(g1) - AIColony.this.colony.getAdjustedNetProductionOf(g2);
            }
        });
        TypeCountMap<UnitType> experts = new TypeCountMap<UnitType>();
        for (Unit unit : this.colony.getUnitList()) {
            goods = unit.getWorkType();
            UnitType expert = goods == null || goods == unit.getType().getExpertProduction() ? null : spec.getExpertForProducing(goods);
            if (expert == null) continue;
            experts.incrementCount(expert, 1);
        }
        for (UnitType expert : experts.keySet()) {
            goods = expert.getExpertProduction();
            int value = 25 + Math.max(0, 50 - 5 * producing.indexOf(goods)) + Math.min(5, experts.getCount(expert) - 1) * 5;
            this.requireWorkerWish(expert, true, value);
        }
        if (experts.isEmpty() && this.colony.governmentChange(this.colony.getWorkLocationUnitCount() + 1) >= 0) {
            UnitType expert;
            boolean needFood = this.colony.getFoodProduction() <= this.colony.getFoodConsumption() + this.colony.getOwner().getMaximumFoodConsumption();
            expert = spec.getDefaultUnitType();
            for (WorkLocationPlan plan : needFood ? this.colonyPlan.getFoodPlans() : this.colonyPlan.getWorkPlans()) {
                WorkLocation location = plan.getWorkLocation();
                if (!location.canBeWorked()) continue;
                expert = spec.getExpertForProducing(plan.getGoodsType());
                break;
            }
            this.requireWorkerWish(expert, false, 50);
        }
        if (this.isBadlyDefended() && (bestDefender = this.colony.getBestDefenderType()) != null) {
            this.requireWorkerWish(bestDefender, true, 100);
        }
    }

    private void updateGoodsWishes() {
        Specification spec = this.getSpecification();
        int goodsWishValue = 50;
        TypeCountMap<GoodsType> required = new TypeCountMap<GoodsType>();
        if (this.colony.getCurrentlyBuilding() != null) {
            for (AbstractGoods abstractGoods : this.colony.getCurrentlyBuilding().getRequiredGoods()) {
                if (this.colony.getAdjustedNetProductionOf(abstractGoods.getType()) > 0) continue;
                required.incrementCount(abstractGoods.getType(), abstractGoods.getAmount());
            }
        }
        for (TileImprovementPlan tileImprovementPlan : this.tileImprovementPlans) {
            for (AbstractGoods ag : tileImprovementPlan.getType().getExpendedEquipmentType().getRequiredGoods()) {
                required.incrementCount(ag.getType(), ag.getAmount());
            }
        }
        for (WorkLocation workLocation : this.colony.getCurrentWorkLocations()) {
            if (!(workLocation instanceof Building)) continue;
            Building building = (Building)workLocation;
            GoodsType inputType = building.getGoodsInputType();
            ProductionInfo info = this.colony.getProductionInfo(building);
            if (inputType == null || info == null || info.hasMaximumProduction()) continue;
            required.incrementCount(inputType, 100);
        }
        for (GoodsType goodsType : spec.getGoodsTypeList()) {
            if (!goodsType.isBreedable() || this.colony.getGoodsCount(goodsType) >= goodsType.getBreedingNumber()) continue;
            required.incrementCount(goodsType, goodsType.getBreedingNumber());
        }
        if (this.isBadlyDefended()) {
            block5: for (EquipmentType equipmentType : spec.getEquipmentTypeList()) {
                if (!equipmentType.isMilitaryEquipment()) continue;
                for (Unit unit : this.colony.getTile().getUnitList()) {
                    if (!unit.canBeEquippedWith(equipmentType)) continue;
                    for (AbstractGoods ag : equipmentType.getRequiredGoods()) {
                        required.incrementCount(ag.getType(), ag.getAmount());
                    }
                    continue block5;
                }
            }
        }
        int i = 0;
        while (i < this.wishes.size()) {
            GoodsWish goodsWish;
            GoodsType t;
            if (this.wishes.get(i) instanceof GoodsWish && required.getCount(t = (goodsWish = (GoodsWish)this.wishes.get(i)).getGoodsType()) < this.colony.getGoodsCount(t)) {
                this.completeWish(goodsWish, "redundant");
                continue;
            }
            ++i;
        }
        Iterator iterator = required.keySet().iterator();
        while (iterator.hasNext()) {
            int amount;
            GoodsType type;
            GoodsType requiredType;
            for (requiredType = type = (GoodsType)iterator.next(); requiredType != null && !requiredType.isStorable(); requiredType = requiredType.getRawMaterial()) {
            }
            if (requiredType == null || (amount = Math.min(this.colony.getWarehouseCapacity(), required.getCount(type) - this.colony.getGoodsCount(requiredType))) <= 0) continue;
            int value = goodsWishValue;
            if (this.colonyCouldProduce(requiredType)) {
                value /= 10;
            }
            this.requireGoodsWish(requiredType, amount, value);
        }
    }

    private boolean colonyCouldProduce(GoodsType goodsType) {
        if (goodsType.isBreedable()) {
            return this.colony.getGoodsCount(goodsType) >= goodsType.getBreedingNumber();
        }
        if (goodsType.isFarmed()) {
            for (ColonyTile colonyTile : this.colony.getColonyTiles()) {
                if (colonyTile.getWorkTile().potential(goodsType, null) <= 0) continue;
                return true;
            }
        } else if (!this.colony.getBuildingsForProducing(goodsType).isEmpty()) {
            return goodsType.getRawMaterial() == null ? true : this.colonyCouldProduce(goodsType.getRawMaterial());
        }
        return false;
    }

    public List<TileImprovementPlan> getTileImprovementPlans() {
        return new ArrayList<TileImprovementPlan>(this.tileImprovementPlans);
    }

    public boolean removeTileImprovementPlan(TileImprovementPlan plan) {
        return this.tileImprovementPlans.remove(plan);
    }

    private TileImprovementPlan getPlanFor(Tile tile, List<TileImprovementPlan> plans) {
        for (TileImprovementPlan tip : plans) {
            if (tip.getTarget() != tile) continue;
            return tip;
        }
        return null;
    }

    public void createTileImprovementPlans() {
        ArrayList<TileImprovementPlan> newPlans = new ArrayList<TileImprovementPlan>();
        for (WorkLocation wl : this.colony.getAvailableWorkLocations()) {
            ColonyTile colonyTile;
            Tile workTile;
            if (!(wl instanceof ColonyTile) || (workTile = (colonyTile = (ColonyTile)wl).getWorkTile()).getOwningSettlement() != this.colony || this.getPlanFor(workTile, newPlans) != null) continue;
            GoodsType goodsType = null;
            if (colonyTile.isColonyCenterTile()) {
                for (AbstractGoods ag : colonyTile.getProduction()) {
                    if (!ag.getType().isFoodType()) continue;
                    goodsType = ag.getType();
                    break;
                }
            } else {
                if (colonyTile.isEmpty()) continue;
                goodsType = colonyTile.getUnitList().get(0).getWorkType();
            }
            if (goodsType == null) continue;
            TileImprovementPlan plan = this.getPlanFor(workTile, this.tileImprovementPlans);
            if (plan == null) {
                TileImprovementType type = TileImprovementPlan.getBestTileImprovementType(workTile, goodsType);
                if (type != null) {
                    plan = new TileImprovementPlan(this.getAIMain(), workTile, type, type.getImprovementValue(workTile, goodsType));
                }
            } else if (!plan.update(goodsType)) {
                plan = null;
            }
            if (plan == null) continue;
            TileType change = plan.getType().getChange(workTile.getType());
            if (change != null && !change.isForested()) {
                int forest = 0;
                for (WorkLocation f : this.colony.getAvailableWorkLocations()) {
                    if (!(f instanceof ColonyTile) || !((ColonyTile)f).getWorkTile().isForested()) continue;
                    ++forest;
                }
                if (forest <= 1) continue;
            }
            newPlans.add(plan);
            logger.info(this.colony.getName() + " new tile improvement plan: " + plan);
        }
        this.tileImprovementPlans.clear();
        this.tileImprovementPlans.addAll(newPlans);
        Collections.sort(this.tileImprovementPlans);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        logger.finest("Property change REARRANGE_WORKERS fired.");
        this.requestRearrange();
    }

    public void requestRearrange() {
        this.rearrangeTurn = new Turn(0);
    }

    @Override
    public boolean checkIntegrity() {
        return super.checkIntegrity() && this.colony != null && !this.colony.isDisposed();
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(AIColony.getXMLElementTagName());
        super.writeAttributes(out);
        for (AIGoods ag : this.aiGoods) {
            if (!ag.checkIntegrity()) continue;
            out.writeStartElement(AIGoods.getXMLElementTagName() + LIST_ELEMENT);
            out.writeAttribute("ID", ag.getId());
            out.writeEndElement();
        }
        for (Wish w : this.wishes) {
            String tag;
            String string = w instanceof GoodsWish ? GoodsWish.getXMLElementTagName() : (tag = w instanceof WorkerWish ? WorkerWish.getXMLElementTagName() : null);
            if (!w.checkIntegrity() || !w.shouldBeStored() || tag == null) continue;
            out.writeStartElement(tag + LIST_ELEMENT);
            out.writeAttribute("ID", w.getId());
            out.writeEndElement();
        }
        for (TileImprovementPlan tip : this.tileImprovementPlans) {
            if (!tip.checkIntegrity()) continue;
            out.writeStartElement(TileImprovementPlan.getXMLElementTagName() + LIST_ELEMENT);
            out.writeAttribute("ID", tip.getId());
            out.writeEndElement();
        }
        out.writeEndElement();
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        String str;
        AIMain aiMain = this.getAIMain();
        Game game = aiMain.getGame();
        this.colony = game.getFreeColGameObject(str = in.getAttributeValue(null, "ID"), Colony.class);
        if (this.colony == null) {
            throw new IllegalStateException("Not a Colony: " + str);
        }
        this.aiGoods.clear();
        this.tileImprovementPlans.clear();
        this.wishes.clear();
        this.colonyPlan = new ColonyPlan(aiMain, this.colony);
    }

    @Override
    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        AIMain aiMain = this.getAIMain();
        String tag = in.getLocalName();
        if (tag.equals(AIGoods.getXMLElementTagName() + LIST_ELEMENT)) {
            String str = in.getAttributeValue(null, "ID");
            AIGoods ag = (AIGoods)aiMain.getAIObject(str);
            if (ag == null) {
                ag = new AIGoods(aiMain, str);
            }
            this.aiGoods.add(ag);
        } else if (tag.equals(TileImprovementPlan.getXMLElementTagName() + LIST_ELEMENT) || in.getLocalName().equals("tileimprovementplanListElement")) {
            String str = in.getAttributeValue(null, "ID");
            TileImprovementPlan ti = (TileImprovementPlan)aiMain.getAIObject(str);
            if (ti == null) {
                ti = new TileImprovementPlan(aiMain, str);
            }
            this.tileImprovementPlans.add(ti);
        } else if (tag.equals(GoodsWish.getXMLElementTagName() + LIST_ELEMENT) || in.getLocalName().equals(GoodsWish.getXMLElementTagName() + "Wish" + LIST_ELEMENT)) {
            String str = in.getAttributeValue(null, "ID");
            GoodsWish gw = (GoodsWish)aiMain.getAIObject(str);
            if (gw == null) {
                gw = new GoodsWish(aiMain, str);
            }
            this.wishes.add(gw);
        } else if (tag.equals(WorkerWish.getXMLElementTagName() + LIST_ELEMENT) || in.getLocalName().equals(WorkerWish.getXMLElementTagName() + "Wish" + LIST_ELEMENT)) {
            String str = in.getAttributeValue(null, "ID");
            Wish ww = (Wish)aiMain.getAIObject(str);
            if (ww == null) {
                ww = new WorkerWish(aiMain, str);
            }
            this.wishes.add(ww);
        } else {
            logger.warning("Unknown tag name: " + in.getLocalName());
        }
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "aiColony";
    }
}

