/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.resources;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.common.resources.Resource;

public class ImageResource
extends Resource {
    private static final Logger logger = Logger.getLogger(ImageResource.class.getName());
    private Map<Dimension, Image> grayscaleImages = new HashMap<Dimension, Image>();
    private Map<Dimension, Image> scaledImages = new HashMap<Dimension, Image>();
    private Image image = null;
    private final Object loadingLock = new Object();
    private static final Component _c = new Component(){};

    public ImageResource(URI resourceLocator) {
        super(resourceLocator);
    }

    public ImageResource(Image image) {
        super(null);
        this.image = image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preload() {
        Object object = this.loadingLock;
        synchronized (object) {
            if (this.image == null) {
                MediaTracker mt = new MediaTracker(_c);
                try {
                    URL url = this.getResourceLocator().toURL();
                    InputStream is = url.openStream();
                    is.close();
                    Image im = Toolkit.getDefaultToolkit().createImage(url);
                    mt.addImage(im, 0);
                    mt.waitForID(0);
                    if (mt.statusID(0, false) == 8) {
                        this.image = im;
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Failed to load image from: " + this.getResourceLocator(), e);
                }
            }
        }
    }

    public Image getImage() {
        if (this.image == null) {
            this.preload();
        }
        return this.image;
    }

    public Image getImage(double scale) {
        Image im = this.getImage();
        return im == null ? null : this.getImage(new Dimension((int)((double)im.getWidth(null) * scale), (int)((double)im.getHeight(null) * scale)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(Dimension d) {
        Image im = this.getImage();
        if (im == null || im.getWidth(null) == d.width && im.getHeight(null) == d.height) {
            return im;
        }
        Object object = this.loadingLock;
        synchronized (object) {
            Image cached = this.scaledImages.get(d);
            if (cached != null) {
                return cached;
            }
            MediaTracker mt = new MediaTracker(_c);
            try {
                Image scaled = im.getScaledInstance(d.width, d.height, 8);
                mt.addImage(scaled, 0, d.width, d.height);
                mt.waitForID(0);
                int result = mt.statusID(0, false);
                if (result == 8) {
                    this.scaledImages.put(d, scaled);
                } else {
                    logger.warning("Scaling image: " + this.getResourceLocator() + " => " + result);
                }
                return scaled;
            }
            catch (Exception e) {
                logger.warning("Failed to scale image: " + this.getResourceLocator() + "\r\nProblem: " + e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getGrayscaleImage(Dimension d) {
        Image im = this.getImage(d);
        if (im == null) {
            return null;
        }
        Image cachedGrayscaleImage = this.grayscaleImages.get(d);
        if (cachedGrayscaleImage != null) {
            return cachedGrayscaleImage;
        }
        Object object = this.loadingLock;
        synchronized (object) {
            Image cached = this.grayscaleImages.get(d);
            if (cached != null) {
                return cached;
            }
            int width = im.getWidth(null);
            int height = im.getHeight(null);
            ColorConvertOp filter = new ColorConvertOp(ColorSpace.getInstance(1003), null);
            BufferedImage srcImage = new BufferedImage(width, height, 2);
            srcImage.createGraphics().drawImage(im, 0, 0, null);
            BufferedImage grayscaleImage = filter.filter(srcImage, null);
            this.grayscaleImages.put(d, grayscaleImage);
            return grayscaleImage;
        }
    }

    public Image getGrayscaleImage(double scale) {
        Image im = this.getImage();
        if (im == null) {
            return im;
        }
        return this.getGrayscaleImage(new Dimension((int)((double)im.getWidth(null) * scale), (int)((double)im.getHeight(null) * scale)));
    }

    public int getCount() {
        return this.grayscaleImages.size() + this.scaledImages.size();
    }
}

