/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DiplomacyMessage
extends DOMMessage {
    private Unit unit;
    private Settlement settlement;
    private DiplomaticTrade agreement;

    public DiplomacyMessage(Unit unit, Settlement settlement, DiplomaticTrade agreement) {
        this.unit = unit;
        this.settlement = settlement;
        this.agreement = agreement;
    }

    public DiplomacyMessage(Game game, Element element) {
        String settlementId = element.getAttribute("settlement");
        this.settlement = game.getFreeColGameObject(settlementId, Settlement.class);
        NodeList nodes = element.getChildNodes();
        DiplomaticTrade diplomaticTrade = this.agreement = nodes.getLength() < 1 ? null : new DiplomaticTrade(game, (Element)nodes.item(0));
        if (nodes.getLength() < 2) {
            this.unit = null;
        } else {
            Element ue = (Element)nodes.item(1);
            String unitId = ue.getAttribute("ID");
            this.unit = game.getFreeColGameObject(unitId, Unit.class);
            if (this.unit == null) {
                this.unit = new Unit(game, ue);
            }
        }
    }

    public Unit getUnit() {
        return this.unit;
    }

    public Settlement getSettlement() {
        return this.settlement;
    }

    public DiplomaticTrade getAgreement() {
        return this.agreement;
    }

    public void setAgreement(DiplomaticTrade agreement) {
        this.agreement = agreement;
    }

    public Element handle(FreeColServer server, Connection connection) {
        ServerPlayer serverPlayer = server.getPlayer(connection);
        Unit unit = this.getUnit();
        if (unit == null) {
            return DOMMessage.clientError("Missing unit in diplomacy.");
        }
        if (unit.getTile() == null) {
            return DOMMessage.clientError("Unit is not on the map: " + unit.getId());
        }
        if (unit.getOwner() != serverPlayer) {
            return DOMMessage.clientError("Player does not own unit: " + unit.getId());
        }
        Settlement settlement = this.getSettlement();
        if (settlement == null) {
            return DOMMessage.clientError("Missing settlement in diplomacy.");
        }
        if (!(settlement instanceof Colony)) {
            return DOMMessage.clientError("Settlement is not a colony: " + settlement.getId());
        }
        if (!unit.getTile().isAdjacent(settlement.getTile())) {
            return DOMMessage.clientError("Unit " + unit.getId() + " is not adjacent to settlement " + settlement.getId());
        }
        Player otherPlayer = settlement.getOwner();
        if (this.agreement == null) {
            return DOMMessage.clientError("Null diplomatic agreement.");
        }
        Player senderPlayer = this.agreement.getSender();
        Player recipientPlayer = this.agreement.getRecipient();
        Player refPlayer = serverPlayer.getREFPlayer();
        if (senderPlayer == null) {
            return DOMMessage.clientError("Null sender in agreement.");
        }
        if (recipientPlayer == null) {
            return DOMMessage.clientError("Null recipient in agreement.");
        }
        if (senderPlayer != serverPlayer) {
            return DOMMessage.clientError("Sender is not the unit owner: " + senderPlayer.getId());
        }
        if (recipientPlayer != otherPlayer) {
            return DOMMessage.clientError("Recipient is not the settlement owner: " + recipientPlayer.getId());
        }
        if (senderPlayer == refPlayer || recipientPlayer == refPlayer) {
            return DOMMessage.clientError("The REF does not negotiate: " + refPlayer.getId());
        }
        return server.getInGameController().diplomaticTrade(serverPlayer, unit, settlement, this.agreement);
    }

    public Element toXMLElement() {
        Element result = DiplomacyMessage.createMessage(DiplomacyMessage.getXMLElementTagName(), "settlement", this.settlement.getId());
        Document doc = result.getOwnerDocument();
        result.appendChild(this.agreement.toXMLElement(null, doc));
        result.appendChild(this.unit.toXMLElement(null, doc));
        return result;
    }

    public static String getXMLElementTagName() {
        return "diplomacy";
    }
}

