/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitWas
implements Comparable<UnitWas> {
    private static final Logger logger = Logger.getLogger(UnitWas.class.getName());
    private Unit unit;
    private UnitType type;
    private Unit.Role role;
    private Location loc;
    private GoodsType work;
    private int workAmount;
    private Colony colony;
    private TypeCountMap<EquipmentType> equipment;

    public UnitWas(Unit unit) {
        this.unit = unit;
        this.type = unit.getType();
        this.role = unit.getRole();
        this.loc = unit.getLocation();
        this.work = unit.getWorkType();
        this.workAmount = this.getAmount(this.loc, this.work);
        this.colony = unit.getColony();
        this.equipment = new TypeCountMap();
        this.equipment.add(unit.getEquipment());
        if (unit.getGoodsContainer() != null) {
            unit.getGoodsContainer().saveState();
        }
    }

    @Override
    public int compareTo(UnitWas uw) {
        int cmp = ((UnitLocation)uw.loc).getUnitCapacity() - ((UnitLocation)this.loc).getUnitCapacity();
        if (cmp != 0) {
            return cmp;
        }
        return this.equipment.keySet().size() - uw.equipment.keySet().size();
    }

    public boolean revert() {
        if (this.unit.isDisposed() || this.unit.getType() != this.type) {
            return false;
        }
        if (this.unit.getLocation() != this.loc) {
            this.unit.setLocation(this.loc);
        }
        if (this.unit.getWorkType() != this.work) {
            this.unit.setWorkType(this.work);
        }
        if (this.unit.getRole() != this.role) {
            int count;
            if (this.colony == null || this.unit.getColony() != this.colony) {
                return false;
            }
            HashSet<EquipmentType> eq = new HashSet<EquipmentType>();
            TypeCountMap<EquipmentType> unitEquipment = this.unit.getEquipment();
            eq.addAll(this.equipment.keySet());
            eq.addAll(unitEquipment.keySet());
            for (EquipmentType et : eq) {
                count = this.equipment.getCount(et) - unitEquipment.getCount(et);
                if (count >= 0) continue;
                this.unit.changeEquipment(et, count);
                this.colony.addEquipmentGoods(et, -count);
            }
            for (EquipmentType et : eq) {
                count = this.equipment.getCount(et) - unitEquipment.getCount(et);
                if (count <= 0 || !this.colony.canProvideEquipment(et) || !this.unit.canBeEquippedWith(et)) continue;
                this.unit.changeEquipment(et, count);
                this.colony.addEquipmentGoods(et, -count);
            }
        }
        return this.unit.getRole() == this.role;
    }

    public static boolean revertAll(List<UnitWas> was) {
        UnitWas w;
        Collections.sort(was);
        ArrayList<UnitWas> retry = new ArrayList<UnitWas>();
        while (!was.isEmpty()) {
            w = was.remove(0);
            if (w.revert()) continue;
            retry.add(w);
        }
        Collections.sort(retry);
        while (!retry.isEmpty()) {
            w = (UnitWas)retry.remove(0);
            if (w.revert()) continue;
            was.add(w);
        }
        return was.isEmpty();
    }

    public void fireChanges() {
        UnitType newType = null;
        Unit.Role newRole = null;
        Location newLoc = null;
        GoodsType newWork = null;
        int newWorkAmount = 0;
        TypeCountMap<EquipmentType> newEquipment = null;
        if (!this.unit.isDisposed()) {
            newLoc = this.unit.getLocation();
            if (this.colony != null) {
                newType = this.unit.getType();
                newRole = this.unit.getRole();
                newWork = this.unit.getWorkType();
                newWorkAmount = newWork == null ? 0 : this.getAmount(newLoc, newWork);
                newEquipment = this.unit.getEquipment();
            }
        }
        FreeColGameObject oldFcgo = (FreeColGameObject)((Object)this.loc);
        FreeColGameObject newFcgo = (FreeColGameObject)((Object)newLoc);
        if (this.loc != newLoc) {
            oldFcgo.firePropertyChange(this.change(oldFcgo), this.unit, null);
            if (newLoc != null) {
                newFcgo.firePropertyChange(this.change(newFcgo), null, this.unit);
            }
        }
        if (this.colony != null) {
            String pc;
            if (this.type != newType && newType != null) {
                pc = Colony.ColonyChangeEvent.UNIT_TYPE_CHANGE.toString();
                this.colony.firePropertyChange(pc, this.type, newType);
            } else if (this.role != newRole && newRole != null) {
                pc = "TILE_UNIT_CHANGE".toString();
                this.colony.firePropertyChange(pc, this.role.toString(), newRole.toString());
            }
            if (this.work != newWork) {
                if (this.work != null && oldFcgo != null && this.workAmount != 0) {
                    oldFcgo.firePropertyChange(this.work.getId(), this.workAmount, 0);
                }
                if (newWork != null && newFcgo != null && newWorkAmount != 0) {
                    newFcgo.firePropertyChange(newWork.getId(), 0, newWorkAmount);
                }
            } else if (this.workAmount != newWorkAmount) {
                newFcgo.firePropertyChange(newWork.getId(), this.workAmount, newWorkAmount);
            }
        }
        if (newEquipment != null) {
            HashSet<EquipmentType> keys = new HashSet<EquipmentType>();
            keys.addAll(this.equipment.keySet());
            keys.addAll(newEquipment.keySet());
            for (EquipmentType e : keys) {
                int cNew;
                int cOld = this.equipment.getCount(e);
                if (cOld == (cNew = newEquipment.getCount(e))) continue;
                this.unit.firePropertyChange("EQUIPMENT_CHANGE", cOld, cNew);
            }
        }
        if (this.unit.getGoodsContainer() != null) {
            this.unit.getGoodsContainer().fireChanges();
        }
    }

    private String change(FreeColGameObject fcgo) {
        return fcgo instanceof Tile ? "TILE_UNIT_CHANGE" : (fcgo instanceof Europe ? "unitChange" : (fcgo instanceof ColonyTile ? "UNIT_CHANGE" : (fcgo instanceof Building ? "UNIT_CHANGE" : (fcgo instanceof Unit ? "CARGO_CHANGE" : null))));
    }

    private int getAmount(Location location, GoodsType goodsType) {
        if (goodsType != null && location instanceof WorkLocation) {
            ProductionInfo info = ((WorkLocation)location).getProductionInfo();
            for (AbstractGoods ag : info.getProduction()) {
                if (ag.getType() != goodsType) continue;
                return ag.getAmount();
            }
        }
        return 0;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public Location getLocation() {
        return this.loc;
    }

    public GoodsType getWorkType() {
        return this.work;
    }

    public String toString() {
        Tile tile = this.colony.getTile();
        String eqStr = "/";
        for (EquipmentType e : this.equipment.keySet()) {
            eqStr = eqStr + e.toString().substring(16, 17);
        }
        String locStr = this.loc == null ? "" : (this.loc instanceof Building ? Utils.lastPart(((Building)this.loc).getType().toString(), ".") : (this.loc instanceof ColonyTile ? tile.getDirection(((ColonyTile)this.loc).getWorkTile()).toString() : (this.loc instanceof Tile ? this.loc.getId() + eqStr : this.loc.getId())));
        Location newLoc = this.unit.getLocation();
        String newEqStr = "/";
        for (EquipmentType e : this.unit.getEquipment().keySet()) {
            newEqStr = newEqStr + e.toString().substring(16, 17);
        }
        String newLocStr = newLoc == null ? "" : (newLoc instanceof Building ? Utils.lastPart(((Building)newLoc).getType().toString(), ".") : (newLoc instanceof ColonyTile ? tile.getDirection(((ColonyTile)newLoc).getWorkTile()).toString() : (newLoc instanceof Tile ? newLoc.getId() + newEqStr : newLoc.getId())));
        GoodsType newWork = this.unit.getWorkType();
        int newWorkAmount = newWork == null ? 0 : this.getAmount(newLoc, newWork);
        return String.format("%-30s %-25s -> %-25s", this.unit.getId() + ":" + Utils.lastPart(this.unit.getType().toString(), "."), locStr + (this.work == null || this.workAmount <= 0 ? "" : "(" + Integer.toString(this.workAmount) + " " + Utils.lastPart(this.work.toString(), ".") + ")"), newLocStr + (newWork == null || newWorkAmount <= 0 ? "" : "(" + Integer.toString(newWorkAmount) + " " + Utils.lastPart(newWork.toString(), ".") + ")")).trim();
    }
}

