/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.TradeItem;

public class StanceTradeItem
extends TradeItem {
    private Player.Stance stance;

    public StanceTradeItem(Game game, Player source, Player destination, Player.Stance stance) {
        super(game, "tradeItem.stance", source, destination);
        this.stance = stance;
    }

    public StanceTradeItem(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public boolean isValid() {
        return this.stance != null;
    }

    public boolean isUnique() {
        return true;
    }

    public Player.Stance getStance() {
        return this.stance;
    }

    public void setStance(Player.Stance stance) {
        this.stance = stance;
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, StanceTradeItem.getXMLElementTagName());
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("stance", this.stance.toString());
    }

    public void readFromXML(XMLStreamReader in) throws XMLStreamException {
        super.readFromXML(in);
        this.stance = Enum.valueOf(Player.Stance.class, in.getAttributeValue(null, "stance"));
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "stanceTradeItem";
    }
}

