/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.RandomRange;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Unit;

public class SettlementType
extends FreeColGameObjectType {
    private boolean capital = false;
    private int visibleRadius = 2;
    private int claimableRadius = 1;
    private int extraClaimableRadius = 2;
    private int wanderingRadius = 4;
    private List<RandomRange> plunder = new ArrayList<RandomRange>();
    private List<RandomRange> gifts = new ArrayList<RandomRange>();
    private int minimumSize = 3;
    private int maximumSize = 10;
    private int minimumGrowth = 1;
    private int maximumGrowth = 10;
    private int tradeBonus = 1;
    private int convertThreshold = 100;

    public SettlementType(String id, Specification specification) {
        super(id, specification);
    }

    public final boolean isCapital() {
        return this.capital;
    }

    public final void setCapital(boolean newCapital) {
        this.capital = newCapital;
    }

    public final int getMinimumSize() {
        return this.minimumSize;
    }

    public final void setMinimumSize(int newMinimumSize) {
        this.minimumSize = newMinimumSize;
    }

    public final int getMaximumSize() {
        return this.maximumSize;
    }

    public final void setMaximumSize(int newMaximumSize) {
        this.maximumSize = newMaximumSize;
    }

    public final int getVisibleRadius() {
        return this.visibleRadius;
    }

    public final void setVisibleRadius(int newVisibleRadius) {
        this.visibleRadius = newVisibleRadius;
    }

    public final int getClaimableRadius() {
        return this.claimableRadius;
    }

    public final int getExtraClaimableRadius() {
        return this.extraClaimableRadius;
    }

    public final void setClaimableRadius(int newClaimableRadius) {
        this.claimableRadius = newClaimableRadius;
    }

    public final int getWanderingRadius() {
        return this.wanderingRadius;
    }

    public final void setWanderingRadius(int newWanderingRadius) {
        this.wanderingRadius = newWanderingRadius;
    }

    public final int getMinimumGrowth() {
        return this.minimumGrowth;
    }

    public final int getMaximumGrowth() {
        return this.maximumGrowth;
    }

    public final int getTradeBonus() {
        return this.tradeBonus;
    }

    public final RandomRange getPlunderRange(Unit unit) {
        for (RandomRange range : this.plunder) {
            List<Scope> scopes = range.getScopes();
            if (scopes.isEmpty()) {
                return range;
            }
            for (Scope scope : scopes) {
                if (!scope.appliesTo(unit)) continue;
                return range;
            }
        }
        return null;
    }

    public final void setPlunder(RandomRange newPlunder) {
        this.plunder.add(newPlunder);
    }

    public final RandomRange getGifts(Unit unit) {
        for (RandomRange range : this.gifts) {
            List<Scope> scopes = range.getScopes();
            if (scopes.isEmpty()) {
                return range;
            }
            for (Scope scope : scopes) {
                if (!scope.appliesTo(unit)) continue;
                return range;
            }
        }
        return null;
    }

    public final void setGifts(RandomRange newGifts) {
        this.gifts.add(newGifts);
    }

    public int getWarehouseCapacity() {
        return 100 * this.getClaimableRadius();
    }

    public int getConvertThreshold() {
        return this.convertThreshold;
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXMLImpl(out, SettlementType.getXMLElementTagName());
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("capital", Boolean.toString(this.capital));
        out.writeAttribute("minimumSize", Integer.toString(this.minimumSize));
        out.writeAttribute("maximumSize", Integer.toString(this.maximumSize));
        out.writeAttribute("visibleRadius", Integer.toString(this.visibleRadius));
        out.writeAttribute("claimableRadius", Integer.toString(this.claimableRadius));
        out.writeAttribute("extraClaimableRadius", Integer.toString(this.extraClaimableRadius));
        out.writeAttribute("wanderingRadius", Integer.toString(this.wanderingRadius));
        out.writeAttribute("minimumGrowth", Integer.toString(this.minimumGrowth));
        out.writeAttribute("maximumGrowth", Integer.toString(this.maximumGrowth));
        out.writeAttribute("tradeBonus", Integer.toString(this.tradeBonus));
        out.writeAttribute("convertThreshold", Integer.toString(this.convertThreshold));
    }

    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
        super.writeChildren(out);
        for (RandomRange range : this.plunder) {
            range.toXML(out, "plunder");
        }
        for (RandomRange range : this.gifts) {
            range.toXML(out, "gifts");
        }
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.capital = this.getAttribute(in, "capital", this.capital);
        this.minimumSize = this.getAttribute(in, "minimumSize", this.minimumSize);
        this.maximumSize = this.getAttribute(in, "maximumSize", this.maximumSize);
        this.visibleRadius = this.getAttribute(in, "visibleRadius", this.visibleRadius);
        this.claimableRadius = this.getAttribute(in, "claimableRadius", this.claimableRadius);
        this.extraClaimableRadius = this.getAttribute(in, "extraClaimableRadius", this.extraClaimableRadius);
        this.wanderingRadius = this.getAttribute(in, "wanderingRadius", this.wanderingRadius);
        this.minimumGrowth = this.getAttribute(in, "minimumGrowth", this.minimumGrowth);
        this.maximumGrowth = this.getAttribute(in, "maximumGrowth", this.maximumGrowth);
        this.tradeBonus = this.getAttribute(in, "tradeBonus", this.tradeBonus);
        this.convertThreshold = this.getAttribute(in, "convertThreshold", this.convertThreshold);
    }

    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        if ("plunder".equals(in.getLocalName())) {
            RandomRange range = new RandomRange();
            range.readFromXML(in);
            this.plunder.add(range);
        } else if ("gifts".equals(in.getLocalName())) {
            RandomRange range = new RandomRange();
            range.readFromXML(in);
            this.gifts.add(range);
        } else {
            super.readChild(in);
        }
    }

    public static String getXMLElementTagName() {
        return "settlementType";
    }
}

