/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.RandomRange;
import net.sf.freecol.common.model.SettlementType;
import net.sf.freecol.common.model.Specification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NationType
extends FreeColGameObjectType {
    private SettlementNumber numberOfSettlements = SettlementNumber.AVERAGE;
    private AggressionLevel aggression = AggressionLevel.AVERAGE;
    private List<SettlementType> settlementTypes = null;
    private static final String AGGRESSION_TAG = "aggression";
    private static final String NUMBER_OF_SETTLEMENTS_TAG = "number-of-settlements";
    private static final String SETTLEMENT_TAG = "settlement";

    public NationType(String id, Specification specification) {
        super(id, specification);
        this.setModifierIndex(Modifier.NATION_PRODUCTION_INDEX);
    }

    public final List<SettlementType> getSettlementTypes() {
        return this.settlementTypes == null ? new ArrayList() : this.settlementTypes;
    }

    public SettlementType getCapitalType() {
        return this.getSettlementType(true);
    }

    public SettlementType getSettlementType(boolean isCapital) {
        for (SettlementType settlementType : this.getSettlementTypes()) {
            if (settlementType.isCapital() != isCapital) continue;
            return settlementType;
        }
        String id = "model.settlement." + this.getId().substring(this.getId().lastIndexOf(".") + 1) + (isCapital ? ".capital" : "");
        SettlementType type = new SettlementType(id, this.getSpecification());
        if (isCapital) {
            type.setCapital(true);
            type.setPlunder(new RandomRange(100, 2, 6, 1500));
            type.setGifts(new RandomRange(100, 2, 6, 200));
        } else {
            type.setPlunder(new RandomRange(50, 2, 6, 1000));
            type.setGifts(new RandomRange(50, 2, 6, 100));
        }
        return type;
    }

    public SettlementType getSettlementType(String id) {
        for (SettlementType settlementType : this.getSettlementTypes()) {
            if (!id.equals(settlementType.getId())) continue;
            return settlementType;
        }
        return null;
    }

    public final SettlementNumber getNumberOfSettlements() {
        return this.numberOfSettlements;
    }

    public final AggressionLevel getAggression() {
        return this.aggression;
    }

    public abstract boolean isEuropean();

    public abstract boolean isIndian();

    public abstract boolean isREF();

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        this.writeAttribute(out, NUMBER_OF_SETTLEMENTS_TAG, this.numberOfSettlements);
        this.writeAttribute(out, AGGRESSION_TAG, this.aggression);
    }

    @Override
    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
        super.writeChildren(out);
        for (SettlementType settlementType : this.getSettlementTypes()) {
            settlementType.toXML(out, SETTLEMENT_TAG);
        }
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        Specification spec = this.getSpecification();
        NationType parent = spec.getType(in, "extends", NationType.class, this);
        this.numberOfSettlements = this.getAttribute(in, NUMBER_OF_SETTLEMENTS_TAG, SettlementNumber.class, parent.numberOfSettlements);
        this.aggression = this.getAttribute(in, AGGRESSION_TAG, AggressionLevel.class, parent.aggression);
    }

    @Override
    protected void readChildren(XMLStreamReader in) throws XMLStreamException {
        if (this.readShouldClearContainers(in)) {
            this.settlementTypes = null;
        }
        Specification spec = this.getSpecification();
        NationType parent = spec.getType(in, "extends", NationType.class, this);
        super.readChildren(in);
        if (parent != this) {
            if (parent.settlementTypes != null) {
                if (this.settlementTypes == null) {
                    this.settlementTypes = new ArrayList<SettlementType>();
                }
                this.settlementTypes.addAll(parent.settlementTypes);
            }
            this.addFeatures(parent);
            if (parent.isAbstractType()) {
                this.getFeatureContainer().replaceSource(parent, this);
            }
        }
    }

    @Override
    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = in.getLocalName();
        if (SETTLEMENT_TAG.equals(tag)) {
            String id = this.getAttribute(in, "id", null);
            SettlementType settlementType = new SettlementType(id, spec);
            settlementType.readFromXML(in);
            if (this.settlementTypes == null) {
                this.settlementTypes = new ArrayList<SettlementType>();
            }
            this.settlementTypes.add(settlementType);
        } else {
            super.readChild(in);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AggressionLevel {
        LOW,
        AVERAGE,
        HIGH;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SettlementNumber {
        LOW,
        AVERAGE,
        HIGH;

    }
}

