/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.RandomChoice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndianNationType
extends NationType {
    private List<RandomChoice<UnitType>> skills = null;
    private List<String> regions = null;
    private static final String PROBABILITY_TAG = "probability";
    private static final String SKILL_TAG = "skill";

    public IndianNationType(String id, Specification specification) {
        super(id, specification);
    }

    @Override
    public boolean isEuropean() {
        return false;
    }

    @Override
    public boolean isIndian() {
        return true;
    }

    @Override
    public boolean isREF() {
        return false;
    }

    public final String getSettlementTypeKey(boolean plural) {
        return this.getSettlementType(false).getId() + (plural ? ".plural" : "");
    }

    public List<String> getRegionNames() {
        return this.regions == null ? new ArrayList() : this.regions;
    }

    public List<RandomChoice<UnitType>> getSkills() {
        return this.skills == null ? new ArrayList() : this.skills;
    }

    public List<RandomChoice<UnitType>> generateSkillsForTile(Tile tile) {
        List<RandomChoice<UnitType>> skills = this.getSkills();
        HashMap<GoodsType, Integer> scale = new HashMap<GoodsType, Integer>();
        for (RandomChoice<UnitType> skill : skills) {
            scale.put(skill.getObject().getExpertProduction(), 1);
        }
        for (Tile t : tile.getSurroundingTiles(1)) {
            for (GoodsType goodsType : scale.keySet()) {
                scale.put(goodsType, (Integer)scale.get(goodsType) + t.potential(goodsType, null));
            }
        }
        ArrayList<RandomChoice<UnitType>> scaledSkills = new ArrayList<RandomChoice<UnitType>>();
        for (RandomChoice<UnitType> skill : skills) {
            UnitType unitType = skill.getObject();
            int scaleValue = (Integer)scale.get(unitType.getExpertProduction());
            scaledSkills.add(new RandomChoice<UnitType>(unitType, skill.getProbability() * scaleValue));
        }
        return scaledSkills;
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, IndianNationType.getXMLElementTagName());
    }

    @Override
    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
        super.writeChildren(out);
        for (RandomChoice<UnitType> choice : this.getSkills()) {
            out.writeStartElement(SKILL_TAG);
            this.writeAttribute(out, "id", choice.getObject());
            this.writeAttribute(out, PROBABILITY_TAG, choice.getProbability());
            out.writeEndElement();
        }
        for (String region : this.getRegionNames()) {
            out.writeStartElement(Region.getXMLElementTagName());
            this.writeAttribute(out, "id", region);
            out.writeEndElement();
        }
    }

    @Override
    protected void readChildren(XMLStreamReader in) throws XMLStreamException {
        if (this.readShouldClearContainers(in)) {
            this.skills = null;
            this.regions = null;
        }
        Specification spec = this.getSpecification();
        IndianNationType parent = spec.getType(in, "extends", IndianNationType.class, this);
        super.readChildren(in);
        if (parent != this) {
            if (parent.skills != null && !parent.skills.isEmpty()) {
                if (this.skills == null) {
                    this.skills = new ArrayList<RandomChoice<UnitType>>();
                }
                this.skills.addAll(parent.skills);
            }
            if (parent.regions != null && !parent.regions.isEmpty()) {
                if (this.regions == null) {
                    this.regions = new ArrayList<String>();
                }
                this.regions.addAll(parent.regions);
            }
        }
        if (this.skills != null) {
            Collections.sort(this.skills, new Comparator<RandomChoice<UnitType>>(){

                @Override
                public int compare(RandomChoice<UnitType> c1, RandomChoice<UnitType> c2) {
                    return c2.getProbability() - c1.getProbability();
                }
            });
        }
    }

    @Override
    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = in.getLocalName();
        if (SKILL_TAG.equals(tag)) {
            UnitType unitType = spec.getType(in, "id", UnitType.class, null);
            int probability = this.getAttribute(in, PROBABILITY_TAG, 0);
            if (unitType != null && probability > 0) {
                if (this.skills == null) {
                    this.skills = new ArrayList<RandomChoice<UnitType>>();
                }
                this.skills.add(new RandomChoice<UnitType>(unitType, probability));
            }
            in.nextTag();
        } else if (Region.getXMLElementTagName().equals(tag)) {
            String id = this.getAttribute(in, "id", null);
            if (id != null) {
                if (this.regions == null) {
                    this.regions = new ArrayList<String>();
                }
                this.regions.add(id);
            }
            in.nextTag();
        } else {
            super.readChild(in);
        }
    }

    public static String getXMLElementTagName() {
        return "indian-nation-type";
    }
}

