/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.logging;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.logging.TextFormatter;
import net.sf.freecol.common.networking.DOMMessage;

public final class DefaultHandler
extends Handler {
    private FileWriter fileWriter;
    private final boolean consoleLogging;

    public DefaultHandler(boolean consoleLogging, String fileName) throws FreeColException {
        this.consoleLogging = consoleLogging;
        File file = new File(fileName);
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new FreeColException("Log file \"" + fileName + "\" could not be created.");
            }
            if (file.isFile()) {
                file.delete();
            }
        }
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            throw new FreeColException("Log file \"" + fileName + "\" could not be created: " + e.getMessage());
        }
        if (!file.canWrite()) {
            throw new FreeColException("Can not write in log file \"" + fileName + "\".");
        }
        try {
            this.fileWriter = new FileWriter(file);
        }
        catch (IOException e) {
            throw new FreeColException("Can not write in log file \"" + fileName + "\".");
        }
        this.setFormatter(new TextFormatter());
        try {
            String str = "FreeCol game version: " + FreeCol.getRevision() + "\nFreeCol protocol version: " + DOMMessage.getFreeColProtocolVersion() + "\n\nJava vendor: " + System.getProperty("java.vendor") + "\nJava version: " + System.getProperty("java.version") + "\nJava WM name: " + System.getProperty("java.vm.name") + "\nJava WM vendor: " + System.getProperty("java.vm.vendor") + "\nJava WM version: " + System.getProperty("java.vm.version") + "\n\nOS name: " + System.getProperty("os.name") + "\nOS architecture: " + System.getProperty("os.arch") + "\nOS version: " + System.getProperty("os.version") + "\n\n";
            this.fileWriter.write(str, 0, str.length());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            this.fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void flush() {
        try {
            this.fileWriter.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void publish(LogRecord record) {
        if (record.getThrown() != null) {
            FreeColDebugger.handleCrash(record);
        }
        if (record.getLevel().intValue() < this.getLevel().intValue()) {
            return;
        }
        String str = this.getFormatter().format(record);
        if (this.consoleLogging && record.getLevel().intValue() >= Level.WARNING.intValue()) {
            System.err.println(str);
        }
        try {
            this.fileWriter.write(str, 0, str.length());
        }
        catch (IOException e) {
            System.err.println("Failed to write log record!");
            e.printStackTrace(System.err);
        }
        this.flush();
    }
}

