/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.common.resources.Resource;
import net.sf.freecol.common.resources.ResourceFactory;
import net.sf.freecol.common.resources.ResourceMapping;
import net.sf.freecol.common.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeColDataFile {
    private static final Logger logger = Logger.getLogger(FreeColDataFile.class.getName());
    private static final String FILE_PREFIX = "resources";
    private static final String FILE_SUFFIX = ".properties";
    private static final String resourceScheme = "resource:";
    private final File file;
    private final String jarDirectory;

    public FreeColDataFile(File file) {
        if (!file.exists()) {
            for (String ending : this.getFileEndings()) {
                File tempFile = new File(file.getAbsolutePath() + ending);
                if (!tempFile.exists()) continue;
                file = tempFile;
                break;
            }
        }
        this.file = file;
        this.jarDirectory = file.isDirectory() ? null : FreeColDataFile.findJarDirectory(file.getName().substring(0, file.getName().lastIndexOf(46)), file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String findJarDirectory(String expectedName, File file) {
        JarFile jf = null;
        try {
            jf = new JarFile(file);
            JarEntry entry = jf.entries().nextElement();
            String en = entry.getName();
            int index = en.lastIndexOf(47);
            String name = "";
            if (index > 0) {
                name = en.substring(0, index + 1);
            }
            String string = name;
            return string;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception while reading data file.", e);
            String string = expectedName;
            return string;
        }
        finally {
            try {
                jf.close();
            }
            catch (Exception e) {}
        }
    }

    public static List<String> getFileNames(String prefix, String suffix, String language, String country, String variant) {
        ArrayList<String> result = new ArrayList<String>(4);
        if (!language.equals("")) {
            language = "_" + language;
        }
        if (!country.equals("")) {
            country = "_" + country;
        }
        if (!variant.equals("")) {
            variant = "_" + variant;
        }
        result.add(prefix + suffix);
        String filename = prefix + language + suffix;
        if (!result.contains(filename)) {
            result.add(filename);
        }
        if (!result.contains(filename = prefix + language + country + suffix)) {
            result.add(filename);
        }
        if (!result.contains(filename = prefix + language + country + variant + suffix)) {
            result.add(filename);
        }
        return result;
    }

    public BufferedInputStream getInputStream(String filename) throws IOException {
        URLConnection connection = this.getURI(filename).toURL().openConnection();
        connection.setDefaultUseCaches(false);
        return new BufferedInputStream(connection.getInputStream());
    }

    protected URI getURI(String filename) {
        try {
            if (filename.startsWith("urn:")) {
                try {
                    return new URI(filename);
                }
                catch (URISyntaxException e) {
                    logger.log(Level.WARNING, "Resource creation failure with |" + filename + "|", e);
                    return null;
                }
            }
            if (this.file.isDirectory()) {
                return new File(this.file, filename).toURI();
            }
            return new URI("jar:file", this.file + "!/" + this.jarDirectory + filename, null);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to lookup: " + filename + " in: " + this.file, e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceMapping getResourceMapping() {
        Properties properties = new Properties();
        Locale locale = Locale.getDefault();
        for (String fileName : FreeColDataFile.getFileNames(FILE_PREFIX, FILE_SUFFIX, locale.getLanguage(), locale.getCountry(), locale.getVariant())) {
            try {
                BufferedInputStream is = this.getInputStream(fileName);
                try {
                    properties.load(is);
                    logger.info("Loaded ResourceMapping " + fileName + " from " + this.file + ".");
                }
                finally {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Exception e) {}
                }
            }
            catch (FileNotFoundException e) {
                logger.finest("No ResourceMapping " + fileName + " in " + this.file + ".");
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Exception while reading ResourceMapping from: " + this.file, e);
                return null;
            }
        }
        ResourceMapping rc = new ResourceMapping();
        ArrayList<String> todo = new ArrayList<String>();
        Enumeration<?> pn = properties.propertyNames();
        while (pn.hasMoreElements()) {
            String key = (String)pn.nextElement();
            String value = properties.getProperty(key);
            if (value.startsWith(resourceScheme)) {
                todo.add(key);
                continue;
            }
            URI uri = this.getURI(value);
            if (uri == null) continue;
            rc.add(key, ResourceFactory.createResource(uri));
        }
        boolean progress = true;
        ArrayList<String> miss = new ArrayList<String>();
        while (progress && !todo.isEmpty()) {
            miss.clear();
            progress = false;
            while (!todo.isEmpty()) {
                String key = (String)todo.remove(0);
                String value = properties.getProperty(key).substring(resourceScheme.length());
                Resource r = rc.get(value);
                if (r == null) {
                    miss.add(key);
                    continue;
                }
                rc.add(key, r);
                progress = true;
            }
            todo.addAll(miss);
        }
        if (!todo.isEmpty()) {
            logger.warning("Could not resolve virtual resource/s: " + Utils.join(" ", todo));
        }
        return rc;
    }

    public FileFilter getFileFilter() {
        return new FileFilter(){

            public boolean accept(File f) {
                String name = f.getName();
                for (String ending : FreeColDataFile.this.getFileEndings()) {
                    if (!name.endsWith(ending)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    protected String[] getFileEndings() {
        return new String[]{".zip"};
    }
}

