/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.common.model.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaleMapSizeDialog
extends FreeColDialog<Dimension> {
    public static final String COPYRIGHT = "Copyright (C) 2003-2012 The FreeCol Team";
    public static final String LICENSE = "http://www.gnu.org/licenses/gpl.html";
    public static final String REVISION = "$Revision: 10159 $";
    private static final int COLUMNS = 5;
    private Map oldMap;
    final JTextField inputWidth;
    final JTextField inputHeight;

    public ScaleMapSizeDialog(FreeColClient freeColClient, final GUI gui) {
        super(freeColClient, gui);
        this.inputWidth = new JTextField(Integer.toString(this.oldMap.getWidth()), 5);
        this.inputHeight = new JTextField(Integer.toString(this.oldMap.getHeight()), 5);
        this.oldMap = freeColClient.getGame().getMap();
        this.setLayout(new BoxLayout(this, 1));
        JPanel buttons = new JPanel();
        buttons.setOpaque(false);
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    int width = Integer.parseInt(ScaleMapSizeDialog.this.inputWidth.getText());
                    int height = Integer.parseInt(ScaleMapSizeDialog.this.inputHeight.getText());
                    if (width <= 0 || height <= 0) {
                        throw new NumberFormatException();
                    }
                    ScaleMapSizeDialog.this.setResponse(new Dimension(width, height));
                }
                catch (NumberFormatException nfe) {
                    gui.errorMessage("integerAboveZero");
                }
            }
        };
        JButton okButton = new JButton(Messages.message("ok"));
        buttons.add(okButton);
        JButton cancelButton = new JButton(Messages.message("cancel"));
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ScaleMapSizeDialog.this.setResponse(null);
            }
        });
        buttons.add(cancelButton);
        this.setCancelComponent(cancelButton);
        okButton.addActionListener(al);
        this.inputWidth.addActionListener(al);
        this.inputHeight.addActionListener(al);
        JLabel widthLabel = new JLabel(Messages.message("width"));
        widthLabel.setLabelFor(this.inputWidth);
        JLabel heightLabel = new JLabel(Messages.message("height"));
        heightLabel.setLabelFor(this.inputHeight);
        JPanel widthPanel = new JPanel(new FlowLayout());
        widthPanel.setOpaque(false);
        widthPanel.add(widthLabel);
        widthPanel.add(this.inputWidth);
        JPanel heightPanel = new JPanel(new FlowLayout());
        heightPanel.setOpaque(false);
        heightPanel.add(heightLabel);
        heightPanel.add(this.inputHeight);
        this.add(widthPanel);
        this.add(heightPanel);
        this.add(buttons);
        this.setSize(this.getPreferredSize());
    }

    @Override
    public void requestFocus() {
        this.inputWidth.requestFocus();
    }
}

