/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.ColopediaAction;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ColopediaGameObjectTypePanel;
import net.sf.freecol.client.gui.panel.ColopediaPanel;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcesDetailPanel
extends ColopediaGameObjectTypePanel<ResourceType> {
    public ResourcesDetailPanel(FreeColClient freeColClient, GUI gui, ColopediaPanel colopediaPanel) {
        super(freeColClient, gui, colopediaPanel, ColopediaAction.PanelType.RESOURCES.toString(), 0.75);
    }

    @Override
    public void addSubTrees(DefaultMutableTreeNode root) {
        super.addSubTrees(root, this.getSpecification().getResourceTypeList());
    }

    @Override
    public void buildDetail(String id, JPanel panel) {
        if (this.getId().equals(id)) {
            return;
        }
        ResourceType type = this.getSpecification().getResourceType(id);
        panel.setLayout((LayoutManager)new MigLayout("wrap 2", "[]20[]"));
        JLabel name = this.localizedLabel(type.getNameKey());
        name.setFont(smallHeaderFont);
        panel.add((Component)name, "span, align center, wrap 40");
        panel.add(this.localizedLabel("colopedia.resource.bonusProduction"));
        JPanel goodsPanel = new JPanel();
        goodsPanel.setOpaque(false);
        for (Modifier modifier : type.getModifiers()) {
            String text = this.getModifierAsString(modifier);
            if (modifier.hasScope()) {
                ArrayList<String> scopeStrings = new ArrayList<String>();
                for (Scope scope : modifier.getScopes()) {
                    if (scope.getType() == null) continue;
                    FreeColGameObjectType objectType = this.getSpecification().getType(scope.getType());
                    scopeStrings.add(Messages.message(objectType.getNameKey()));
                }
                if (!scopeStrings.isEmpty()) {
                    text = text + " (" + Utils.join(", ", scopeStrings) + ")";
                }
            }
            GoodsType goodsType = this.getSpecification().getGoodsType(modifier.getId());
            JButton goodsButton = this.getGoodsButton(goodsType, text);
            goodsPanel.add(goodsButton);
        }
        panel.add(goodsPanel);
        panel.add((Component)this.localizedLabel("colopedia.resource.description"), "newline 20");
        panel.add((Component)ResourcesDetailPanel.getDefaultTextArea(Messages.message(type.getDescriptionKey()), 30), "growx");
    }
}

