/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileFilter;
import java.util.Properties;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.OptionsDialog;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.io.FreeColSavegameFile;
import net.sf.freecol.common.option.FileOption;
import net.sf.freecol.common.option.OptionGroup;

public final class MapGeneratorOptionsDialog
extends OptionsDialog
implements ActionListener {
    private static final Logger logger = Logger.getLogger(MapGeneratorOptionsDialog.class.getName());
    public static final String OPTION_GROUP_ID = "mapGeneratorOptions";
    private JScrollPane scrollPane = null;

    public MapGeneratorOptionsDialog(FreeColClient freeColClient, GUI gui, OptionGroup mgo, boolean editable, boolean loadCustomOptions) {
        super(freeColClient, gui, editable);
        if (editable && loadCustomOptions) {
            this.loadCustomOptions();
        }
        if (editable) {
            JPanel mapPanel = new JPanel();
            File mapDirectory = FreeColDirectories.getMapsDirectory();
            if (mapDirectory.isDirectory()) {
                for (final File file : mapDirectory.listFiles(new FileFilter(){

                    public boolean accept(File file) {
                        return file.isFile() && file.getName().endsWith(".fsg");
                    }
                })) {
                    String mapName = file.getName().substring(0, file.getName().lastIndexOf(46));
                    JButton mapButton = new JButton(Messages.message("freecol.map." + mapName));
                    try {
                        FreeColSavegameFile savegame = new FreeColSavegameFile(file);
                        BufferedImage thumbnail = ImageIO.read(savegame.getInputStream("thumbnail.png"));
                        mapButton.setIcon(new ImageIcon(thumbnail));
                        try {
                            Properties properties = new Properties();
                            properties.load(savegame.getInputStream("savegame.properties"));
                            mapButton.setToolTipText(properties.getProperty("map.width") + "\u00d7" + properties.getProperty("map.height"));
                        }
                        catch (Exception e) {
                            logger.fine("Unable to load savegame properties.");
                        }
                        mapButton.setHorizontalTextPosition(0);
                        mapButton.setVerticalTextPosition(3);
                    }
                    catch (Exception e) {
                        logger.warning("Failed to read thumbnail.");
                    }
                    mapButton.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            MapGeneratorOptionsDialog.this.setFile(file);
                        }
                    });
                    mapPanel.add(mapButton);
                }
            }
            if (mapPanel.getComponentCount() > 0) {
                this.scrollPane = new JScrollPane(mapPanel, 21, 30);
                this.scrollPane.getVerticalScrollBar().setUnitIncrement(16);
                this.scrollPane.getViewport().setOpaque(false);
                this.scrollPane.setMinimumSize(new Dimension(400, 110));
            }
        }
        this.initialize(mgo, mgo.getName(), this.scrollPane);
    }

    public String getDefaultFileName() {
        return "map_generator_options.xml";
    }

    public String getOptionGroupId() {
        return OPTION_GROUP_ID;
    }

    private void setFile(File file) {
        OptionGroup group = this.getGroup();
        ((FileOption)group.getOption("model.option.importFile")).setValue(file);
        group.setBoolean("model.option.importRumours", false);
        group.setBoolean("model.option.importTerrain", true);
        group.setBoolean("model.option.importBonuses", false);
        this.getOptionUI().reset();
    }

    public void actionPerformed(ActionEvent event) {
        super.actionPerformed(event);
        String command = event.getActionCommand();
        if ("OK".equals(command)) {
            if (!this.getFreeColClient().isMapEditor()) {
                this.getFreeColClient().getPreGameController().sendMapGeneratorOptions();
            }
        } else {
            this.initialize(this.getGroup(), this.getGroup().getName(), this.scrollPane);
        }
    }
}

