/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring.history;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ltk.core.refactoring.RefactoringContribution;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;
import org.eclipse.ltk.internal.core.refactoring.history.DefaultRefactoringDescriptor;

public final class RefactoringContributionManager
implements IRegistryChangeListener {
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_ID = "id";
    private static RefactoringContributionManager fInstance = null;
    private static final String REFACTORING_CONTRIBUTIONS_EXTENSION_POINT = "refactoringContributions";
    private Map fContributionCache = null;

    public static RefactoringContributionManager getInstance() {
        if (fInstance == null) {
            fInstance = new RefactoringContributionManager();
        }
        return fInstance;
    }

    private RefactoringContributionManager() {
    }

    public void connect() {
        Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)this, "org.eclipse.ltk.core.refactoring");
    }

    public RefactoringDescriptor createDescriptor(String id, String project, String description, String comment, Map arguments, int flags) {
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)description);
        Assert.isNotNull((Object)arguments);
        Assert.isLegal((flags >= 0 ? 1 : 0) != 0);
        RefactoringContribution contribution = this.getRefactoringContribution(id);
        if (contribution != null) {
            return contribution.createDescriptor(id, project, description, comment, arguments, flags);
        }
        return new DefaultRefactoringDescriptor(id, project, description, comment, arguments, flags);
    }

    public void disconnect() {
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
    }

    public RefactoringContribution getRefactoringContribution(String id) {
        Assert.isNotNull((Object)id);
        Assert.isTrue((!"".equals(id) ? 1 : 0) != 0);
        if (this.fContributionCache == null) {
            this.fContributionCache = new HashMap();
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ltk.core.refactoring", REFACTORING_CONTRIBUTIONS_EXTENSION_POINT);
            int index = 0;
            while (index < elements.length) {
                block10: {
                    IConfigurationElement element = elements[index];
                    String attributeId = element.getAttribute(ATTRIBUTE_ID);
                    if (attributeId != null && !"".equals(attributeId)) {
                        String className = element.getAttribute(ATTRIBUTE_CLASS);
                        if (className != null && !"".equals(className)) {
                            try {
                                Object implementation = element.createExecutableExtension(ATTRIBUTE_CLASS);
                                if (implementation instanceof RefactoringContribution) {
                                    if (this.fContributionCache.get(attributeId) != null) {
                                        RefactoringCorePlugin.logErrorMessage(Messages.format(RefactoringCoreMessages.RefactoringCorePlugin_duplicate_warning, new String[]{attributeId, "org.eclipse.ltk.core.refactoring.refactoringContributions"}));
                                    }
                                    this.fContributionCache.put(attributeId, implementation);
                                    break block10;
                                }
                                RefactoringCorePlugin.logErrorMessage(Messages.format(RefactoringCoreMessages.RefactoringCorePlugin_creation_error, new String[]{"org.eclipse.ltk.core.refactoring.refactoringContributions", attributeId}));
                            }
                            catch (CoreException exception) {
                                RefactoringCorePlugin.log(exception);
                            }
                        } else {
                            RefactoringCorePlugin.logErrorMessage(Messages.format(RefactoringCoreMessages.RefactoringCorePlugin_missing_class_attribute, new String[]{"org.eclipse.ltk.core.refactoring.refactoringContributions", attributeId, ATTRIBUTE_CLASS}));
                        }
                    } else {
                        RefactoringCorePlugin.logErrorMessage(Messages.format(RefactoringCoreMessages.RefactoringCorePlugin_missing_attribute, new String[]{"org.eclipse.ltk.core.refactoring.refactoringContributions", ATTRIBUTE_ID}));
                    }
                }
                ++index;
            }
        }
        return (RefactoringContribution)this.fContributionCache.get(id);
    }

    public void registryChanged(IRegistryChangeEvent event) {
        this.fContributionCache = null;
    }
}

