/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import com.ibm.icu.text.Collator;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.ValidateEditException;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.OrganizeImportsOperation;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.QualifiedTypeNameHistory;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.jdt.internal.ui.dialogs.MultiElementListSelectionDialog;
import org.eclipse.jdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.WorkingCopyManager;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.util.ElementValidator;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.TypeInfoLabelProvider;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IEditingSupport;
import org.eclipse.jface.text.IEditingSupportRegistry;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.progress.IProgressService;

public class OrganizeImportsAction
extends SelectionDispatchAction {
    private static final OrganizeImportComparator ORGANIZE_IMPORT_COMPARATOR = new OrganizeImportComparator();
    private JavaEditor fEditor;
    private boolean fIsQueryShowing = false;

    public OrganizeImportsAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.OrganizeImportsAction_label);
        this.setToolTipText(ActionMessages.OrganizeImportsAction_tooltip);
        this.setDescription(ActionMessages.OrganizeImportsAction_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.organize_imports_action_context");
    }

    public OrganizeImportsAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(OrganizeImportsAction.getCompilationUnit(this.fEditor) != null);
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(OrganizeImportsAction.getCompilationUnit(this.fEditor) != null);
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.isEnabled(selection));
    }

    private ICompilationUnit[] getCompilationUnits(IStructuredSelection selection) {
        HashSet<IJavaElement> result = new HashSet<IJavaElement>();
        Object[] selected = selection.toArray();
        int i = 0;
        while (i < selected.length) {
            block17: {
                try {
                    if (selected[i] instanceof IJavaElement) {
                        IJavaElement elem = (IJavaElement)selected[i];
                        if (!elem.exists()) break block17;
                        switch (elem.getElementType()) {
                            case 7: {
                                if (elem.getParent().getElementType() == 5) {
                                    result.add(elem.getParent());
                                    break;
                                }
                                break block17;
                            }
                            case 5: {
                                result.add(elem);
                                break;
                            }
                            case 12: {
                                result.add(elem.getParent());
                                break;
                            }
                            case 4: {
                                this.collectCompilationUnits((IPackageFragment)elem, result);
                                break;
                            }
                            case 3: {
                                this.collectCompilationUnits((IPackageFragmentRoot)elem, result);
                                break;
                            }
                            case 2: {
                                IPackageFragmentRoot[] roots = ((IJavaProject)elem).getPackageFragmentRoots();
                                int k = 0;
                                while (k < roots.length) {
                                    this.collectCompilationUnits(roots[k], result);
                                    ++k;
                                }
                                break block1;
                            }
                        }
                        break block17;
                    }
                    if (selected[i] instanceof LogicalPackage) {
                        IPackageFragment[] packageFragments = ((LogicalPackage)((Object)selected[i])).getFragments();
                        int k = 0;
                        while (k < packageFragments.length) {
                            IPackageFragment pack = packageFragments[k];
                            if (pack.exists()) {
                                this.collectCompilationUnits(pack, result);
                            }
                            ++k;
                        }
                    }
                }
                catch (JavaModelException e) {
                    if (!JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) break block17;
                    JavaPlugin.log(e);
                }
            }
            ++i;
        }
        return result.toArray(new ICompilationUnit[result.size()]);
    }

    private void collectCompilationUnits(IPackageFragment pack, Collection result) throws JavaModelException {
        result.addAll((Collection)Arrays.asList(pack.getCompilationUnits()));
    }

    private void collectCompilationUnits(IPackageFragmentRoot root, Collection result) throws JavaModelException {
        if (root.getKind() == 1) {
            IJavaElement[] children = root.getChildren();
            int i = 0;
            while (i < children.length) {
                this.collectCompilationUnits((IPackageFragment)children[i], result);
                ++i;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isEnabled(IStructuredSelection selection) {
        Object[] selected = selection.toArray();
        int i = 0;
        while (i < selected.length) {
            block13: {
                try {
                    if (selected[i] instanceof IJavaElement) {
                        IJavaElement elem = (IJavaElement)selected[i];
                        if (elem.exists()) {
                            switch (elem.getElementType()) {
                                case 7: {
                                    return elem.getParent().getElementType() == 5;
                                }
                                case 5: {
                                    return true;
                                }
                                case 12: {
                                    return true;
                                }
                                case 3: 
                                case 4: {
                                    IPackageFragmentRoot root = (IPackageFragmentRoot)elem.getAncestor(3);
                                    return root.getKind() == 1;
                                }
                                case 2: {
                                    return true;
                                }
                            }
                        }
                        break block13;
                    }
                    if (selected[i] instanceof LogicalPackage) {
                        return true;
                    }
                }
                catch (JavaModelException e) {
                    if (e.isDoesNotExist()) break block13;
                    JavaPlugin.log(e);
                }
            }
            ++i;
        }
        return false;
    }

    public void run(ITextSelection selection) {
        ICompilationUnit cu = OrganizeImportsAction.getCompilationUnit(this.fEditor);
        if (cu != null) {
            this.run(cu);
        }
    }

    private static ICompilationUnit getCompilationUnit(JavaEditor editor) {
        WorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
        ICompilationUnit cu = manager.getWorkingCopy(editor.getEditorInput());
        return cu;
    }

    public void run(IStructuredSelection selection) {
        ICompilationUnit[] cus = this.getCompilationUnits(selection);
        if (cus.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.OrganizeImportsAction_EmptySelection_title, (String)ActionMessages.OrganizeImportsAction_EmptySelection_description);
        } else if (cus.length == 1) {
            this.run(cus[0]);
        } else {
            this.runOnMultiple(cus);
        }
    }

    public void runOnMultiple(final ICompilationUnit[] cus) {
        try {
            String message = ActionMessages.OrganizeImportsAction_multi_status_description;
            final MultiStatus status = new MultiStatus("org.eclipse.jdt.ui", 0, message, null);
            IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
            progressService.run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) {
                    OrganizeImportsAction.this.doRunOnMultiple(cus, status, monitor);
                }
            }));
            if (!status.isOK()) {
                String title = ActionMessages.OrganizeImportsAction_multi_status_title;
                ErrorDialog.openError((Shell)this.getShell(), (String)title, null, (IStatus)status);
            }
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), ActionMessages.OrganizeImportsAction_error_title, ActionMessages.OrganizeImportsAction_error_message);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void doRunOnMultiple(ICompilationUnit[] cus, MultiStatus status, IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.setTaskName(ActionMessages.OrganizeImportsAction_multi_op_description);
        monitor.beginTask("", cus.length);
        try {
            OrganizeImportsOperation.IChooseImportQuery query = new OrganizeImportsOperation.IChooseImportQuery(){

                public TypeInfo[] chooseImports(TypeInfo[][] openChoices, ISourceRange[] ranges) {
                    throw new OrganizeImportError();
                }
            };
            IJavaProject lastProject = null;
            int i = 0;
            while (i < cus.length) {
                ICompilationUnit cu = cus[i];
                if (this.testOnBuildPath(cu, status)) {
                    if (lastProject == null || !lastProject.equals(cu.getJavaProject())) {
                        lastProject = cu.getJavaProject();
                    }
                    CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings(lastProject);
                    String cuLocation = cu.getPath().makeRelative().toString();
                    monitor.subTask(cuLocation);
                    try {
                        boolean save;
                        boolean bl = save = !cu.isWorkingCopy();
                        if (!save) {
                            ITextFileBuffer textFileBuffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(cu.getPath());
                            save = textFileBuffer != null && !textFileBuffer.isDirty();
                        }
                        OrganizeImportsOperation op = new OrganizeImportsOperation(cu, null, settings.importIgnoreLowercase, save, true, query);
                        this.runInSync(op, cuLocation, status, monitor);
                        IProblem parseError = op.getParseError();
                        if (parseError != null) {
                            String message = Messages.format(ActionMessages.OrganizeImportsAction_multi_error_parse, cuLocation);
                            status.add((IStatus)new Status(1, "org.eclipse.jdt.ui", 4, message, null));
                        }
                    }
                    catch (CoreException e) {
                        JavaPlugin.log(e);
                        String message = Messages.format(ActionMessages.OrganizeImportsAction_multi_error_unexpected, e.getStatus().getMessage());
                        status.add((IStatus)new Status(4, "org.eclipse.jdt.ui", 4, message, null));
                    }
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    private boolean testOnBuildPath(ICompilationUnit cu, MultiStatus status) {
        IJavaProject project = cu.getJavaProject();
        if (!project.isOnClasspath((IJavaElement)cu)) {
            String cuLocation = cu.getPath().makeRelative().toString();
            String message = Messages.format(ActionMessages.OrganizeImportsAction_multi_error_notoncp, cuLocation);
            status.add((IStatus)new Status(1, "org.eclipse.jdt.ui", 4, message, null));
            return false;
        }
        return true;
    }

    private void runInSync(final OrganizeImportsOperation op, final String cuLocation, final MultiStatus status, final IProgressMonitor monitor) {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    op.run((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (ValidateEditException e) {
                    status.add(e.getStatus());
                }
                catch (CoreException e) {
                    JavaPlugin.log(e);
                    String message = Messages.format(ActionMessages.OrganizeImportsAction_multi_error_unexpected, e.getStatus().getMessage());
                    status.add((IStatus)new Status(4, "org.eclipse.jdt.ui", 4, message, null));
                }
                catch (OrganizeImportError organizeImportError) {
                    String message = Messages.format(ActionMessages.OrganizeImportsAction_multi_error_unresolvable, cuLocation);
                    status.add((IStatus)new Status(1, "org.eclipse.jdt.ui", 4, message, null));
                }
                catch (OperationCanceledException operationCanceledException) {
                    monitor.setCanceled(true);
                }
            }
        };
        this.getShell().getDisplay().syncExec(runnable);
    }

    public void run(ICompilationUnit cu) {
        if (!ElementValidator.check((IJavaElement)cu, this.getShell(), ActionMessages.OrganizeImportsAction_error_title, this.fEditor != null)) {
            return;
        }
        if (!ActionUtil.isProcessable(this.getShell(), cu)) {
            return;
        }
        IEditingSupport helper = this.createViewerHelper();
        try {
            IEditorPart editor;
            CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings(cu.getJavaProject());
            if (this.fEditor == null && EditorUtility.isOpenInEditor(cu) == null && (editor = EditorUtility.openInEditor(cu)) instanceof JavaEditor) {
                this.fEditor = (JavaEditor)editor;
            }
            CompilationUnit astRoot = JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)cu, ASTProvider.WAIT_ACTIVE_ONLY, null);
            OrganizeImportsOperation op = new OrganizeImportsOperation(cu, astRoot, settings.importIgnoreLowercase, !cu.isWorkingCopy(), true, this.createChooseImportQuery());
            IRewriteTarget target = null;
            if (this.fEditor != null && (target = (IRewriteTarget)this.fEditor.getAdapter(IRewriteTarget.class)) != null) {
                target.beginCompoundChange();
            }
            IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
            IWorkbenchWindow context = this.getSite().getWorkbenchWindow();
            if (context == null) {
                context = progressService;
            }
            try {
                try {
                    this.registerHelper(helper);
                    progressService.runInUI((IRunnableContext)context, (IRunnableWithProgress)new WorkbenchRunnableAdapter(op, op.getScheduleRule()), op.getScheduleRule());
                    IProblem parseError = op.getParseError();
                    if (parseError != null) {
                        String message = Messages.format(ActionMessages.OrganizeImportsAction_single_error_parse, parseError.getMessage());
                        MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.OrganizeImportsAction_error_title, (String)message);
                        if (this.fEditor != null && parseError.getSourceStart() != -1) {
                            this.fEditor.selectAndReveal(parseError.getSourceStart(), parseError.getSourceEnd() - parseError.getSourceStart() + 1);
                        }
                    } else if (this.fEditor != null) {
                        this.setStatusBarMessage(this.getOrganizeInfo(op));
                    }
                }
                catch (InvocationTargetException e) {
                    ExceptionHandler.handle(e, this.getShell(), ActionMessages.OrganizeImportsAction_error_title, ActionMessages.OrganizeImportsAction_error_message);
                }
                catch (InterruptedException interruptedException) {}
            }
            finally {
                this.deregisterHelper(helper);
                if (target != null) {
                    target.endCompoundChange();
                }
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), ActionMessages.OrganizeImportsAction_error_title, ActionMessages.OrganizeImportsAction_error_message);
        }
    }

    private String getOrganizeInfo(OrganizeImportsOperation op) {
        int nImportsAdded = op.getNumberOfImportsAdded();
        if (nImportsAdded >= 0) {
            return Messages.format(ActionMessages.OrganizeImportsAction_summary_added, String.valueOf(nImportsAdded));
        }
        return Messages.format(ActionMessages.OrganizeImportsAction_summary_removed, String.valueOf(-nImportsAdded));
    }

    private OrganizeImportsOperation.IChooseImportQuery createChooseImportQuery() {
        return new OrganizeImportsOperation.IChooseImportQuery(){

            public TypeInfo[] chooseImports(TypeInfo[][] openChoices, ISourceRange[] ranges) {
                return OrganizeImportsAction.this.doChooseImports(openChoices, ranges);
            }
        };
    }

    private TypeInfo[] doChooseImports(TypeInfo[][] openChoices, final ISourceRange[] ranges) {
        ISelection sel = this.fEditor != null ? this.fEditor.getSelectionProvider().getSelection() : null;
        TypeInfo[] result = null;
        TypeInfoLabelProvider labelProvider = new TypeInfoLabelProvider(1);
        MultiElementListSelectionDialog dialog = new MultiElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider){

            protected void handleSelectionChanged() {
                super.handleSelectionChanged();
                OrganizeImportsAction.this.doListSelectionChanged(this.getCurrentPage(), ranges);
            }
        };
        this.fIsQueryShowing = true;
        dialog.setTitle(ActionMessages.OrganizeImportsAction_selectiondialog_title);
        dialog.setMessage(ActionMessages.OrganizeImportsAction_selectiondialog_message);
        dialog.setElements(openChoices);
        dialog.setComparator(ORGANIZE_IMPORT_COMPARATOR);
        if (dialog.open() == 0) {
            Object[] res = dialog.getResult();
            result = new TypeInfo[res.length];
            int i = 0;
            while (i < res.length) {
                Object[] array = (Object[])res[i];
                if (array.length > 0) {
                    result[i] = (TypeInfo)array[0];
                    QualifiedTypeNameHistory.remember(result[i].getFullyQualifiedName());
                }
                ++i;
            }
        }
        if (sel instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)sel;
            this.fEditor.selectAndReveal(textSelection.getOffset(), textSelection.getLength());
        }
        this.fIsQueryShowing = false;
        return result;
    }

    private void doListSelectionChanged(int page, ISourceRange[] ranges) {
        if (this.fEditor != null && ranges != null && page >= 0 && page < ranges.length) {
            ISourceRange range = ranges[page];
            this.fEditor.selectAndReveal(range.getOffset(), range.getLength());
        }
    }

    private void setStatusBarMessage(String message) {
        IEditorActionBarContributor contributor = this.fEditor.getEditorSite().getActionBarContributor();
        if (contributor instanceof EditorActionBarContributor) {
            IStatusLineManager manager = ((EditorActionBarContributor)contributor).getActionBars().getStatusLineManager();
            manager.setMessage(message);
        }
    }

    private IEditingSupport createViewerHelper() {
        return new IEditingSupport(){

            public boolean isOriginator(DocumentEvent event, IRegion subjectRegion) {
                return true;
            }

            public boolean ownsFocusShell() {
                return OrganizeImportsAction.this.fIsQueryShowing;
            }
        };
    }

    private void registerHelper(IEditingSupport helper) {
        if (this.fEditor == null) {
            return;
        }
        ISourceViewer viewer = this.fEditor.getViewer();
        if (viewer instanceof IEditingSupportRegistry) {
            IEditingSupportRegistry registry = (IEditingSupportRegistry)viewer;
            registry.register(helper);
        }
    }

    private void deregisterHelper(IEditingSupport helper) {
        if (this.fEditor == null) {
            return;
        }
        ISourceViewer viewer = this.fEditor.getViewer();
        if (viewer instanceof IEditingSupportRegistry) {
            IEditingSupportRegistry registry = (IEditingSupportRegistry)viewer;
            registry.unregister(helper);
        }
    }

    public static class ObjectDelegate
    implements IObjectActionDelegate {
        private OrganizeImportsAction fAction;

        public void setActivePart(IAction action, IWorkbenchPart targetPart) {
            this.fAction = new OrganizeImportsAction((IWorkbenchSite)targetPart.getSite());
        }

        public void run(IAction action) {
            this.fAction.run();
        }

        public void selectionChanged(IAction action, ISelection selection) {
            if (this.fAction == null) {
                action.setEnabled(false);
            }
        }
    }

    private static final class OrganizeImportComparator
    implements Comparator {
        private OrganizeImportComparator() {
        }

        public int compare(Object o1, Object o2) {
            int pos2;
            if (((String)o1).equals(o2)) {
                return 0;
            }
            QualifiedTypeNameHistory history = QualifiedTypeNameHistory.getDefault();
            int pos1 = history.getPosition(o1);
            if (pos1 == (pos2 = history.getPosition(o2))) {
                return Collator.getInstance().compare(o1, o2);
            }
            if (pos1 > pos2) {
                return -1;
            }
            return 1;
        }
    }

    static final class OrganizeImportError
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        OrganizeImportError() {
        }
    }
}

