/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackager;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackageActionDelegate;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.jarpackager.IJarDescriptionReader;
import org.eclipse.jdt.ui.jarpackager.IJarExportRunnable;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CreateJarActionDelegate
extends JarPackageActionDelegate {
    public void run(IAction action) {
        MultiStatus mergedStatus;
        IFile[] descriptions = this.getDescriptionFiles(this.getSelection());
        int length = descriptions.length;
        if (length < 1) {
            return;
        }
        String message = length > 1 ? JarPackagerMessages.JarFileExportOperation_creationOfSomeJARsFailed : JarPackagerMessages.JarFileExportOperation_jarCreationFailed;
        MultiStatus readStatus = new MultiStatus(JavaPlugin.getPluginId(), 0, message, null);
        JarPackageData[] jarPackages = this.readJarPackages(descriptions, readStatus);
        if (jarPackages.length > 0) {
            IStatus status = this.export(jarPackages);
            if (status == null) {
                return;
            }
            message = readStatus.getSeverity() == 4 ? readStatus.getMessage() : status.getMessage();
            mergedStatus = new MultiStatus(JavaPlugin.getPluginId(), status.getCode(), readStatus.getChildren(), message, null);
            mergedStatus.merge(status);
        } else {
            mergedStatus = readStatus;
        }
        if (!mergedStatus.isOK()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)JarPackagerMessages.CreateJarActionDelegate_jarExport_title, null, (IStatus)mergedStatus);
        }
    }

    private JarPackageData[] readJarPackages(IFile[] descriptions, MultiStatus readStatus) {
        ArrayList<JarPackageData> jarPackagesList = new ArrayList<JarPackageData>(descriptions.length);
        int i = 0;
        while (i < descriptions.length) {
            JarPackageData jarPackage = this.readJarPackage(descriptions[i], readStatus);
            if (jarPackage != null) {
                jarPackagesList.add(jarPackage);
            }
            ++i;
        }
        return jarPackagesList.toArray(new JarPackageData[jarPackagesList.size()]);
    }

    private IStatus export(JarPackageData[] jarPackages) {
        Shell shell = this.getShell();
        IJarExportRunnable op = jarPackages[0].createJarExportRunnable(jarPackages, shell);
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() != null) {
                ExceptionHandler.handle(ex, shell, JarPackagerMessages.CreateJarActionDelegate_jarExportError_title, JarPackagerMessages.CreateJarActionDelegate_jarExportError_message);
                return null;
            }
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        return op.getStatus();
    }

    protected JarPackageData readJarPackage(IFile description, MultiStatus readStatus) {
        Assert.isLegal((boolean)description.isAccessible());
        Assert.isNotNull((Object)description.getFileExtension());
        Assert.isLegal((boolean)description.getFileExtension().equals("jardesc"));
        JarPackageData jarPackage = new JarPackageData();
        IJarDescriptionReader reader = null;
        try {
            try {
                reader = jarPackage.createJarDescriptionReader(description.getContents());
                reader.read(jarPackage);
                jarPackage.setSaveManifest(false);
                jarPackage.setSaveDescription(false);
            }
            catch (CoreException ex) {
                String message = Messages.format(JarPackagerMessages.JarFileExportOperation_errorReadingFile, new Object[]{description.getFullPath(), ex.getStatus().getMessage()});
                this.addToStatus(readStatus, jarPackage, message, ex);
                if (reader != null) {
                    readStatus.addAll(reader.getStatus());
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (CoreException ex2) {
                    String message2 = Messages.format(JarPackagerMessages.JarFileExportOperation_errorClosingJarPackageDescriptionReader, description.getFullPath());
                    this.addToStatus(readStatus, jarPackage, message2, ex2);
                }
                return null;
            }
        }
        finally {
            if (reader != null) {
                readStatus.addAll(reader.getStatus());
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (CoreException ex) {
                String string = Messages.format(JarPackagerMessages.JarFileExportOperation_errorClosingJarPackageDescriptionReader, description.getFullPath());
                this.addToStatus(readStatus, jarPackage, string, ex);
            }
        }
        return jarPackage;
    }

    protected void addToStatus(MultiStatus multiStatus, JarPackageData jarPackage, String defaultMessage, CoreException ex) {
        IStatus status = ex.getStatus();
        String message = ex.getLocalizedMessage();
        if (message == null || message.length() < 1) {
            status = new Status(status.getSeverity(), status.getPlugin(), status.getCode(), defaultMessage, (Throwable)ex);
        }
        multiStatus.add(status);
    }
}

