/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.apt.core.internal.AptProject;
import org.eclipse.jdt.apt.core.internal.generatedfile.GeneratedResourceChangeListener;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.osgi.framework.BundleContext;

public class AptPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.jdt.apt.core";
    public static final int STATUS_EXCEPTION = 1;
    public static final int STATUS_NOTOOLSJAR = 2;
    public static final int STATUS_CANTLOADPLUGINFACTORY = 3;
    public static final String APT_BATCH_PROCESSOR_PROBLEM_MARKER = "org.eclipse.jdt.apt.core.marker";
    public static final String APT_LOADER_PROBLEM_MARKER = "org.eclipse.jdt.apt.core.buildproblem";
    public static final String APT_CONFIG_PROBLEM_MARKER = "org.eclipse.jdt.apt.core.configproblem";
    public static final String APT_COMPILATION_PROBLEM_MARKER = "org.eclipse.jdt.apt.core.compile.problem";
    private static AptPlugin thePlugin = null;
    private static final Map<IJavaProject, AptProject> PROJECT_MAP = new HashMap<IJavaProject, AptProject>();
    public static boolean DEBUG = false;
    public static final String APT_DEBUG_OPTION = "org.eclipse.jdt.apt.core/debug";

    public void start(BundleContext context) throws Exception {
        thePlugin = this;
        super.start(context);
        this.initDebugTracing();
        AptConfig.initialize();
        int mask = 15;
        JavaCore.addPreProcessingResourceChangedListener((IResourceChangeListener)new GeneratedResourceChangeListener(), (int)mask);
        if (DEBUG) {
            AptPlugin.trace("registered resource change listener");
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static AptPlugin getPlugin() {
        return thePlugin;
    }

    public static void log(IStatus status) {
        thePlugin.getLog().log(status);
    }

    public static void log(Throwable e, String message) {
        AptPlugin.log((IStatus)new Status(4, PLUGIN_ID, 1, message, e));
    }

    public static void logWarning(Throwable e, String message) {
        AptPlugin.log((IStatus)AptPlugin.createWarningStatus(e, message));
    }

    public static Status createStatus(Throwable e, String message) {
        return new Status(4, PLUGIN_ID, 1, message, e);
    }

    public static Status createWarningStatus(Throwable e, String message) {
        return new Status(2, PLUGIN_ID, 1, message, e);
    }

    public static Status createInfoStatus(Throwable e, String message) {
        return new Status(1, PLUGIN_ID, 1, message, e);
    }

    private void initDebugTracing() {
        String option = Platform.getDebugOption((String)APT_DEBUG_OPTION);
        if (option != null) {
            DEBUG = option.equalsIgnoreCase("true");
        }
    }

    public static void trace(String msg) {
        if (DEBUG) {
            System.err.println("[ " + Thread.currentThread().getName() + " ] " + msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AptProject getAptProject(IJavaProject javaProject, boolean create) {
        Map<IJavaProject, AptProject> map = PROJECT_MAP;
        synchronized (map) {
            AptProject aptProject = PROJECT_MAP.get(javaProject);
            if (aptProject != null) {
                return aptProject;
            }
            if (create) {
                aptProject = new AptProject(javaProject);
                PROJECT_MAP.put(javaProject, aptProject);
                return aptProject;
            }
            return null;
        }
    }

    public static AptProject getAptProject(IJavaProject javaProject) {
        return AptPlugin.getAptProject(javaProject, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAptProject(IJavaProject javaProject) {
        Map<IJavaProject, AptProject> map = PROJECT_MAP;
        synchronized (map) {
            PROJECT_MAP.remove(javaProject);
        }
    }
}

